/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.kylin.shaded.com.google.common.base.Supplier;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Multimap;
import org.apache.kylin.shaded.com.google.common.collect.Multimaps;

public enum ExecutableState {
    READY,
    RUNNING,
    ERROR,
    STOPPED,
    DISCARDED,
    SUCCEED;

    private static Multimap<ExecutableState, ExecutableState> VALID_STATE_TRANSFER;

    public boolean isFinalState() {
        return this == SUCCEED || this == DISCARDED;
    }

    public static boolean isValidStateTransfer(ExecutableState from, ExecutableState to) {
        return VALID_STATE_TRANSFER.containsEntry((Object)from, (Object)to);
    }

    public boolean isProgressing() {
        return this == READY || this == RUNNING;
    }

    static {
        VALID_STATE_TRANSFER = Multimaps.newSetMultimap(Maps.newEnumMap(ExecutableState.class), new Supplier<Set<ExecutableState>>(){

            @Override
            public Set<ExecutableState> get() {
                return new CopyOnWriteArraySet<ExecutableState>();
            }
        });
        VALID_STATE_TRANSFER.put(READY, RUNNING);
        VALID_STATE_TRANSFER.put(READY, ERROR);
        VALID_STATE_TRANSFER.put(READY, DISCARDED);
        VALID_STATE_TRANSFER.put(RUNNING, READY);
        VALID_STATE_TRANSFER.put(RUNNING, SUCCEED);
        VALID_STATE_TRANSFER.put(RUNNING, DISCARDED);
        VALID_STATE_TRANSFER.put(RUNNING, ERROR);
        VALID_STATE_TRANSFER.put(STOPPED, DISCARDED);
        VALID_STATE_TRANSFER.put(STOPPED, READY);
        VALID_STATE_TRANSFER.put(ERROR, DISCARDED);
        VALID_STATE_TRANSFER.put(ERROR, READY);
        VALID_STATE_TRANSFER.put(READY, STOPPED);
        VALID_STATE_TRANSFER.put(RUNNING, STOPPED);
        VALID_STATE_TRANSFER.put(SUCCEED, READY);
    }
}

