/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.threadpool;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.impl.threadpool.DefaultContext;
import org.apache.kylin.job.impl.threadpool.FetcherRunner;
import org.apache.kylin.job.impl.threadpool.JobExecutor;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityFetcherRunner
extends FetcherRunner {
    private static final Logger logger = LoggerFactory.getLogger(PriorityFetcherRunner.class);
    private volatile PriorityQueue<Pair<AbstractExecutable, Integer>> jobPriorityQueue = new PriorityQueue<Pair<AbstractExecutable, Integer>>(1, new Comparator<Pair<AbstractExecutable, Integer>>(){

        @Override
        public int compare(Pair<AbstractExecutable, Integer> o1, Pair<AbstractExecutable, Integer> o2) {
            return o1.getSecond() > o2.getSecond() ? -1 : 1;
        }
    });

    public PriorityFetcherRunner(JobEngineConfig jobEngineConfig, DefaultContext context, JobExecutor jobExecutor) {
        super(jobEngineConfig, context, jobExecutor);
    }

    @Override
    public synchronized void run() {
        try (SetThreadName ignored = new SetThreadName("PriorityFetcherRunner %s", System.identityHashCode(this));){
            Pair<AbstractExecutable, Integer> executableWithPriority;
            HashMap<String, Integer> leftJobPriorities = Maps.newHashMap();
            while ((executableWithPriority = this.jobPriorityQueue.peek()) != null && executableWithPriority.getSecond() >= this.jobEngineConfig.getFetchQueuePriorityBar()) {
                executableWithPriority = this.jobPriorityQueue.poll();
                AbstractExecutable executable = executableWithPriority.getFirst();
                int curPriority = executableWithPriority.getSecond();
                if (curPriority > executable.getDefaultPriority() + 1) {
                    this.addToJobPool(executable, curPriority);
                    continue;
                }
                leftJobPriorities.put(executable.getId(), curPriority + 1);
            }
            Map<String, Executable> runningJobs = this.context.getRunningJobs();
            if (this.isJobPoolFull()) {
                return;
            }
            while ((executableWithPriority = this.jobPriorityQueue.poll()) != null) {
                leftJobPriorities.put(executableWithPriority.getFirst().getId(), executableWithPriority.getSecond() + 1);
            }
            nRunning = 0;
            nReady = 0;
            nStopped = 0;
            nOthers = 0;
            nError = 0;
            nDiscarded = 0;
            nSUCCEED = 0;
            for (String id : this.getExecutableManager().getAllJobIdsInCache()) {
                Output outputDigest;
                if (runningJobs.containsKey(id)) {
                    ++nRunning;
                    continue;
                }
                if (this.succeedJobs.contains(id)) {
                    ++nSUCCEED;
                    continue;
                }
                try {
                    outputDigest = this.getExecutableManager().getOutputDigest(id);
                }
                catch (IllegalArgumentException e) {
                    logger.warn("job " + id + " output digest is null, skip.", e);
                    ++nOthers;
                    continue;
                }
                if (outputDigest.getState() != ExecutableState.READY) {
                    this.jobStateCount(id);
                    continue;
                }
                AbstractExecutable executable = this.getExecutableManager().getJob(id);
                if (executable == null) {
                    logger.info("job " + id + " get job is null, skip.");
                    ++nOthers;
                    continue;
                }
                if (!executable.isReady()) {
                    ++nOthers;
                    continue;
                }
                KylinConfig config = this.jobEngineConfig.getConfig();
                if (config.isSchedulerSafeMode()) {
                    String cubeName = executable.getCubeName();
                    String projectName = CubeManager.getInstance(config).getCube(cubeName).getProject();
                    if (!config.getSafeModeRunnableProjects().contains(projectName) && executable.getStartTime() == 0L) {
                        logger.info("New job is pending for scheduler in safe mode. Project: {}, job: {}", (Object)projectName, (Object)executable.getName());
                        continue;
                    }
                }
                ++nReady;
                Integer priority = (Integer)leftJobPriorities.get(id);
                if (priority == null) {
                    priority = executable.getPriority();
                }
                this.jobPriorityQueue.add(new Pair<AbstractExecutable, Integer>(executable, priority));
            }
            while ((executableWithPriority = this.jobPriorityQueue.poll()) != null && !this.isJobPoolFull()) {
                this.addToJobPool(executableWithPriority.getFirst(), executableWithPriority.getSecond());
            }
            this.fetchFailed = false;
            logger.info("Priority Job Fetcher: " + nRunning + " running, " + runningJobs.size() + " actual running, " + nStopped + " stopped, " + nReady + " ready, " + this.jobPriorityQueue.size() + " waiting, " + nSUCCEED + " already succeed, " + nError + " error, " + nDiscarded + " discarded, " + nOthers + " others");
        }
        catch (Throwable th) {
            this.fetchFailed = true;
            logger.warn("Priority Job Fetcher caught a exception " + th);
        }
    }
}

