/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.metrics;

import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metrics.MetricsManager;
import org.apache.kylin.metrics.lib.impl.RecordEvent;
import org.apache.kylin.metrics.lib.impl.TimedRecordEvent;
import org.apache.kylin.metrics.property.JobPropertyEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMetricsFacade {
    private static final Logger logger = LoggerFactory.getLogger(JobMetricsFacade.class);

    public static void updateMetrics(JobStatisticsResult jobStats) {
        TimedRecordEvent metricsEvent;
        if (!KylinConfig.getInstanceFromEnv().isKylinMetricsReporterForJobEnabled()) {
            return;
        }
        if (jobStats.throwable == null) {
            metricsEvent = new TimedRecordEvent(KylinConfig.getInstanceFromEnv().getKylinMetricsSubjectJob());
            JobMetricsFacade.setJobWrapper(metricsEvent, jobStats.user, jobStats.projectName, jobStats.cubeName, jobStats.jobId, jobStats.jobType, jobStats.cubingType);
            JobMetricsFacade.setJobStats(metricsEvent, jobStats.tableSize, jobStats.cubeSize, jobStats.buildDuration, jobStats.waitResourceTime, jobStats.perBytesTimeCost, jobStats.dColumnDistinct, jobStats.dDictBuilding, jobStats.dCubingInmem, jobStats.dHfileConvert);
        } else {
            metricsEvent = new TimedRecordEvent(KylinConfig.getInstanceFromEnv().getKylinMetricsSubjectJobException());
            JobMetricsFacade.setJobExceptionWrapper(metricsEvent, jobStats.user, jobStats.projectName, jobStats.cubeName, jobStats.jobId, jobStats.jobType, jobStats.cubingType, jobStats.throwable);
        }
        MetricsManager.getInstance().update(metricsEvent);
    }

    private static void setJobWrapper(RecordEvent metricsEvent, String user, String projectName, String cubeName, String jobId, String jobType, String cubingType) {
        metricsEvent.put(JobPropertyEnum.USER.toString(), (Object)user);
        metricsEvent.put(JobPropertyEnum.PROJECT.toString(), (Object)projectName);
        metricsEvent.put(JobPropertyEnum.CUBE.toString(), (Object)cubeName);
        metricsEvent.put(JobPropertyEnum.ID_CODE.toString(), (Object)jobId);
        metricsEvent.put(JobPropertyEnum.TYPE.toString(), (Object)jobType);
        metricsEvent.put(JobPropertyEnum.ALGORITHM.toString(), (Object)cubingType);
    }

    private static void setJobStats(RecordEvent metricsEvent, long tableSize, long cubeSize, long buildDuration, long waitResourceTime, double perBytesTimeCost, long dColumnDistinct, long dDictBuilding, long dCubingInmem, long dHfileConvert) {
        metricsEvent.put(JobPropertyEnum.SOURCE_SIZE.toString(), (Object)tableSize);
        metricsEvent.put(JobPropertyEnum.CUBE_SIZE.toString(), (Object)cubeSize);
        metricsEvent.put(JobPropertyEnum.BUILD_DURATION.toString(), (Object)buildDuration);
        metricsEvent.put(JobPropertyEnum.WAIT_RESOURCE_TIME.toString(), (Object)waitResourceTime);
        metricsEvent.put(JobPropertyEnum.PER_BYTES_TIME_COST.toString(), (Object)perBytesTimeCost);
        metricsEvent.put(JobPropertyEnum.STEP_DURATION_DISTINCT_COLUMNS.toString(), (Object)dColumnDistinct);
        metricsEvent.put(JobPropertyEnum.STEP_DURATION_DICTIONARY.toString(), (Object)dDictBuilding);
        metricsEvent.put(JobPropertyEnum.STEP_DURATION_INMEM_CUBING.toString(), (Object)dCubingInmem);
        metricsEvent.put(JobPropertyEnum.STEP_DURATION_HFILE_CONVERT.toString(), (Object)dHfileConvert);
    }

    private static <T extends Throwable> void setJobExceptionWrapper(RecordEvent metricsEvent, String user, String projectName, String cubeName, String jobId, String jobType, String cubingType, Throwable throwable) {
        JobMetricsFacade.setJobWrapper(metricsEvent, user, projectName, cubeName, jobId, jobType, cubingType);
        metricsEvent.put(JobPropertyEnum.EXCEPTION.toString(), (Object)throwable.getClass().getName());
        metricsEvent.put(JobPropertyEnum.EXCEPTION_MSG.toString(), (Object)throwable.getMessage());
    }

    public static class JobStatisticsResult {
        private String user;
        private String projectName;
        private String cubeName;
        private String jobId;
        private String jobType;
        private String cubingType;
        private long tableSize;
        private long cubeSize;
        private long buildDuration;
        private long waitResourceTime;
        private double perBytesTimeCost;
        private long dColumnDistinct = 0L;
        private long dDictBuilding = 0L;
        private long dCubingInmem = 0L;
        private long dHfileConvert = 0L;
        private Throwable throwable;

        public void setWrapper(String user, String projectName, String cubeName, String jobId, String jobType, String cubingType) {
            this.user = user;
            this.projectName = projectName == null ? null : projectName.toUpperCase(Locale.ROOT);
            this.cubeName = cubeName;
            this.jobId = jobId;
            this.jobType = jobType;
            this.cubingType = cubingType;
        }

        public void setJobStats(long tableSize, long cubeSize, long buildDuration, long waitResourceTime, double perBytesTimeCost) {
            this.tableSize = tableSize;
            this.cubeSize = cubeSize;
            this.buildDuration = buildDuration;
            this.waitResourceTime = waitResourceTime;
            this.perBytesTimeCost = perBytesTimeCost;
        }

        public void setJobStepStats(long dColumnDistinct, long dDictBuilding, long dCubingInmem, long dHfileConvert) {
            this.dColumnDistinct = dColumnDistinct;
            this.dDictBuilding = dDictBuilding;
            this.dCubingInmem = dCubingInmem;
            this.dHfileConvert = dHfileConvert;
        }

        public void setJobException(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

