/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.StringSerializer;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class StringTupleExpression
extends TupleExpression {
    public static final StringSerializer serializer = new StringSerializer(DataType.getType("varchar"));
    private String value;

    public StringTupleExpression(String value) {
        super(TupleExpression.ExpressionOperatorEnum.STRING, Collections.emptyList());
        this.value = value;
    }

    @Override
    public void verify() {
    }

    @Override
    public String calculate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        return this.value;
    }

    @Override
    public TupleExpression accept(ExpressionVisitor visitor) {
        return visitor.visitString(this);
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        serializer.serialize(this.value, buffer);
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.value = serializer.deserialize(buffer);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringTupleExpression that = (StringTupleExpression)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

