/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import java.util.Arrays;
import org.apache.kylin.metadata.filter.StringCodeSystem;
import org.apache.kylin.metadata.filter.TsConditionEraser;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;

public class StreamSQLDigest {
    private final SQLDigest sqlDigest;
    private final int hashCode;
    private final byte[] filterSerialized;

    public StreamSQLDigest(SQLDigest sqlDigest, TblColRef tsCol) {
        this.sqlDigest = sqlDigest;
        TsConditionEraser decorator = new TsConditionEraser(tsCol, sqlDigest.filter);
        this.filterSerialized = TupleFilterSerializer.serialize(sqlDigest.filter, decorator, StringCodeSystem.INSTANCE);
        int nonFilterHashCode = this.calculateNonFilterHashCode();
        this.hashCode = 31 * nonFilterHashCode + Arrays.hashCode(this.filterSerialized);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSQLDigest other = (StreamSQLDigest)o;
        if (this.filterSerialized != null ? !Arrays.equals(this.filterSerialized, other.filterSerialized) : other.filterSerialized != null) {
            return false;
        }
        if (this.sqlDigest.aggregations != null ? !this.sqlDigest.aggregations.equals(other.sqlDigest.aggregations) : other.sqlDigest.aggregations != null) {
            return false;
        }
        if (this.sqlDigest.allColumns != null ? !this.sqlDigest.allColumns.equals(other.sqlDigest.allColumns) : other.sqlDigest.allColumns != null) {
            return false;
        }
        if (this.sqlDigest.factTable != null ? !this.sqlDigest.factTable.equals(other.sqlDigest.factTable) : other.sqlDigest.factTable != null) {
            return false;
        }
        if (this.sqlDigest.filterColumns != null ? !this.sqlDigest.filterColumns.equals(other.sqlDigest.filterColumns) : other.sqlDigest.filterColumns != null) {
            return false;
        }
        if (this.sqlDigest.groupbyColumns != null ? !this.sqlDigest.groupbyColumns.equals(other.sqlDigest.groupbyColumns) : other.sqlDigest.groupbyColumns != null) {
            return false;
        }
        if (this.sqlDigest.joinDescs != null ? !this.sqlDigest.joinDescs.equals(other.sqlDigest.joinDescs) : other.sqlDigest.joinDescs != null) {
            return false;
        }
        return !(this.sqlDigest.metricColumns != null ? !this.sqlDigest.metricColumns.equals(other.sqlDigest.metricColumns) : other.sqlDigest.metricColumns != null);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int calculateNonFilterHashCode() {
        int result = this.sqlDigest.factTable != null ? this.sqlDigest.factTable.hashCode() : 0;
        result = 31 * result + (this.sqlDigest.joinDescs != null ? this.sqlDigest.joinDescs.hashCode() : 0);
        result = 31 * result + (this.sqlDigest.allColumns != null ? this.sqlDigest.allColumns.hashCode() : 0);
        result = 31 * result + (this.sqlDigest.groupbyColumns != null ? this.sqlDigest.groupbyColumns.hashCode() : 0);
        result = 31 * result + (this.sqlDigest.filterColumns != null ? this.sqlDigest.filterColumns.hashCode() : 0);
        result = 31 * result + (this.sqlDigest.metricColumns != null ? this.sqlDigest.metricColumns.hashCode() : 0);
        result = 31 * result + (this.sqlDigest.aggregations != null ? this.sqlDigest.aggregations.hashCode() : 0);
        return result;
    }
}

