/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.pushdown;

import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.metadata.cube.StructField;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.query.pushdown.PushdownResponse;
import org.apache.kylin.query.pushdown.SparkSubmitter;
import org.apache.kylin.source.adhocquery.AbstractPushdownRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDownRunnerSparkImpl
extends AbstractPushdownRunner {
    public static final Logger logger = LoggerFactory.getLogger(PushDownRunnerSparkImpl.class);

    @Override
    public void init(KylinConfig config) {
    }

    @Override
    public void executeQuery(String query, List<List<String>> results, List<SelectedColumnMeta> columnMetas) {
        PushdownResponse response = this.queryWithPushDown(query);
        int columnCount = response.getColumns().size();
        List<StructField> fieldList = response.getColumns();
        results.addAll(response.getRows());
        for (int i = 0; i < columnCount; ++i) {
            int nullable = fieldList.get(i).isNullable() ? 1 : 0;
            columnMetas.add(new SelectedColumnMeta(false, false, false, false, nullable, true, Integer.MAX_VALUE, fieldList.get(i).getName().toUpperCase(Locale.ROOT), fieldList.get(i).getName().toUpperCase(Locale.ROOT), null, null, null, fieldList.get(i).getPrecision(), fieldList.get(i).getScale(), fieldList.get(i).getDataType(), fieldList.get(i).getDataTypeName(), false, false, false));
        }
    }

    @Override
    public void executeUpdate(String sql) {
        this.queryWithPushDown(sql);
    }

    private PushdownResponse queryWithPushDown(String sql) {
        return SparkSubmitter.submitPushDownTask(sql);
    }

    public String getName() {
        return "SPARK-SQL";
    }
}

