/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing.rules;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationFilter;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.RoutingRule;

public class RemoveBlackoutRealizationsRule
extends RoutingRule {
    public static Set<String> blackList = Sets.newHashSet();
    public static Set<String> whiteList = Sets.newHashSet();
    private static ConcurrentHashMap<KylinConfig, IRealizationFilter> filters = new ConcurrentHashMap();

    public static boolean accept(IRealization real) {
        String canonicalName = real.getCanonicalName();
        if (blackList.contains(canonicalName)) {
            return false;
        }
        if (!whiteList.isEmpty() && !whiteList.contains(canonicalName)) {
            return false;
        }
        String filterClz = real.getConfig().getQueryRealizationFilter();
        return filterClz == null || RemoveBlackoutRealizationsRule.getFilterImpl(real.getConfig()).accept(real);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IRealizationFilter getFilterImpl(KylinConfig conf) {
        IRealizationFilter filter = filters.get(conf);
        if (filter != null) return filter;
        Class<RemoveBlackoutRealizationsRule> clazz = RemoveBlackoutRealizationsRule.class;
        synchronized (RemoveBlackoutRealizationsRule.class) {
            try {
                Class<IRealizationFilter> clz = ClassUtil.forName(conf.getQueryRealizationFilter(), IRealizationFilter.class);
                filter = clz.getConstructor(KylinConfig.class).newInstance(conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            filters.put(conf, filter);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return filter;
        }
    }

    @Override
    public void apply(List<Candidate> candidates) {
        Iterator<Candidate> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            Candidate candidate = iterator.next();
            if (RemoveBlackoutRealizationsRule.accept(candidate.getRealization())) continue;
            iterator.remove();
        }
    }
}

