/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCleanupJob
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(MetadataCleanupJob.class);
    private static final int DEFAULT_JOB_OUTDATED_THRESHOLD_DAYS = 30;
    private static final Option OPTION_DELETE;
    private static final Option OPTION_THRESHOLD_FOR_JOB;

    public static void main(String[] args) throws Exception {
        new MetadataCleanupJob().execute(args);
    }

    @Override
    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DELETE);
        options.addOption(OPTION_THRESHOLD_FOR_JOB);
        return options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        logger.info("delete option value: '" + optionsHelper.getOptionValue(OPTION_DELETE) + "'");
        logger.info("jobThreshold option value: '" + optionsHelper.getOptionValue(OPTION_THRESHOLD_FOR_JOB) + "'");
        boolean delete = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_DELETE));
        int jobOutdatedDays = optionsHelper.hasOption(OPTION_THRESHOLD_FOR_JOB) ? Integer.parseInt(optionsHelper.getOptionValue(OPTION_THRESHOLD_FOR_JOB)) : 30;
        new org.apache.kylin.rest.job.MetadataCleanupJob().cleanup(delete, jobOutdatedDays);
    }

    static {
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Delete the unused metadata");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
        OptionBuilder.withArgName((String)"jobThreshold");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify how many days of job metadata keeping. Default 30 days");
        OPTION_THRESHOLD_FOR_JOB = OptionBuilder.create((String)"jobThreshold");
    }
}

