/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.conf.rule;

import java.io.Serializable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.utils.SparkConfHelper;
import org.apache.spark.conf.rule.SparkConfRule;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0002\u0004\u0001#!)A\u0004\u0001C\u0001;!)q\u0004\u0001C!A!)\u0011\u0007\u0001C!e!)A\u0007\u0001C\u0001k\t)R\t_3dkR|'/\u00138ti\u0006t7-Z:Sk2,'BA\u0004\t\u0003\u0011\u0011X\u000f\\3\u000b\u0005%Q\u0011\u0001B2p]\u001aT!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eQR\"\u0001\u0004\n\u0005m1!!D*qCJ\\7i\u001c8g%VdW-\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011\u0011\u0004A\u0001\bI>\f\u0005\u000f\u001d7z)\t\tC\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0005+:LG\u000fC\u0003&\u0005\u0001\u0007a%\u0001\u0004iK2\u0004XM\u001d\t\u0003O=j\u0011\u0001\u000b\u0006\u0003S)\nQ!\u001e;jYNT!aC\u0016\u000b\u00051j\u0013AB3oO&tWM\u0003\u0002/\u0019\u0005)1.\u001f7j]&\u0011\u0001\u0007\u000b\u0002\u0010'B\f'o[\"p]\u001aDU\r\u001c9fe\u0006Aa-\u00197mE\u0006\u001c7\u000e\u0006\u0002\"g!)Qe\u0001a\u0001M\u0005I3-\u00197dk2\fG/Z#yK\u000e,Ho\u001c:J]N$\u0018M\\2f'&TXMQ=MCf|W\u000f^*ju\u0016$\"AN\u001d\u0011\u0005M9\u0014B\u0001\u001d\u0015\u0005\rIe\u000e\u001e\u0005\u0006u\u0011\u0001\rAN\u0001\u000bY\u0006Lx.\u001e;TSj,\u0007")
public class ExecutorInstancesRule
implements SparkConfRule {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public void apply(SparkConfHelper helper) {
        SparkConfRule.apply$(this, helper);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public void doApply(SparkConfHelper helper) {
        int n;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String queue = helper.getConf("spark.yarn.queue");
        String layoutSize = helper.getOption("layout_size");
        String requiredCores = helper.getOption("required_cores");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("RequiredCores is ").append(requiredCores).toString());
        int baseExecutorInstances = KylinConfig.getInstanceFromEnv().getSparkEngineBaseExecutorInstances();
        int calculateExecutorInsByLayoutSize = this.calculateExecutorInstanceSizeByLayoutSize(Integer.parseInt(layoutSize));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("The number of instances calculated by cuboids ").append("is: ").append(calculateExecutorInsByLayoutSize).toString());
        IntRef availableMem = IntRef.create((int)Integer.MAX_VALUE);
        try {
            availableMem.elem = helper.getFetcher().fetchQueueAvailableResource(queue).available().memory();
        }
        catch (Throwable throwable) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error when getting available memory from cluster, ignore it.");
        }
        IntRef availableCore = IntRef.create((int)Integer.MAX_VALUE);
        try {
            availableCore.elem = helper.getFetcher().fetchQueueAvailableResource(queue).available().vCores();
        }
        catch (Throwable throwable) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error when getting available cpus from cluster, ignore it.");
        }
        long executorMem = Utils$.MODULE$.byteStringAsMb(helper.getConf("spark.executor.memory")) + Utils$.MODULE$.byteStringAsMb(helper.getConf("spark.executor.memoryOverhead"));
        Option option = Option$.MODULE$.apply((Object)helper.getConf("spark.executor.cores"));
        if (option instanceof Some) {
            Some some = (Some)option;
            String cores = (String)some.value();
            n = new StringOps(Predef$.MODULE$.augmentString(cores)).toInt();
        } else if (None$.MODULE$.equals(option)) {
            n = new StringOps(Predef$.MODULE$.augmentString("1")).toInt();
        } else {
            throw new MatchError((Object)option);
        }
        int executorCore = n;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Current availableMem on yarn is ").append(availableMem$1.elem).append(", ").append("availableCore is ").append(availableCore$1.elem).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Current instance memory is set to ").append(executorMem).append(", ").append("cores is set to ").append(executorCore).toString());
        long queueAvailableInstance = Math.min((long)availableMem.elem / executorMem, (long)(availableCore.elem / executorCore));
        long needInstance = Math.max((long)calculateExecutorInsByLayoutSize, (long)(new StringOps(Predef$.MODULE$.augmentString(requiredCores)).toInt() / executorCore));
        long instance = Math.min(needInstance, queueAvailableInstance);
        String executorInstance = Long.toString(Math.max(instance, (long)baseExecutorInstances));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Current queueAvailableInstance is ").append(queueAvailableInstance).append(", ").append("needInstance is ").append(needInstance).append(", instance is ").append(instance).toString());
        helper.setConf("spark.executor.instances", executorInstance);
    }

    @Override
    public void fallback(SparkConfHelper helper) {
        helper.setConf("spark.executor.instances", Integer.toString(KylinConfig.getInstanceFromEnv().getSparkEngineBaseExecutorInstances()));
    }

    public int calculateExecutorInstanceSizeByLayoutSize(int layoutSize) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Calculate the number of executor instance size based on the number of layouts: ").append(layoutSize).toString());
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Integer baseInstances = Predef$.MODULE$.int2Integer(config.getSparkEngineBaseExecutorInstances());
        IntRef instanceMultiple = IntRef.create((int)1);
        if (layoutSize != -1) {
            Option choosen;
            String instanceStrategy = config.getSparkEngineExecutorInstanceStrategy();
            Tuple2 tuple = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instanceStrategy.split(","))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).partition((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)ExecutorInstancesRule.$anonfun$calculateExecutorInstanceSizeByLayoutSize$2(tp)));
            Option option = choosen = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tuple._1())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ExecutorInstancesRule.$anonfun$calculateExecutorInstanceSizeByLayoutSize$3(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tuple._2())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ExecutorInstancesRule.$anonfun$calculateExecutorInstanceSizeByLayoutSize$4(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)ExecutorInstancesRule.$anonfun$calculateExecutorInstanceSizeByLayoutSize$5(layoutSize, tp))))).lastOption();
            None$ none$ = None$.MODULE$;
            if (option == null ? none$ != null : !option.equals(none$)) {
                instanceMultiple.elem = ((Tuple2)Option$.MODULE$.option2Iterable(choosen).last())._2$mcI$sp();
            }
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("The instanceMultiple is ").append(instanceMultiple$1.elem).toString());
        return Predef$.MODULE$.Integer2int(baseInstances) * instanceMultiple.elem;
    }

    public static final /* synthetic */ boolean $anonfun$calculateExecutorInstanceSizeByLayoutSize$2(Tuple2 tp) {
        return tp._2$mcI$sp() % 2 == 0;
    }

    public static final /* synthetic */ int $anonfun$calculateExecutorInstanceSizeByLayoutSize$3(Tuple2 x$1) {
        return new StringOps(Predef$.MODULE$.augmentString((String)x$1._1())).toInt();
    }

    public static final /* synthetic */ int $anonfun$calculateExecutorInstanceSizeByLayoutSize$4(Tuple2 x$2) {
        return new StringOps(Predef$.MODULE$.augmentString((String)x$2._1())).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$calculateExecutorInstanceSizeByLayoutSize$5(int layoutSize$1, Tuple2 tp) {
        return tp._1$mcI$sp() <= layoutSize$1;
    }

    public ExecutorInstancesRule() {
        Logging.$init$((Logging)this);
        SparkConfRule.$init$(this);
    }
}

