/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyArray;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyBinary;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyBoolean;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyDouble;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyFloat;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyHiveChar;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyHiveDecimal;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyHiveIntervalDayTime;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyHiveIntervalYearMonth;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyHiveVarchar;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyUnion;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.LazyVoid;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyListObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyUnionObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBinaryObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDateObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveCharObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveDecimalObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveIntervalDayTimeObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveIntervalYearMonthObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveVarcharObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParametersImpl;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyPrimitiveObjectInspectorFactory;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyVoidObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazydio.LazyDioBinary;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazydio.LazyDioBoolean;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazydio.LazyDioByte;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazydio.LazyDioDouble;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazydio.LazyDioFloat;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazydio.LazyDioInteger;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazydio.LazyDioLong;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.lazydio.LazyDioShort;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public final class LazyFactory {
    public static LazyPrimitive<? extends ObjectInspector, ? extends Writable> createLazyPrimitiveClass(PrimitiveObjectInspector poi, boolean typeBinary) {
        if (typeBinary) {
            return LazyFactory.createLazyPrimitiveBinaryClass(poi);
        }
        return LazyFactory.createLazyPrimitiveClass(poi);
    }

    public static LazyPrimitive<? extends ObjectInspector, ? extends Writable> createLazyPrimitiveClass(PrimitiveObjectInspector oi) {
        PrimitiveObjectInspector.PrimitiveCategory p = oi.getPrimitiveCategory();
        switch (p) {
            case BOOLEAN: {
                return new LazyBoolean((LazyBooleanObjectInspector)oi);
            }
            case BYTE: {
                return new LazyByte((LazyByteObjectInspector)oi);
            }
            case SHORT: {
                return new LazyShort((LazyShortObjectInspector)oi);
            }
            case INT: {
                return new LazyInteger((LazyIntObjectInspector)oi);
            }
            case LONG: {
                return new LazyLong((LazyLongObjectInspector)oi);
            }
            case FLOAT: {
                return new LazyFloat((LazyFloatObjectInspector)oi);
            }
            case DOUBLE: {
                return new LazyDouble((LazyDoubleObjectInspector)oi);
            }
            case STRING: {
                return new LazyString((LazyStringObjectInspector)oi);
            }
            case CHAR: {
                return new LazyHiveChar((LazyHiveCharObjectInspector)oi);
            }
            case VARCHAR: {
                return new LazyHiveVarchar((LazyHiveVarcharObjectInspector)oi);
            }
            case DATE: {
                return new LazyDate((LazyDateObjectInspector)oi);
            }
            case TIMESTAMP: {
                return new LazyTimestamp((LazyTimestampObjectInspector)oi);
            }
            case INTERVAL_YEAR_MONTH: {
                return new LazyHiveIntervalYearMonth((LazyHiveIntervalYearMonthObjectInspector)oi);
            }
            case INTERVAL_DAY_TIME: {
                return new LazyHiveIntervalDayTime((LazyHiveIntervalDayTimeObjectInspector)oi);
            }
            case BINARY: {
                return new LazyBinary((LazyBinaryObjectInspector)oi);
            }
            case DECIMAL: {
                return new LazyHiveDecimal((LazyHiveDecimalObjectInspector)oi);
            }
            case VOID: {
                return new LazyVoid((LazyVoidObjectInspector)oi);
            }
        }
        throw new RuntimeException("Internal error: no LazyObject for " + (Object)((Object)p));
    }

    public static LazyPrimitive<? extends ObjectInspector, ? extends Writable> createLazyPrimitiveBinaryClass(PrimitiveObjectInspector poi) {
        PrimitiveObjectInspector.PrimitiveCategory pc = poi.getPrimitiveCategory();
        switch (pc) {
            case BOOLEAN: {
                return new LazyDioBoolean((LazyBooleanObjectInspector)poi);
            }
            case BYTE: {
                return new LazyDioByte((LazyByteObjectInspector)poi);
            }
            case SHORT: {
                return new LazyDioShort((LazyShortObjectInspector)poi);
            }
            case INT: {
                return new LazyDioInteger((LazyIntObjectInspector)poi);
            }
            case LONG: {
                return new LazyDioLong((LazyLongObjectInspector)poi);
            }
            case FLOAT: {
                return new LazyDioFloat((LazyFloatObjectInspector)poi);
            }
            case DOUBLE: {
                return new LazyDioDouble((LazyDoubleObjectInspector)poi);
            }
            case BINARY: {
                return new LazyDioBinary((LazyBinaryObjectInspector)poi);
            }
        }
        throw new RuntimeException("Hive Internal Error: no LazyObject for " + poi);
    }

    public static LazyObject<? extends ObjectInspector> createLazyObject(ObjectInspector oi) {
        ObjectInspector.Category c = oi.getCategory();
        switch (c) {
            case PRIMITIVE: {
                return LazyFactory.createLazyPrimitiveClass((PrimitiveObjectInspector)oi);
            }
            case MAP: {
                return new LazyMap((LazyMapObjectInspector)oi);
            }
            case LIST: {
                return new LazyArray((LazyListObjectInspector)oi);
            }
            case STRUCT: {
                return new LazyStruct((LazySimpleStructObjectInspector)oi);
            }
            case UNION: {
                return new LazyUnion((LazyUnionObjectInspector)oi);
            }
        }
        throw new RuntimeException("Hive LazySerDe Internal error.");
    }

    public static LazyObject<? extends ObjectInspector> createLazyObject(ObjectInspector oi, boolean typeBinary) {
        if (oi.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return LazyFactory.createLazyPrimitiveClass((PrimitiveObjectInspector)oi, typeBinary);
        }
        return LazyFactory.createLazyObject(oi);
    }

    @Deprecated
    public static ObjectInspector createLazyObjectInspector(TypeInfo typeInfo, byte[] separators, int separatorIndex, Text nullSequence, boolean escaped, byte escapeChar, ObjectInspectorFactory.ObjectInspectorOptions option) throws SerDeException {
        return LazyFactory.createLazyObjectInspector(typeInfo, separators, separatorIndex, nullSequence, escaped, escapeChar, false, option);
    }

    @Deprecated
    public static ObjectInspector createLazyObjectInspector(TypeInfo typeInfo, byte[] separators, int separatorIndex, Text nullSequence, boolean escaped, byte escapeChar) throws SerDeException {
        return LazyFactory.createLazyObjectInspector(typeInfo, separators, separatorIndex, nullSequence, escaped, escapeChar, false, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    @Deprecated
    public static ObjectInspector createLazyObjectInspector(TypeInfo typeInfo, byte[] separators, int separatorIndex, Text nullSequence, boolean escaped, byte escapeChar, boolean extendedBooleanLiteral) throws SerDeException {
        return LazyFactory.createLazyObjectInspector(typeInfo, separators, separatorIndex, nullSequence, escaped, escapeChar, extendedBooleanLiteral, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    @Deprecated
    public static ObjectInspector createLazyObjectInspector(TypeInfo typeInfo, byte[] separators, int separatorIndex, Text nullSequence, boolean escaped, byte escapeChar, boolean extendedBooleanLiteral, ObjectInspectorFactory.ObjectInspectorOptions option) throws SerDeException {
        LazyObjectInspectorParametersImpl lazyParams = new LazyObjectInspectorParametersImpl(escaped, escapeChar, extendedBooleanLiteral, null, separators, nullSequence);
        return LazyFactory.createLazyObjectInspector(typeInfo, separatorIndex, lazyParams, option);
    }

    public static ObjectInspector createLazyObjectInspector(TypeInfo typeInfo, int separatorIndex, LazyObjectInspectorParameters lazyParams, ObjectInspectorFactory.ObjectInspectorOptions option) throws SerDeException {
        ObjectInspector.Category c = typeInfo.getCategory();
        switch (c) {
            case PRIMITIVE: {
                return LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)typeInfo, lazyParams);
            }
            case MAP: {
                return LazyObjectInspectorFactory.getLazySimpleMapObjectInspector(LazyFactory.createLazyObjectInspector(((MapTypeInfo)typeInfo).getMapKeyTypeInfo(), separatorIndex + 2, lazyParams, option), LazyFactory.createLazyObjectInspector(((MapTypeInfo)typeInfo).getMapValueTypeInfo(), separatorIndex + 2, lazyParams, option), LazyUtils.getSeparator(lazyParams.getSeparators(), separatorIndex), LazyUtils.getSeparator(lazyParams.getSeparators(), separatorIndex + 1), lazyParams);
            }
            case LIST: {
                return LazyObjectInspectorFactory.getLazySimpleListObjectInspector(LazyFactory.createLazyObjectInspector(((ListTypeInfo)typeInfo).getListElementTypeInfo(), separatorIndex + 1, lazyParams, option), LazyUtils.getSeparator(lazyParams.getSeparators(), separatorIndex), lazyParams);
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList<String> fieldNames = structTypeInfo.getAllStructFieldNames();
                ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                    fieldObjectInspectors.add(LazyFactory.createLazyObjectInspector((TypeInfo)fieldTypeInfos.get(i), separatorIndex + 1, lazyParams, option));
                }
                return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(fieldNames, fieldObjectInspectors, null, LazyUtils.getSeparator(lazyParams.getSeparators(), separatorIndex), lazyParams, option);
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                ArrayList<ObjectInspector> lazyOIs = new ArrayList<ObjectInspector>();
                for (TypeInfo uti : unionTypeInfo.getAllUnionObjectTypeInfos()) {
                    lazyOIs.add(LazyFactory.createLazyObjectInspector(uti, separatorIndex + 1, lazyParams, option));
                }
                return LazyObjectInspectorFactory.getLazyUnionObjectInspector(lazyOIs, LazyUtils.getSeparator(lazyParams.getSeparators(), separatorIndex), lazyParams);
            }
        }
        throw new RuntimeException("Hive LazySerDe Internal error.");
    }

    @Deprecated
    public static ObjectInspector createLazyStructInspector(List<String> columnNames, List<TypeInfo> typeInfos, byte[] separators, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) throws SerDeException {
        return LazyFactory.createLazyStructInspector(columnNames, typeInfos, separators, nullSequence, lastColumnTakesRest, escaped, escapeChar, false);
    }

    @Deprecated
    public static ObjectInspector createLazyStructInspector(List<String> columnNames, List<TypeInfo> typeInfos, byte[] separators, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar, boolean extendedBooleanLiteral) throws SerDeException {
        LazyObjectInspectorParametersImpl lazyParams = new LazyObjectInspectorParametersImpl(escaped, escapeChar, extendedBooleanLiteral, null, separators, nullSequence, lastColumnTakesRest);
        return LazyFactory.createLazyStructInspector(columnNames, typeInfos, lazyParams);
    }

    public static ObjectInspector createLazyStructInspector(List<String> columnNames, List<TypeInfo> typeInfos, LazyObjectInspectorParameters lazyParams) throws SerDeException {
        ArrayList<ObjectInspector> columnObjectInspectors = new ArrayList<ObjectInspector>(typeInfos.size());
        for (int i = 0; i < typeInfos.size(); ++i) {
            columnObjectInspectors.add(LazyFactory.createLazyObjectInspector(typeInfos.get(i), 1, lazyParams, ObjectInspectorFactory.ObjectInspectorOptions.JAVA));
        }
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(columnNames, columnObjectInspectors, null, lazyParams.getSeparators()[0], lazyParams, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    @Deprecated
    public static ObjectInspector createColumnarStructInspector(List<String> columnNames, List<TypeInfo> columnTypes, byte[] separators, Text nullSequence, boolean escaped, byte escapeChar) throws SerDeException {
        LazyObjectInspectorParametersImpl lazyParams = new LazyObjectInspectorParametersImpl(escaped, escapeChar, false, null, separators, nullSequence);
        return LazyFactory.createColumnarStructInspector(columnNames, columnTypes, lazyParams);
    }

    public static ObjectInspector createColumnarStructInspector(List<String> columnNames, List<TypeInfo> columnTypes, LazyObjectInspectorParameters lazyParams) throws SerDeException {
        ArrayList<ObjectInspector> columnObjectInspectors = new ArrayList<ObjectInspector>(columnTypes.size());
        for (int i = 0; i < columnTypes.size(); ++i) {
            columnObjectInspectors.add(LazyFactory.createLazyObjectInspector(columnTypes.get(i), 1, lazyParams, ObjectInspectorFactory.ObjectInspectorOptions.JAVA));
        }
        return ObjectInspectorFactory.getColumnarStructObjectInspector(columnNames, columnObjectInspectors);
    }

    private LazyFactory() {
    }
}

