/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.v1.ExecPoolStatistic;
import org.apache.kyuubi.server.api.v1.GetColumnsRequest;
import org.apache.kyuubi.server.api.v1.GetFunctionsRequest;
import org.apache.kyuubi.server.api.v1.GetSchemasRequest;
import org.apache.kyuubi.server.api.v1.GetTablesRequest;
import org.apache.kyuubi.server.api.v1.InfoDetail;
import org.apache.kyuubi.server.api.v1.SessionList;
import org.apache.kyuubi.server.api.v1.SessionOpenCount;
import org.apache.kyuubi.server.api.v1.SessionOpenRequest;
import org.apache.kyuubi.server.api.v1.SessionOverview;
import org.apache.kyuubi.server.api.v1.StatementRequest;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@Tag(name="Session")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\t\u0015h!B\t\u0013\u0001Iq\u0002\"B\u0017\u0001\t\u0003y\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0004\"B3\u0001\t\u00031\u0007bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBq!!\u001f\u0001\t\u0003\tY\bC\u0004\u0002.\u0002!\t!a,\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011q \u0001\u0005\u0002\t\u0005\u0001b\u0002B\f\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#BqAa\u001c\u0001\t\u0003\u0011\t\bC\u0004\u0003\b\u0002!\tA!#\t\u000f\t\u001d\u0006\u0001\"\u0001\u0003*\n\u00012+Z:tS>t7OU3t_V\u00148-\u001a\u0006\u0003'Q\t!A^\u0019\u000b\u0005U1\u0012aA1qS*\u0011q\u0003G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005eQ\u0012AB6zkV\u0014\u0017N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0003\u0002\u0001 K%\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014(\u001b\u0005!\u0012B\u0001\u0015\u0015\u0005E\t\u0005/\u001b*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0003U-j\u0011\u0001G\u0005\u0003Ya\u0011q\u0001T8hO&tw-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0001\u0004CA\u0019\u0001\u001b\u0005\u0011\u0012aD:fgNLwN\\%oM>d\u0015n\u001d;\u0015\u0003Q\u0002\"!M\u001b\n\u0005Y\u0012\"aC*fgNLwN\u001c'jgRD#A\u0001\u001d\u0011\u0005e\u0002U\"\u0001\u001e\u000b\u0005mb\u0014A\u0001:t\u0015\tid(\u0001\u0002xg*\tq(A\u0003kCZ\f\u00070\u0003\u0002Bu\t\u0019q)\u0012+)\u0011\t\u00195\u000b\u0016,XE\u000e\u0004\"\u0001R)\u000e\u0003\u0015S!AR$\u0002\u0013I,7\u000f]8og\u0016\u001c(B\u0001%J\u0003-\tgN\\8uCRLwN\\:\u000b\u0005)[\u0015aA8bg*\u0011A*T\u0001\u0003mNR!AT(\u0002\u000fM<\u0018mZ4fe*\t\u0001+\u0001\u0002j_&\u0011!+\u0012\u0002\f\u0003BL'+Z:q_:\u001cX-\u0001\u0007sKN\u0004xN\\:f\u0007>$W-I\u0001V\u0003\r\u0011\u0004\u0007M\u0001\bG>tG/\u001a8uY\u0005A6fA-`AB\u0011!,X\u0007\u00027*\u0011AlR\u0001\u0006[\u0016$\u0017.Y\u0005\u0003=n\u0013qaQ8oi\u0016tG/A\u0005nK\u0012L\u0017\rV=qK\u0006\n\u0011-\u0001\tbaBd\u0017nY1uS>twF[:p]\u0006YA-Z:de&\u0004H/[8oC\u0005!\u0017!M4fi\u0002\nG\u000e\u001c\u0011uQ\u0016\u00043/Z:tS>t\u0007\u0005\\5ti\u0002Bwn\u001d;fI\u0002Jg\u000eI*fgNLwN\\'b]\u0006<WM]\u0001\fg\u0016\u001c8/[8o\u0013:4w\u000e\u0006\u0002h[B\u0011\u0001n[\u0007\u0002S*\u0011!\u000eG\u0001\u0007KZ,g\u000e^:\n\u00051L'aC&zkV\u0014\u0017.\u0012<f]RDQA\\\u0002A\u0002=\f\u0001c]3tg&|g\u000eS1oI2,7\u000b\u001e:\u0011\u0005A<hBA9v!\t\u0011\u0018%D\u0001t\u0015\t!h&\u0001\u0004=e>|GOP\u0005\u0003m\u0006\na\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011a/\t\u0015\u0005[ntx\u0010\u0005\u0002:y&\u0011QP\u000f\u0002\n!\u0006$\b\u000eU1sC6\fQA^1mk\u0016\f#!!\u0001\u0002\u001bM,7o]5p]\"\u000bg\u000e\u001a7fQ\u0019\u0019\u0011Q\u0001@\u0002\fA\u0019\u0011(a\u0002\n\u0007\u0005%!H\u0001\u0003QCRD\u0017EAA\u0007\u0003=Y8/Z:tS>t\u0007*\u00198eY\u0016l\bFA\u00029Q)\u00191i\u0015+W\u0003'\u0011\u0017Q\u0003\u0017\u00021\u0006\u0012\u0011qC\u00012O\u0016$\b%\u0019\u0011tKN\u001c\u0018n\u001c8!KZ,g\u000e\u001e\u0011wS\u0006\u00043/Z:tS>t\u0007\u0005[1oI2,\u0007%\u001b3f]RLg-[3s\u0003\u001d9W\r^%oM>$b!!\b\u0002$\u0005\u001d\u0002cA\u0019\u0002 %\u0019\u0011\u0011\u0005\n\u0003\u0015%sgm\u001c#fi\u0006LG\u000eC\u0003o\t\u0001\u0007q\u000eK\u0003\u0002$mtx\u0010C\u0004\u0002*\u0011\u0001\r!a\u000b\u0002\u0011%tgm\u001c+za\u0016\u00042\u0001IA\u0017\u0013\r\ty#\t\u0002\u0004\u0013:$\bFBA\u0014wz\f\u0019$\t\u0002\u0002*!2A!!\u0002\u007f\u0003o\t#!!\u000f\u0002?m\u001cXm]:j_:D\u0015M\u001c3mKv|\u0013N\u001c4p_mLgNZ8UsB,W\u0010\u000b\u0002\u0005q!RAaQ*U-\u0006}\"-!\u0011-\u0003a\u000b#!a\u0011\u0002-\u001e,G\u000fI1!S:4wN]7bi&|g\u000e\t3fi\u0006LG\u000e\t<jC\u0002\u001aXm]:j_:\u0004\u0003.\u00198eY\u0016\u0004\u0013\u000eZ3oi&4\u0017.\u001a:!C:$\u0007%\u0019\u0011ta\u0016\u001c\u0017NZ5dA%tgm\u001c:nCRLwN\u001c\u0011usB,\u0017\u0001D:fgNLwN\\\"pk:$HCAA%!\r\t\u00141J\u0005\u0004\u0003\u001b\u0012\"\u0001E*fgNLwN\\(qK:\u001cu.\u001e8uQ\u0019)\u0011Q\u0001@\u0002R\u0005\u0012\u00111K\u0001\u0006G>,h\u000e\u001e\u0015\u0003\u000baB#\"B\"T)Z\u000bIFYA.Y\u0005A\u0016EAA/\u0003\t:U\r\u001e\u0011uQ\u0016\u00043-\u001e:sK:$\be\u001c9f]\u0002\u001aXm]:j_:\u00043m\\;oi\u0006\tR\r_3d!>|Gn\u0015;bi&\u001cH/[2\u0015\u0005\u0005\r\u0004cA\u0019\u0002f%\u0019\u0011q\r\n\u0003#\u0015CXm\u0019)p_2\u001cF/\u0019;jgRL7\r\u000b\u0004\u0007\u0003\u000bq\u00181N\u0011\u0003\u0003[\n!#\u001a=fGB{w\u000e\\\u0018ti\u0006$\u0018n\u001d;jG\"\u0012a\u0001\u000f\u0015\u000b\r\r\u001bFKVA:E\u0006UD&\u0001-\"\u0005\u0005]\u0014AK$fi\u0002\u001aH/\u0019;jgRL7\rI5oM>\u0004sN\u001a\u0011cC\u000e\\wM]8v]\u0012\u0004S\r_3dkR|'o]\u0001\f_B,gnU3tg&|g\u000e\u0006\u0003\u0002~\u0005%\u0005\u0003BA@\u0003\u000bk!!!!\u000b\u0007\u0005\r\u0005$A\u0004tKN\u001c\u0018n\u001c8\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\t\u000f\u0005-u\u00011\u0001\u0002\u000e\u00069!/Z9vKN$\bcA\u0019\u0002\u0010&\u0019\u0011\u0011\u0013\n\u0003%M+7o]5p]>\u0003XM\u001c*fcV,7\u000f\u001e\u0015\u0007\u000f\u0005Ue0a'\u0011\u0007e\n9*C\u0002\u0002\u001aj\u0012\u0001bQ8ogVlWm\u001d\u0017\u0002A\"\u001aq!a(\u0011\u0007e\n\t+C\u0002\u0002$j\u0012A\u0001U(T)\"RqaQ*U-\u0006\u001d&-!+-\u0003a\u000b#!a+\u0002-=\u0003XM\u001c\u0015de\u0016\fG/Z\u0015!C\u0002\u001aXm]:j_:\fAb\u00197pg\u0016\u001cVm]:j_:$B!!-\u0002>B!\u00111WA]\u001b\t\t)LC\u0002\u00028j\nAaY8sK&!\u00111XA[\u0005!\u0011Vm\u001d9p]N,\u0007\"\u00028\t\u0001\u0004y\u0007&BA_wz|\bF\u0002\u0005\u0002\u0006y\fY\u0001K\u0002\t\u0003\u000b\u00042!OAd\u0013\r\tIM\u000f\u0002\u0007\t\u0016cU\tV#)\u0015!\u00195\u000b\u0016,\u0002N\n\fy\rL\u0001YC\t\t\t.A\bDY>\u001cX\rI1!g\u0016\u001c8/[8o\u0003A)\u00070Z2vi\u0016\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0004\u0002X\u0006\r\u0018q\u001d\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\u001c\r\u0002\u0013=\u0004XM]1uS>t\u0017\u0002BAq\u00037\u0014qb\u00149fe\u0006$\u0018n\u001c8IC:$G.\u001a\u0005\u0006]&\u0001\ra\u001c\u0015\u0006\u0003G\\hp \u0005\b\u0003\u0017K\u0001\u0019AAu!\r\t\u00141^\u0005\u0004\u0003[\u0014\"\u0001E*uCR,W.\u001a8u%\u0016\fX/Z:uQ\u0019I\u0011Q\u0001@\u0002r\u0006\u0012\u00111_\u0001%wN,7o]5p]\"\u000bg\u000e\u001a7f{>z\u0007/\u001a:bi&|gn]\u0018ti\u0006$X-\\3oi\"\u001a\u0011\"a()\u0015%\u00195\u000b\u0016,\u0002z\n\fY\u0010L\u0001YC\t\ti0A\u0018De\u0016\fG/\u001a\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI<ji\"\u0004S\tW#D+R+ul\u0015+B)\u0016kUI\u0014+!if\u0004X-A\u0006hKR$\u0016\u0010]3J]\u001a|G\u0003BAl\u0005\u0007AQA\u001c\u0006A\u0002=DSAa\u0001|}~DcACA\u0003}\n%\u0011E\u0001B\u0006\u0003\rZ8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_QL\b/Z%oM>D3ACAPQ)Q1i\u0015+W\u0005#\u0011'1\u0003\u0017\u00021\u0006\u0012!QC\u0001,\u0007J,\u0017\r^3!C:\u0004s\u000e]3sCRLwN\u001c\u0011xSRD\u0007eR#U?RK\u0006+R0J\u001d\u001a{\u0005\u0005^=qK\u0006Yq-\u001a;DCR\fGn\\4t)\u0011\t9Na\u0007\t\u000b9\\\u0001\u0019A8)\u000b\tm1P`@)\r-\t)A B\u0011C\t\u0011\u0019#A\u0012|g\u0016\u001c8/[8o\u0011\u0006tG\r\\3~_=\u0004XM]1uS>t7oL2bi\u0006dwnZ:)\u0007-\ty\n\u000b\u0006\f\u0007N#fK!\u000bc\u0005Wa\u0013\u0001W\u0011\u0003\u0005[\t!f\u0011:fCR,\u0007%\u00198!_B,'/\u0019;j_:\u0004s/\u001b;iA\u001d+EkX\"B)\u0006cujR*!if\u0004X-\u0001\u0006hKR\u001c6\r[3nCN$b!a6\u00034\t]\u0002\"\u00028\r\u0001\u0004y\u0007&\u0002B\u001awz|\bbBAF\u0019\u0001\u0007!\u0011\b\t\u0004c\tm\u0012b\u0001B\u001f%\t\tr)\u001a;TG\",W.Y:SKF,Xm\u001d;)\r1\t)A B!C\t\u0011\u0019%\u0001\u0012|g\u0016\u001c8/[8o\u0011\u0006tG\r\\3~_=\u0004XM]1uS>t7oL:dQ\u0016l\u0017m\u001d\u0015\u0004\u0019\u0005}\u0005F\u0003\u0007D'R3&\u0011\n2\u0003L1\n\u0001,\t\u0002\u0003N\u0005I3I]3bi\u0016\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0002:\u0018\u000e\u001e5!\u000f\u0016#vlU\"I\u000b6\u000b5\u000b\t;za\u0016\f\u0011bZ3u)\u0006\u0014G.Z:\u0015\r\u0005]'1\u000bB,\u0011\u0015qW\u00021\u0001pQ\u0015\u0011\u0019f\u001f@\u0000\u0011\u001d\tY)\u0004a\u0001\u00053\u00022!\rB.\u0013\r\u0011iF\u0005\u0002\u0011\u000f\u0016$H+\u00192mKN\u0014V-];fgRDc!DA\u0003}\n\u0005\u0014E\u0001B2\u0003\u0005Z8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_Q\f'\r\\3tQ\ri\u0011q\u0014\u0015\u000b\u001b\r\u001bFK\u0016B5E\n-D&\u0001-\"\u0005\t5\u0014\u0001K\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0U\u0003\ncUi\u0015\u0011usB,\u0017!D4fiR\u000b'\r\\3UsB,7\u000f\u0006\u0003\u0002X\nM\u0004\"\u00028\u000f\u0001\u0004y\u0007&\u0002B:wz|\bF\u0002\b\u0002\u0006y\u0014I(\t\u0002\u0003|\u0005)3p]3tg&|g\u000eS1oI2,WpL8qKJ\fG/[8og>\"\u0018M\u00197f)f\u0004Xm\u001d\u0015\u0004\u001d\u0005}\u0005F\u0003\bD'R3&\u0011\u00112\u0003\u00042\n\u0001,\t\u0002\u0003\u0006\u0006i3I]3bi\u0016\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0002:\u0018\u000e\u001e5!\u000f\u0016#v\fV!C\u0019\u0016{F+\u0017)F'\u0002\"\u0018\u0010]3\u0002\u0015\u001d,GoQ8mk6t7\u000f\u0006\u0004\u0002X\n-%q\u0012\u0005\u0006]>\u0001\ra\u001c\u0015\u0006\u0005\u0017[hp \u0005\b\u0003\u0017{\u0001\u0019\u0001BI!\r\t$1S\u0005\u0004\u0005+\u0013\"!E$fi\u000e{G.^7ogJ+\u0017/^3ti\"2q\"!\u0002\u007f\u00053\u000b#Aa'\u0002Em\u001cXm]:j_:D\u0015M\u001c3mKv|s\u000e]3sCRLwN\\:0G>dW/\u001c8tQ\ry\u0011q\u0014\u0015\u000b\u001f\r\u001bFK\u0016BQE\n\rF&\u0001-\"\u0005\t\u0015\u0016!K\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0D\u001f2+VJT*!if\u0004X-\u0001\u0007hKR4UO\\2uS>t7\u000f\u0006\u0004\u0002X\n-&q\u0016\u0005\u0006]B\u0001\ra\u001c\u0015\u0006\u0005W[hp \u0005\b\u0003\u0017\u0003\u0002\u0019\u0001BY!\r\t$1W\u0005\u0004\u0005k\u0013\"aE$fi\u001a+hn\u0019;j_:\u001c(+Z9vKN$\bF\u0002\t\u0002\u0006y\u0014I,\t\u0002\u0003<\u0006!3p]3tg&|g\u000eS1oI2,WpL8qKJ\fG/[8og>2WO\\2uS>t7\u000fK\u0002\u0011\u0003?C#\u0002E\"T)Z\u0013\tM\u0019BbY\u0005A\u0016E\u0001Bc\u0003-\u001a%/Z1uK\u0002\ng\u000eI8qKJ\fG/[8oA]LG\u000f\u001b\u0011H\u000bR{f)\u0016(D)&{ej\u0015\u0011usB,\u0007F\u0002\u0001\u0003Jz\u0014y\rE\u0002:\u0005\u0017L1A!4;\u0005!\u0001&o\u001c3vG\u0016\u001cH&\u00011)\u000f\u0001\u0011\u0019Na8\u0003bB!!Q\u001bBn\u001b\t\u00119NC\u0002\u0003Z\u001e\u000bA\u0001^1hg&!!Q\u001cBl\u0005\r!\u0016mZ\u0001\u0005]\u0006lW-\t\u0002\u0003d\u000691+Z:tS>t\u0007")
public class SessionsResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="get all the session list hosted in SessionManager")
    @GET
    public SessionList sessionInfoList() {
        return new SessionList((Seq<SessionOverview>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter((ConcurrentMap)this.fe().be().sessionManager().getSessionList()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SessionHandle handle = (SessionHandle)tuple2._1();
            Session session = (Session)tuple2._2();
            SessionOverview sessionOverview = new SessionOverview(session.user(), session.ipAddress(), session.createTime(), handle);
            return sessionOverview;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="get a session event via session handle identifier")
    @GET
    @Path(value="{sessionHandle}")
    public KyuubiEvent sessionInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        KyuubiEvent kyuubiEvent;
        try {
            kyuubiEvent = (KyuubiEvent)this.fe().be().sessionManager().getSession(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr)).getSessionEvent().get();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Invalid ").append(sessionHandleStr).toString(), e);
                throw new NotFoundException(new StringBuilder(8).append("Invalid ").append(sessionHandleStr).toString());
            }
            throw throwable;
        }
        return kyuubiEvent;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="get a information detail via session handle identifier and a specific information type")
    @GET
    @Path(value="{sessionHandle}/info/{infoType}")
    public InfoDetail getInfo(@PathParam(value="sessionHandle") String sessionHandleStr, @PathParam(value="infoType") int infoType) {
        InfoDetail infoDetail;
        try {
            TGetInfoType info = TGetInfoType.findByValue((int)infoType);
            TGetInfoValue infoValue = this.fe().be().getInfo(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr), info);
            infoDetail = new InfoDetail(info.toString(), infoValue.getStringValue());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), e);
                throw new NotFoundException(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString());
            }
            throw throwable;
        }
        return infoDetail;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Get the current open session count")
    @GET
    @Path(value="count")
    public SessionOpenCount sessionCount() {
        return new SessionOpenCount(this.fe().be().sessionManager().getOpenSessionCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Get statistic info of background executors")
    @GET
    @Path(value="execPool/statistic")
    public ExecPoolStatistic execPoolStatistic() {
        return new ExecPoolStatistic(this.fe().be().sessionManager().getExecPoolSize(), this.fe().be().sessionManager().getActiveCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Open(create) a session")
    @POST
    @Consumes(value={"application/json"})
    public SessionHandle openSession(SessionOpenRequest request) {
        return this.fe().be().openSession(TProtocolVersion.findByValue((int)request.protocolVersion()), request.user(), request.password(), request.ipAddr(), request.configs());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Close a session")
    @DELETE
    @Path(value="{sessionHandle}")
    public Response closeSession(@PathParam(value="sessionHandle") String sessionHandleStr) {
        this.fe().be().closeSession(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr));
        return Response.ok().build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with EXECUTE_STATEMENT type")
    @POST
    @Path(value="{sessionHandle}/operations/statement")
    public OperationHandle executeStatement(@PathParam(value="sessionHandle") String sessionHandleStr, StatementRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().executeStatement(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr), request.statement(), Predef$.MODULE$.Map().empty(), request.runAsync(), request.queryTimeout());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error executing statement";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_TYPE_INFO type")
    @POST
    @Path(value="{sessionHandle}/operations/typeInfo")
    public OperationHandle getTypeInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTypeInfo(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting type information";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_CATALOGS type")
    @POST
    @Path(value="{sessionHandle}/operations/catalogs")
    public OperationHandle getCatalogs(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getCatalogs(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting catalogs";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_SCHEMAS type")
    @POST
    @Path(value="{sessionHandle}/operations/schemas")
    public OperationHandle getSchemas(@PathParam(value="sessionHandle") String sessionHandleStr, GetSchemasRequest request) {
        OperationHandle operationHandle;
        try {
            OperationHandle operationHandle2;
            SessionHandle sessionHandle = SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr);
            operationHandle = operationHandle2 = this.fe().be().getSchemas(sessionHandle, request.catalogName(), request.schemaName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting schemas";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_TABLES type")
    @POST
    @Path(value="{sessionHandle}/operations/tables")
    public OperationHandle getTables(@PathParam(value="sessionHandle") String sessionHandleStr, GetTablesRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTables(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr), request.catalogName(), request.schemaName(), request.tableName(), request.tableTypes());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting tables";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_TABLE_TYPES type")
    @POST
    @Path(value="{sessionHandle}/operations/tableTypes")
    public OperationHandle getTableTypes(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTableTypes(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting table types";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_COLUMNS type")
    @POST
    @Path(value="{sessionHandle}/operations/columns")
    public OperationHandle getColumns(@PathParam(value="sessionHandle") String sessionHandleStr, GetColumnsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getColumns(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr), request.catalogName(), request.schemaName(), request.tableName(), request.columnName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting columns";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_FUNCTIONS type")
    @POST
    @Path(value="{sessionHandle}/operations/functions")
    public OperationHandle getFunctions(@PathParam(value="sessionHandle") String sessionHandleStr, GetFunctionsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getFunctions(SessionHandle$.MODULE$.parseSessionHandle(sessionHandleStr), request.catalogName(), request.schemaName(), request.functionName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting functions";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    public SessionsResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

