/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.kyuubi.shaded.thrift.TConfiguration;
import org.apache.kyuubi.shaded.thrift.transport.TSSLTransportFactory;
import org.apache.kyuubi.shaded.thrift.transport.TSocket;
import org.apache.kyuubi.shaded.thrift.transport.TTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;

public class ThriftUtils {
    public static TTransport getSocketTransport(String host, int port, int connectTimeout, int socketTimeout) throws TTransportException {
        return new TSocket(TConfiguration.DEFAULT, host, port, socketTimeout, connectTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int connectTimeout, int socketTimeout) throws TTransportException {
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)socketTimeout);
        tSSLSocket.setConnectTimeout(connectTimeout);
        return ThriftUtils.getSSLSocketWithHttps(tSSLSocket);
    }

    public static TTransport getSSLSocket(String host, int port, int connectTimeout, int socketTimeout, String trustStorePath, String trustStorePassWord) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setTrustStore(trustStorePath, trustStorePassWord);
        params.requireClientAuth(true);
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)socketTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
        tSSLSocket.setConnectTimeout(connectTimeout);
        return ThriftUtils.getSSLSocketWithHttps(tSSLSocket);
    }

    private static TSocket getSSLSocketWithHttps(TSocket tSSLSocket) throws TTransportException {
        SSLSocket sslSocket = (SSLSocket)tSSLSocket.getSocket();
        SSLParameters sslParams = sslSocket.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        sslSocket.setSSLParameters(sslParams);
        return new TSocket((Socket)sslSocket);
    }
}

