/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.api;

import io.etcd.jetcd.api.LeaseGrantRequest;
import io.etcd.jetcd.api.LeaseGrantResponse;
import io.etcd.jetcd.api.LeaseGrpc;
import io.etcd.jetcd.api.LeaseKeepAliveRequest;
import io.etcd.jetcd.api.LeaseKeepAliveResponse;
import io.etcd.jetcd.api.LeaseRevokeRequest;
import io.etcd.jetcd.api.LeaseRevokeResponse;
import io.etcd.jetcd.api.LeaseTimeToLiveRequest;
import io.etcd.jetcd.api.LeaseTimeToLiveResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.stub.ClientCalls;

public final class VertxLeaseGrpc {
    private static final int METHODID_LEASE_GRANT = 0;
    private static final int METHODID_LEASE_REVOKE = 1;
    private static final int METHODID_LEASE_KEEP_ALIVE = 2;
    private static final int METHODID_LEASE_TIME_TO_LIVE = 3;

    private VertxLeaseGrpc() {
    }

    public static LeaseVertxStub newVertxStub(Channel channel) {
        return new LeaseVertxStub(channel);
    }

    public static final class LeaseVertxStub
    extends AbstractStub<LeaseVertxStub> {
        private final ContextInternal ctx;
        private LeaseGrpc.LeaseStub delegateStub;

        private LeaseVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = LeaseGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private LeaseVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = LeaseGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        protected LeaseVertxStub build(Channel channel, CallOptions callOptions) {
            return new LeaseVertxStub(channel, callOptions);
        }

        public Future<LeaseGrantResponse> leaseGrant(LeaseGrantRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::leaseGrant);
        }

        public Future<LeaseRevokeResponse> leaseRevoke(LeaseRevokeRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::leaseRevoke);
        }

        public Future<LeaseTimeToLiveResponse> leaseTimeToLive(LeaseTimeToLiveRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::leaseTimeToLive);
        }

        public ReadStream<LeaseKeepAliveResponse> leaseKeepAlive(Handler<WriteStream<LeaseKeepAliveRequest>> hdlr) {
            return ClientCalls.manyToMany((ContextInternal)this.ctx, hdlr, this.delegateStub::leaseKeepAlive);
        }

        public ReadStream<LeaseKeepAliveResponse> leaseKeepAliveWithExceptionHandler(Handler<WriteStream<LeaseKeepAliveRequest>> hdlr, Handler<Throwable> exceptionHandler) {
            return ClientCalls.manyToMany((ContextInternal)this.ctx, hdlr, this.delegateStub::leaseKeepAlive, exceptionHandler);
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final LeaseVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(LeaseVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((LeaseGrantRequest)request), responseObserver, (String)this.compression, this.serviceImpl::leaseGrant);
                    break;
                }
                case 1: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((LeaseRevokeRequest)request), responseObserver, (String)this.compression, this.serviceImpl::leaseRevoke);
                    break;
                }
                case 3: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((LeaseTimeToLiveRequest)request), responseObserver, (String)this.compression, this.serviceImpl::leaseTimeToLive);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    return io.vertx.grpc.stub.ServerCalls.manyToMany(responseObserver, (String)this.compression, this.serviceImpl::leaseKeepAlive);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class LeaseVertxImplBase
    implements BindableService {
        private String compression;

        public LeaseVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<LeaseGrantResponse> leaseGrant(LeaseGrantRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<LeaseRevokeResponse> leaseRevoke(LeaseRevokeRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<LeaseTimeToLiveResponse> leaseTimeToLive(LeaseTimeToLiveRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public void leaseKeepAlive(ReadStream<LeaseKeepAliveRequest> request, WriteStream<LeaseKeepAliveResponse> response) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)LeaseGrpc.getServiceDescriptor()).addMethod(LeaseGrpc.getLeaseGrantMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(LeaseGrpc.getLeaseRevokeMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).addMethod(LeaseGrpc.getLeaseKeepAliveMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 2, this.compression))).addMethod(LeaseGrpc.getLeaseTimeToLiveMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3, this.compression))).build();
        }
    }
}

