/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.plugins;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.logging.log4j.catalog.api.ConstraintType;
import org.apache.logging.log4j.catalog.api.exception.NameNotFoundException;
import org.apache.logging.log4j.catalog.api.plugins.ConstraintPlugins;

public class ConstraintTypeDeserializer
extends StdDeserializer<ConstraintType> {
    ConstraintPlugins plugins = ConstraintPlugins.getInstance();

    public ConstraintTypeDeserializer() {
        this(null);
    }

    public ConstraintTypeDeserializer(Class<?> vc) {
        super(vc);
    }

    public ConstraintType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String name = node.get("name").textValue();
        ConstraintType type = this.plugins.findByName(name);
        if (type == null) {
            throw new NameNotFoundException("Unable to locate plugin for constraint type " + name);
        }
        return type;
    }
}

