/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.generator;

import org.apache.logging.log4j.audit.generator.ClassGenerator;
import org.apache.logging.log4j.audit.generator.MethodDefinition;
import org.apache.logging.log4j.audit.generator.Parameter;
import org.apache.logging.log4j.audit.generator.VariableDefinition;
import org.apache.logging.log4j.audit.util.NamingUtils;
import org.apache.logging.log4j.audit.util.StringUtil;

public class AccessorDefinition {
    private String name;
    private String type;
    private String packageName = null;
    private String annotation = null;
    private String setterContent;
    private String getterContent;

    public static String variableCaseName(String variable) {
        return variable.substring(0, 1).toLowerCase() + variable.substring(1);
    }

    public void setSetterContent(String setterContent) {
        this.setterContent = setterContent;
    }

    public void setGetterContent(String getterContent) {
        this.getterContent = getterContent;
    }

    public AccessorDefinition(String name, String type) {
        this(name, type, null, null);
    }

    public AccessorDefinition(String name, String type, String setterContent, String getterContent) {
        this.setName(NamingUtils.getFieldName(name));
        this.setType(type);
        this.setSetterContent(setterContent);
        this.setGetterContent(getterContent);
    }

    public void addBean(ClassGenerator generator) {
        this.addBean(generator, true, true, true);
    }

    public void addBean(ClassGenerator generator, boolean addLocalVariable, boolean addGetter, boolean addSetter) {
        MethodDefinition methodDefinition;
        if (generator.isClass() && addLocalVariable) {
            generator.addLocalVariable(new VariableDefinition("private", this.getType(), this.getName(), null, this.getAnnotation()));
        }
        if (this.packageName != null) {
            generator.getImports().add(this.packageName);
        }
        if (addGetter) {
            methodDefinition = new StandardGetter(this);
            methodDefinition.setInterface(!generator.isClass());
            generator.addBeanMethods(this);
            generator.addMethod(methodDefinition);
        }
        if (addSetter) {
            methodDefinition = new StandardSetter(this);
            methodDefinition.setInterface(!generator.isClass());
            generator.addMethod(methodDefinition);
        }
    }

    private String extractPackageName(String variable) {
        int lastDot = variable.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        return variable;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setName(String name) {
        this.name = AccessorDefinition.variableCaseName(name);
    }

    public void setType(String type) {
        this.packageName = this.extractPackageName(type);
        int lastDot = type.lastIndexOf(46);
        this.type = type;
        if (lastDot >= 0) {
            this.type = type.substring(lastDot + 1);
        }
    }

    public class StandardSetter
    extends MethodDefinition {
        public StandardSetter(AccessorDefinition beanDefinition) {
            super(beanDefinition.getType(), NamingUtils.getMutatorName(beanDefinition.getName()));
            this.setReturnType("void");
            if (AccessorDefinition.this.setterContent != null) {
                this.setContent("\t" + StringUtil.filterContent(AccessorDefinition.this.setterContent, AccessorDefinition.this.name, AccessorDefinition.this.type));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("\tthis.").append(beanDefinition.getName()).append(" = ").append(beanDefinition.getName()).append(";");
                this.setContent(sb.toString());
            }
            this.getParameters().add(new Parameter(beanDefinition.getName(), beanDefinition.getType(), ""));
        }
    }

    public class StandardGetter
    extends MethodDefinition {
        public StandardGetter(AccessorDefinition beanDefinition) {
            super(beanDefinition.getType(), NamingUtils.getAccessorName(beanDefinition.getType(), beanDefinition.getName()));
            if (AccessorDefinition.this.getterContent != null) {
                this.setContent("\t" + StringUtil.filterContent(AccessorDefinition.this.getterContent, AccessorDefinition.this.name, AccessorDefinition.this.type));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("\treturn ").append(beanDefinition.getName()).append(";");
                this.setContent(sb.toString());
            }
        }
    }
}

