/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.audit.generator.Parameter;

public class ConstructorDefinition
implements Comparable<ConstructorDefinition> {
    private String visability = "public";
    private String name;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<String> exceptions = new ArrayList<String>();
    private String content;

    public ConstructorDefinition(String className) {
        this.name = className;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getVisability() {
        return this.visability;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setVisability(String visability) {
        this.visability = visability;
    }

    public String toString() {
        boolean first;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVisability()).append(" ");
        sb.append(this.getName()).append("(");
        if (this.getParameters() != null) {
            first = true;
            for (Parameter parameter : this.getParameters()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(parameter);
                first = false;
            }
        }
        sb.append(")");
        if (this.getExceptions() != null && this.getExceptions().size() > 0) {
            sb.append(" throws ");
            first = true;
            for (String string : this.getExceptions()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(string);
                first = false;
            }
        }
        sb.append(" {\n");
        sb.append(this.getContent());
        sb.append("\n}\n\n");
        return sb.toString();
    }

    @Override
    public int compareTo(ConstructorDefinition arg0) {
        return this.getParameters().size() - arg0.getParameters().size();
    }
}

