/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.rest;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.audit.request.ChainedMapping;
import org.apache.logging.log4j.audit.request.RequestContextMapping;
import org.apache.logging.log4j.audit.request.RequestContextMappings;
import org.apache.logging.log4j.audit.rest.ElapsedUtil;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class RequestContextHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LogManager.getLogger(RequestContextHandlerInterceptor.class);
    private RequestContextMappings mappings;
    private ThreadLocal<Long> startTime = new ThreadLocal();

    public RequestContextHandlerInterceptor(Class<?> clazz) {
        this.mappings = new RequestContextMappings(clazz);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        logger.trace("Starting request {}", (Object)request.getRequestURI());
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String name = (String)headers.nextElement();
            RequestContextMapping mapping = this.mappings.getMappingByHeader(name);
            logger.debug("Got Mapping:{} for Header:{}", (Object)mapping, (Object)name);
            if (mapping == null) continue;
            if (mapping.isChained()) {
                ThreadContext.put((String)mapping.getChainKey(), (String)request.getHeader(name));
                logger.debug("Setting Context Key:{} with value:{}", (Object)mapping.getChainKey(), (Object)request.getHeader(name));
                String value = ((ChainedMapping)mapping).getSupplier().get();
                ThreadContext.put((String)mapping.getFieldName(), (String)value);
                logger.debug("Setting Context Key:{} with value:{}", (Object)mapping.getFieldName(), (Object)value);
                continue;
            }
            ThreadContext.put((String)mapping.getFieldName(), (String)request.getHeader(name));
            logger.debug("Setting Context Key:{} with value:{}", (Object)mapping.getFieldName(), (Object)request.getHeader(name));
        }
        if (logger.isTraceEnabled()) {
            this.startTime.set(System.nanoTime());
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
        if (logger.isTraceEnabled()) {
            long elapsed = System.nanoTime() - this.startTime.get();
            StringBuilder sb = new StringBuilder("Request ").append(request.getRequestURI()).append(" completed in ");
            ElapsedUtil.addElapsed(elapsed, sb);
            logger.trace(sb.toString());
            this.startTime.remove();
        }
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        ThreadContext.clearMap();
    }
}

