/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.JoinClause;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.NullCheckClause;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.crawler.interfaces.EnumeratedValues;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.jobs.ForcedParamManager;
import org.apache.manifoldcf.crawler.jobs.HopFilterManager;
import org.apache.manifoldcf.crawler.jobs.JobDescription;
import org.apache.manifoldcf.crawler.jobs.NotificationManager;
import org.apache.manifoldcf.crawler.jobs.PipelineManager;
import org.apache.manifoldcf.crawler.jobs.ScheduleManager;

public class Jobs
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: Jobs.java 991295 2010-08-31 19:12:14Z kwright $";
    public static final int STATUS_INACTIVE = 0;
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_ACTIVESEEDING = 2;
    public static final int STATUS_ACTIVEWAITING = 3;
    public static final int STATUS_ACTIVEWAITINGSEEDING = 4;
    public static final int STATUS_ACTIVEWAIT = 5;
    public static final int STATUS_ACTIVEWAITSEEDING = 6;
    public static final int STATUS_PAUSING = 7;
    public static final int STATUS_PAUSINGSEEDING = 8;
    public static final int STATUS_PAUSINGWAITING = 9;
    public static final int STATUS_PAUSINGWAITINGSEEDING = 10;
    public static final int STATUS_PAUSED = 11;
    public static final int STATUS_PAUSEDSEEDING = 12;
    public static final int STATUS_PAUSEDWAIT = 13;
    public static final int STATUS_PAUSEDWAITSEEDING = 14;
    public static final int STATUS_SHUTTINGDOWN = 15;
    public static final int STATUS_RESUMING = 16;
    public static final int STATUS_RESUMINGSEEDING = 17;
    public static final int STATUS_ABORTING = 18;
    public static final int STATUS_STARTINGUP = 19;
    public static final int STATUS_STARTINGUPMINIMAL = 20;
    public static final int STATUS_READYFORSTARTUP = 23;
    public static final int STATUS_READYFORSTARTUPMINIMAL = 24;
    public static final int STATUS_READYFORDELETE = 25;
    public static final int STATUS_ABORTINGFORRESTART = 27;
    public static final int STATUS_ABORTINGFORRESTARTMINIMAL = 28;
    public static final int STATUS_ABORTINGFORRESTARTSEEDING = 29;
    public static final int STATUS_ABORTINGFORRESTARTSEEDINGMINIMAL = 30;
    public static final int STATUS_ABORTINGSTARTINGUPFORRESTART = 31;
    public static final int STATUS_ABORTINGSTARTINGUPFORRESTARTMINIMAL = 32;
    public static final int STATUS_READYFORNOTIFY = 33;
    public static final int STATUS_NOTIFYINGOFCOMPLETION = 34;
    public static final int STATUS_DELETING = 35;
    public static final int STATUS_DELETESTARTINGUP = 36;
    public static final int STATUS_ABORTINGSHUTTINGDOWN = 37;
    public static final int STATUS_READYFORDELETENOTIFY = 38;
    public static final int STATUS_NOTIFYINGOFDELETION = 39;
    public static final int STATUS_ACTIVE_UNINSTALLED = 40;
    public static final int STATUS_ACTIVESEEDING_UNINSTALLED = 41;
    public static final int STATUS_DELETING_NOOUTPUT = 42;
    public static final int STATUS_ACTIVE_NOOUTPUT = 100;
    public static final int STATUS_ACTIVESEEDING_NOOUTPUT = 101;
    public static final int STATUS_ACTIVE_NEITHER = 102;
    public static final int STATUS_ACTIVESEEDING_NEITHER = 103;
    public static final int ASSESSMENT_KNOWN = 0;
    public static final int ASSESSMENT_UNKNOWN = 1;
    public static final int TYPE_CONTINUOUS = 0;
    public static final int TYPE_SPECIFIED = 1;
    public static final int START_WINDOWBEGIN = 0;
    public static final int START_WINDOWINSIDE = 1;
    public static final int START_DISABLE = 2;
    public static final int HOPCOUNT_ACCURATE = 0;
    public static final int HOPCOUNT_NODELETE = 1;
    public static final int HOPCOUNT_NEVERDELETE = 2;
    public static final String idField = "id";
    public static final String descriptionField = "description";
    public static final String documentSpecField = "docspec";
    public static final String connectionNameField = "connectionname";
    public static final String typeField = "type";
    public static final String intervalField = "intervaltime";
    public static final String maxIntervalField = "maxintervaltime";
    public static final String expirationField = "expirationtime";
    public static final String priorityField = "priority";
    public static final String startMethodField = "startmethod";
    public static final String reseedIntervalField = "reseedinterval";
    public static final String statusField = "status";
    public static final String lastTimeField = "lasttime";
    public static final String startTimeField = "starttime";
    public static final String seedingVersionField = "seedingversion";
    public static final String endTimeField = "endtime";
    public static final String windowEndField = "windowend";
    public static final String errorField = "errortext";
    public static final String reseedTimeField = "reseedtime";
    public static final String hopcountModeField = "hopcountmode";
    public static final String processIDField = "processid";
    public static final String failTimeField = "failtime";
    public static final String failCountField = "failcount";
    public static final String assessmentStateField = "assessmentstate";
    protected static Map<String, Integer> statusMap = new HashMap<String, Integer>();
    protected static Map<String, Integer> typeMap;
    protected static Map<String, Integer> startMap;
    protected static Map<String, Integer> hopmodeMap;
    protected static Map<String, Integer> assessmentMap;
    protected final ICacheManager cacheManager;
    protected final ScheduleManager scheduleManager;
    protected final HopFilterManager hopFilterManager;
    protected final ForcedParamManager forcedParamManager;
    protected final PipelineManager pipelineManager;
    protected final NotificationManager notificationManager;
    protected final IOutputConnectionManager outputMgr;
    protected final IRepositoryConnectionManager connectionMgr;
    protected final ITransformationConnectionManager transMgr;
    protected final ILockManager lockManager;
    protected final IThreadContext threadContext;
    protected static final String jobsLock = "JOBS_LOCK";
    protected final int FETCH_MAX = 200;

    public Jobs(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "jobs");
        this.threadContext = threadContext;
        this.scheduleManager = new ScheduleManager(threadContext, database);
        this.hopFilterManager = new HopFilterManager(threadContext, database);
        this.forcedParamManager = new ForcedParamManager(threadContext, database);
        this.pipelineManager = new PipelineManager(threadContext, database);
        this.notificationManager = new NotificationManager(threadContext, database);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.outputMgr = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
        this.connectionMgr = RepositoryConnectionManagerFactory.make(threadContext);
        this.transMgr = TransformationConnectionManagerFactory.make((IThreadContext)threadContext);
    }

    public void install(String transTableName, String transNameField, String outputTableName, String outputNameField, String connectionTableName, String connectionNameField, String notificationConnectionTableName, String notificationConnectionNameField) throws ManifoldCFException {
        block20: {
            String oldOutputSpecField = "outputspec";
            String oldOutputNameField = "outputname";
            String oldLastCheckTimeField = "lastchecktime";
            IResultSet outputSet = null;
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(idField, new ColumnDescription("BIGINT", true, false, null, null, false));
                map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(statusField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(lastTimeField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(startTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(seedingVersionField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(endTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(documentSpecField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(connectionNameField, new ColumnDescription("VARCHAR(32)", false, false, connectionTableName, connectionNameField, false));
                map.put(typeField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(intervalField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(maxIntervalField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(expirationField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(windowEndField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(priorityField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(startMethodField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(errorField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(reseedIntervalField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(reseedTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(hopcountModeField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                map.put(processIDField, new ColumnDescription("VARCHAR(16)", false, true, null, null, false));
                map.put(failTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(failCountField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(assessmentStateField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                this.performCreate(map, null);
            } else {
                HashMap<String, ColumnDescription> insertMap;
                if (existing.get(processIDField) == null) {
                    insertMap = new HashMap<String, ColumnDescription>();
                    insertMap.put(processIDField, new ColumnDescription("VARCHAR(16)", false, true, null, null, false));
                    this.performAlter(insertMap, null, null, null);
                }
                if (existing.get(maxIntervalField) == null) {
                    insertMap = new HashMap();
                    insertMap.put(maxIntervalField, new ColumnDescription("BIGINT", false, true, null, null, false));
                    this.performAlter(insertMap, null, null, null);
                }
                if (existing.get(failTimeField) == null) {
                    insertMap = new HashMap();
                    insertMap.put(failTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                    this.performAlter(insertMap, null, null, null);
                }
                if (existing.get(failCountField) == null) {
                    insertMap = new HashMap();
                    insertMap.put(failCountField, new ColumnDescription("BIGINT", false, true, null, null, false));
                    this.performAlter(insertMap, null, null, null);
                }
                if (existing.get(assessmentStateField) == null) {
                    insertMap = new HashMap();
                    insertMap.put(assessmentStateField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                    this.performAlter(insertMap, null, null, null);
                    ArrayList list = new ArrayList();
                    HashMap<String, String> map = new HashMap<String, String>();
                    String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(100), Jobs.statusToString(102)})});
                    map.put(statusField, Jobs.statusToString(40));
                    this.performUpdate(map, "WHERE " + query, list, null);
                    list.clear();
                    map.clear();
                    query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(101), Jobs.statusToString(103)})});
                    map.put(statusField, Jobs.statusToString(41));
                    this.performUpdate(map, "WHERE " + query, list, null);
                }
                if (existing.get(seedingVersionField) == null) {
                    insertMap = new HashMap();
                    insertMap.put(seedingVersionField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                    this.performAlter(insertMap, null, null, null);
                    IResultSet set = this.performQuery("SELECT id," + oldLastCheckTimeField + " FROM " + this.getTableName(), null, null, null);
                    for (int i = 0; i < set.getRowCount(); ++i) {
                        IResultRow row = set.getRow(i);
                        Long jobID = (Long)row.getValue(idField);
                        Long oldTime = (Long)row.getValue(oldLastCheckTimeField);
                        if (oldTime == null) continue;
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(seedingVersionField, oldTime.toString());
                        ArrayList list = new ArrayList();
                        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
                        this.performUpdate(map, "WHERE " + query, list, null);
                    }
                    ArrayList<String> deleteList = new ArrayList<String>();
                    deleteList.add(oldLastCheckTimeField);
                    this.performAlter(null, null, deleteList, null);
                }
                if (existing.get(oldOutputNameField) != null) {
                    outputSet = this.performQuery("SELECT id," + oldOutputSpecField + "," + oldOutputNameField + " FROM " + this.getTableName(), null, null, null);
                    ArrayList<String> deleteList = new ArrayList<String>();
                    deleteList.add(oldOutputSpecField);
                    deleteList.add(oldOutputNameField);
                    this.performAlter(null, null, deleteList, null);
                }
            }
            this.pipelineManager.install(this.getTableName(), idField, outputTableName, outputNameField, transTableName, transNameField);
            if (outputSet != null) {
                for (int k = 0; k < outputSet.getRowCount(); ++k) {
                    IResultRow row = outputSet.getRow(k);
                    Long id = (Long)row.getValue(idField);
                    String outputConnectionName = (String)row.getValue(oldOutputNameField);
                    String outputConnectionSpec = (String)row.getValue(oldOutputSpecField);
                    this.pipelineManager.writeOutputStage(id, outputConnectionName, outputConnectionSpec);
                }
            }
            this.notificationManager.install(this.getTableName(), idField, notificationConnectionTableName, notificationConnectionNameField);
            this.scheduleManager.install(this.getTableName(), idField);
            this.hopFilterManager.install(this.getTableName(), idField);
            this.forcedParamManager.install(this.getTableName(), idField);
            IndexDescription statusIndex = new IndexDescription(false, new String[]{statusField, idField, priorityField});
            IndexDescription statusProcessIndex = new IndexDescription(false, new String[]{statusField, processIDField});
            IndexDescription connectionIndex = new IndexDescription(false, new String[]{connectionNameField});
            IndexDescription failTimeIndex = new IndexDescription(false, new String[]{failTimeField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (statusIndex != null && id.equals((Object)statusIndex)) {
                    statusIndex = null;
                    continue;
                }
                if (statusProcessIndex != null && id.equals((Object)statusProcessIndex)) {
                    statusProcessIndex = null;
                    continue;
                }
                if (connectionIndex != null && id.equals((Object)connectionIndex)) {
                    connectionIndex = null;
                    continue;
                }
                if (failTimeIndex != null && id.equals((Object)failTimeIndex)) {
                    failTimeIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (statusIndex != null) {
                this.performAddIndex(null, statusIndex);
            }
            if (statusProcessIndex != null) {
                this.performAddIndex(null, statusProcessIndex);
            }
            if (connectionIndex != null) {
                this.performAddIndex(null, connectionIndex);
            }
            if (failTimeIndex == null) break block20;
            this.performAddIndex(null, failTimeIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.beginTransaction();
        try {
            this.forcedParamManager.deinstall();
            this.hopFilterManager.deinstall();
            this.scheduleManager.deinstall();
            this.notificationManager.deinstall();
            this.pipelineManager.deinstall();
            this.performDrop(null);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public int getAnalyzeTime() throws ManifoldCFException {
        return 1440;
    }

    public void analyzeTables() throws ManifoldCFException {
        this.analyzeTable();
    }

    public Long[] findJobsMatchingNotifications(List<String> notificationConnectionNames) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList params = new ArrayList();
        query.append("SELECT ").append(idField).append(" FROM ").append(this.getTableName()).append(" t1 WHERE EXISTS(");
        this.notificationManager.buildNotificationQueryClause(query, params, "t1.id", notificationConnectionNames);
        query.append(")");
        IResultSet set = this.performQuery(query.toString(), params, null, null);
        Long[] rval = new Long[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (Long)row.getValue(idField);
        }
        return rval;
    }

    public Long[] findJobsMatchingTransformations(List<String> transformationConnectionNames) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList params = new ArrayList();
        query.append("SELECT ").append(idField).append(" FROM ").append(this.getTableName()).append(" t1 WHERE EXISTS(");
        this.pipelineManager.buildTransformationQueryClause(query, params, "t1.id", transformationConnectionNames);
        query.append(")");
        IResultSet set = this.performQuery(query.toString(), params, null, null);
        Long[] rval = new Long[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (Long)row.getValue(idField);
        }
        return rval;
    }

    public Long[] findJobsMatchingOutputs(List<String> outputConnectionNames) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList params = new ArrayList();
        query.append("SELECT ").append(idField).append(" FROM ").append(this.getTableName()).append(" t1 WHERE EXISTS(");
        this.pipelineManager.buildOutputQueryClause(query, params, "t1.id", outputConnectionNames);
        query.append(")");
        IResultSet set = this.performQuery(query.toString(), params, null, null);
        Long[] rval = new Long[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (Long)row.getValue(idField);
        }
        return rval;
    }

    public ScheduleRecord[][] readScheduleRecords(Long[] jobIDs) throws ManifoldCFException {
        HashMap<Long, Long> uniqueIDs = new HashMap<Long, Long>();
        int i = 0;
        while (i < jobIDs.length) {
            Long jobID = jobIDs[i++];
            uniqueIDs.put(jobID, jobID);
        }
        HashMap returnValues = new HashMap();
        this.beginTransaction();
        try {
            ArrayList params = new ArrayList();
            int j = 0;
            int maxIn = this.scheduleManager.maxClauseGetRowsAlternate();
            Iterator iter = uniqueIDs.keySet().iterator();
            while (iter.hasNext()) {
                if (j == maxIn) {
                    this.scheduleManager.getRowsAlternate(returnValues, params);
                    params.clear();
                    j = 0;
                }
                params.add(iter.next());
                ++j;
            }
            if (j > 0) {
                this.scheduleManager.getRowsAlternate(returnValues, params);
            }
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
        ScheduleRecord[][] rval = new ScheduleRecord[jobIDs.length][];
        i = 0;
        while (i < jobIDs.length) {
            ScheduleRecord[] srList;
            ArrayList al = (ArrayList)returnValues.get(jobIDs[i]);
            if (al == null) {
                srList = new ScheduleRecord[]{};
            } else {
                srList = new ScheduleRecord[al.size()];
                for (int k = 0; k < srList.length; ++k) {
                    srList[k] = (ScheduleRecord)al.get(k);
                }
            }
            rval[i++] = srList;
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJobDescription[] getAll() throws ManifoldCFException {
        this.lockManager.enterReadLock(jobsLock);
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(Jobs.getJobsKey());
            ssb.add(Jobs.getJobStatusKey());
            StringSet cacheKeys = new StringSet(ssb);
            ArrayList<String> list = new ArrayList<String>();
            list.add(Jobs.statusToString(25));
            list.add(Jobs.statusToString(36));
            list.add(Jobs.statusToString(35));
            list.add(Jobs.statusToString(42));
            IResultSet set = this.performQuery("SELECT id,description FROM " + this.getTableName() + " WHERE " + statusField + "!=? AND " + statusField + "!=? AND " + statusField + "!=? AND " + statusField + "!=?" + " ORDER BY " + descriptionField + " ASC", list, cacheKeys, null);
            Long[] ids = new Long[set.getRowCount()];
            boolean[] readOnlies = new boolean[set.getRowCount()];
            for (int i = 0; i < set.getRowCount(); ++i) {
                IResultRow row = set.getRow(i);
                ids[i] = (Long)row.getValue(idField);
                readOnlies[i] = true;
            }
            IJobDescription[] iJobDescriptionArray = this.loadMultiple(ids, readOnlies);
            return iJobDescriptionArray;
        }
        finally {
            this.lockManager.leaveReadLock(jobsLock);
        }
    }

    public IResultSet getActiveJobConnections() throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(1), Jobs.statusToString(2)})});
        return this.performQuery("SELECT id AS jobid,connectionname AS connectionname FROM " + this.getTableName() + " WHERE " + query, list, null, null);
    }

    public String[] getActiveConnectionNames() throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(1), Jobs.statusToString(2)})});
        IResultSet set = this.performQuery("SELECT DISTINCT connectionname FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        String[] rval = new String[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(connectionNameField);
        }
        return rval;
    }

    public boolean hasPriorityJobs(int priority) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(1), Jobs.statusToString(2)})});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query + " AND " + priorityField + "=" + Integer.toString(priority) + " " + this.constructOffsetLimitClause(0, 1), list, null, null, 1);
        return set.getRowCount() > 0;
    }

    public IJobDescription create() throws ManifoldCFException {
        JobDescription rval = new JobDescription();
        rval.setIsNew(true);
        rval.setID(new Long(IDFactory.make((IThreadContext)this.threadContext)));
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Long id) throws ManifoldCFException {
        this.lockManager.enterNonExWriteLock(jobsLock);
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(Jobs.getJobsKey());
            ssb.add(Jobs.getJobStatusKey());
            ssb.add(Jobs.getJobIDKey(id));
            StringSet cacheKeys = new StringSet(ssb);
            this.beginTransaction();
            try {
                this.scheduleManager.deleteRows(id);
                this.hopFilterManager.deleteRows(id);
                this.forcedParamManager.deleteRows(id);
                this.pipelineManager.deleteRows(id);
                this.notificationManager.deleteRows(id);
                ArrayList params = new ArrayList();
                String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(idField, (Object)id)});
                this.performDelete("WHERE " + query, params, cacheKeys);
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
            }
        }
        finally {
            this.lockManager.leaveNonExWriteLock(jobsLock);
        }
    }

    public IJobDescription load(Long id, boolean readOnly) throws ManifoldCFException {
        return this.loadMultiple(new Long[]{id}, new boolean[]{readOnly})[0];
    }

    public IJobDescription[] loadMultiple(Long[] ids, boolean[] readOnlies) throws ManifoldCFException {
        IJobDescription[] rval = new IJobDescription[ids.length];
        if (ids.length == 0) {
            return rval;
        }
        int inputIndex = 0;
        int outputIndex = 0;
        while (ids.length - inputIndex > 200) {
            outputIndex = this.loadMultipleInternal(rval, outputIndex, ids, readOnlies, inputIndex, 200);
            inputIndex += 200;
        }
        this.loadMultipleInternal(rval, outputIndex, ids, readOnlies, inputIndex, ids.length - inputIndex);
        return rval;
    }

    protected int loadMultipleInternal(IJobDescription[] rval, int outputIndex, Long[] ids, boolean[] readOnlies, int inputIndex, int length) throws ManifoldCFException {
        JobDescription[] results;
        JobObjectDescription[] objectDescriptions = new JobObjectDescription[length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < length; ++i) {
            Long id = ids[inputIndex + i];
            ssb.clear();
            ssb.add(Jobs.getJobIDKey(id));
            objectDescriptions[i] = new JobObjectDescription(id, new StringSet(ssb));
        }
        JobObjectExecutor exec = new JobObjectExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        for (JobDescription result : results = exec.getResults(readOnlies, inputIndex)) {
            rval[outputIndex++] = result;
        }
        return outputIndex;
    }

    /*
     * Exception decompiling
     */
    public void save(IJobDescription jobDescription) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clearSeedingState(Long jobID) throws ManifoldCFException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(seedingVersionField, null);
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        this.performUpdate(values, "WHERE " + query, params, null);
    }

    public void restart(String processID) throws ManifoldCFException {
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(36)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(25));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(34)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(33));
        map.put(processIDField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(39)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(38));
        map.put(processIDField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(19)}), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(23));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(20)}), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(24));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(31)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(27));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(32)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(28));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(2)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(1));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(8)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(7));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(4)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(3));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(10)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(9));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(17)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(16));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(29)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(27));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(30)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(28));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(12)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(11));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(6)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(5));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(14)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(13));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(41)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(40));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
    }

    public void restart() throws ManifoldCFException {
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(36))});
        map.put(statusField, Jobs.statusToString(25));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(34))});
        map.put(statusField, Jobs.statusToString(33));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(39))});
        map.put(statusField, Jobs.statusToString(38));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(19)})});
        map.put(statusField, Jobs.statusToString(23));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(20)})});
        map.put(statusField, Jobs.statusToString(24));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(31))});
        map.put(statusField, Jobs.statusToString(27));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(32))});
        map.put(statusField, Jobs.statusToString(28));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(2))});
        map.put(statusField, Jobs.statusToString(1));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(8))});
        map.put(statusField, Jobs.statusToString(7));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(4))});
        map.put(statusField, Jobs.statusToString(3));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(10))});
        map.put(statusField, Jobs.statusToString(9));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(17))});
        map.put(statusField, Jobs.statusToString(16));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(29))});
        map.put(statusField, Jobs.statusToString(27));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(30))});
        map.put(statusField, Jobs.statusToString(28));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(12))});
        map.put(statusField, Jobs.statusToString(11));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(6))});
        map.put(statusField, Jobs.statusToString(5));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(14))});
        map.put(statusField, Jobs.statusToString(13));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(41))});
        map.put(statusField, Jobs.statusToString(40));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
    }

    public void restartCluster() throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(failTimeField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new NullCheckClause(failTimeField, false)});
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    public void invalidateCurrentUnregisteredState(Long jobID, int oldStatusValue) throws ManifoldCFException {
        if (oldStatusValue == 40 || oldStatusValue == 41 || oldStatusValue == 42) {
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(assessmentStateField, Jobs.assessmentStateToString(1));
            this.performUpdate(map, "WHERE " + query, list, null);
        }
    }

    public void noteTransformationConnectorDeregistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        int newStatusValue;
        switch (oldStatusValue) {
            case 1: {
                newStatusValue = 40;
                break;
            }
            case 2: {
                newStatusValue = 41;
                break;
            }
            default: {
                newStatusValue = oldStatusValue;
            }
        }
        if (newStatusValue == oldStatusValue) {
            return;
        }
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        HashMap<String, String> newValues = new HashMap<String, String>();
        newValues.put(statusField, Jobs.statusToString(newStatusValue));
        newValues.put(assessmentStateField, Jobs.assessmentStateToString(0));
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        this.performUpdate(newValues, "WHERE " + query, list, invKey);
    }

    public void noteTransformationConnectorRegistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        this.invalidateCurrentUnregisteredState(jobID, oldStatusValue);
    }

    public void noteOutputConnectorDeregistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        int newStatusValue;
        switch (oldStatusValue) {
            case 1: {
                newStatusValue = 40;
                break;
            }
            case 2: {
                newStatusValue = 41;
                break;
            }
            case 35: {
                newStatusValue = 42;
                break;
            }
            default: {
                newStatusValue = oldStatusValue;
            }
        }
        if (newStatusValue == oldStatusValue) {
            return;
        }
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        HashMap<String, String> newValues = new HashMap<String, String>();
        newValues.put(statusField, Jobs.statusToString(newStatusValue));
        newValues.put(assessmentStateField, Jobs.assessmentStateToString(0));
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        this.performUpdate(newValues, "WHERE " + query, list, invKey);
    }

    public void noteOutputConnectorRegistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        if (oldStatusValue == 42) {
            StringSet invKey = new StringSet(Jobs.getJobStatusKey());
            HashMap<String, String> newValues = new HashMap<String, String>();
            newValues.put(statusField, Jobs.statusToString(35));
            newValues.put(assessmentStateField, Jobs.assessmentStateToString(0));
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            this.performUpdate(newValues, "WHERE " + query, list, invKey);
            return;
        }
        this.invalidateCurrentUnregisteredState(jobID, oldStatusValue);
    }

    public void noteNotificationConnectorDeregistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
    }

    public void noteConnectorDeregistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        int newStatusValue;
        switch (oldStatusValue) {
            case 1: {
                newStatusValue = 40;
                break;
            }
            case 2: {
                newStatusValue = 41;
                break;
            }
            default: {
                newStatusValue = oldStatusValue;
            }
        }
        if (newStatusValue == oldStatusValue) {
            return;
        }
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        HashMap<String, String> newValues = new HashMap<String, String>();
        newValues.put(statusField, Jobs.statusToString(newStatusValue));
        newValues.put(assessmentStateField, Jobs.assessmentStateToString(0));
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        this.performUpdate(newValues, "WHERE " + query, list, invKey);
    }

    public void noteNotificationConnectorRegistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
    }

    public void noteConnectorRegistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        this.invalidateCurrentUnregisteredState(jobID, oldStatusValue);
    }

    public void noteConnectionChange(String connectionName) throws ManifoldCFException {
        HashMap<String, Object> newValues = new HashMap<String, Object>();
        newValues.put(seedingVersionField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(connectionNameField, (Object)connectionName)});
        this.performUpdate(newValues, "WHERE " + query, list, null);
    }

    public void noteNotificationConnectionChange(String connectionName) throws ManifoldCFException {
    }

    public void noteOutputConnectionChange(String connectionName) throws ManifoldCFException {
        HashMap<String, Object> newValues = new HashMap<String, Object>();
        newValues.put(seedingVersionField, null);
        ArrayList list = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
        clauseDescriptionArray[0] = new JoinClause(this.getTableName() + "." + idField, "ownerid");
        clauseDescriptionArray[1] = new UnitaryClause("outputname", (Object)connectionName);
        String query = this.buildConjunctionClause(list, clauseDescriptionArray);
        this.performUpdate(newValues, "WHERE EXISTS(SELECT 'x' FROM " + this.pipelineManager.getTableName() + " WHERE " + query + ")", list, null);
    }

    public void noteTransformationConnectionChange(String connectionName) throws ManifoldCFException {
        HashMap<String, Object> newValues = new HashMap<String, Object>();
        newValues.put(seedingVersionField, null);
        ArrayList list = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
        clauseDescriptionArray[0] = new JoinClause(this.getTableName() + "." + idField, "ownerid");
        clauseDescriptionArray[1] = new UnitaryClause("transformationname", (Object)connectionName);
        String query = this.buildConjunctionClause(list, clauseDescriptionArray);
        this.performUpdate(newValues, "WHERE EXISTS(SELECT 'x' FROM " + this.pipelineManager.getTableName() + " WHERE " + query + ")", list, null);
    }

    public boolean checkJobActive(Long jobID) throws ManifoldCFException {
        StringSet cacheKeys = new StringSet(Jobs.getJobStatusKey());
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + query, list, cacheKeys, null);
        if (set.getRowCount() == 0) {
            return false;
        }
        IResultRow row = set.getRow(0);
        String statusValue = (String)row.getValue(statusField);
        int status = Jobs.stringToStatus(statusValue);
        return status == 1 || status == 2 || status == 19 || status == 20;
    }

    public void resetDeleteStartupWorkerStatus(String processID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(36)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(25));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void resetNotificationWorkerStatus(String processID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(34)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(33));
        map.put(processIDField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        list.clear();
        map.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(39)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(38));
        map.put(processIDField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void resetStartupWorkerStatus(String processID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        list.clear();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(19)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(23));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(20)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(24));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(31)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(27));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(32)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(28));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void resetSeedingWorkerStatus(String processID) throws ManifoldCFException {
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        list.clear();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(2)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(1));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(8)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(7));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(4)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(3));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(10)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(9));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(17)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(16));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(29)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(27));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(30)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(28));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(12)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(11));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(6)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(5));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(14)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(13));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(41)), new UnitaryClause(processIDField, (Object)processID)});
        map.put(statusField, Jobs.statusToString(40));
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, invKey);
    }

    public void retryStartup(Long jobID, boolean requestMinimum, long failTime, int failCount) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (requestMinimum) {
            map.put(statusField, Jobs.statusToString(24));
        } else {
            map.put(statusField, Jobs.statusToString(23));
        }
        if (failTime == -1L) {
            map.put(failTimeField, null);
        } else {
            map.put(failTimeField, new Long(failTime));
        }
        if (failCount == -1) {
            map.put(failCountField, null);
        } else {
            map.put(failCountField, failCount);
        }
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void retrySeeding(Long jobID, long failTime, int failCount) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Can't find job " + jobID.toString());
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus((String)row.getValue(statusField));
            switch (status) {
                case 2: {
                    newStatus = 1;
                    break;
                }
                case 8: {
                    newStatus = 7;
                    break;
                }
                case 4: {
                    newStatus = 3;
                    break;
                }
                case 10: {
                    newStatus = 9;
                    break;
                }
                case 41: {
                    newStatus = 40;
                    break;
                }
                case 6: {
                    newStatus = 5;
                    break;
                }
                case 12: {
                    newStatus = 11;
                    break;
                }
                case 14: {
                    newStatus = 13;
                    break;
                }
                case 29: {
                    newStatus = 27;
                    break;
                }
                case 30: {
                    newStatus = 28;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected job status encountered: " + Integer.toString(status));
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(statusField, Jobs.statusToString(newStatus));
            if (failTime == -1L) {
                map.put(failTimeField, null);
            } else {
                map.put(failTimeField, new Long(failTime));
            }
            if (failCount == -1) {
                map.put(failCountField, null);
            } else {
                map.put(failCountField, failCount);
            }
            map.put(processIDField, null);
            this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (RuntimeException e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void retryNotification(Long jobID, long failTime, int failCount) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(33));
        if (failTime == -1L) {
            map.put(failTimeField, null);
        } else {
            map.put(failTimeField, new Long(failTime));
        }
        if (failCount == -1) {
            map.put(failCountField, null);
        } else {
            map.put(failCountField, failCount);
        }
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void retryDeleteNotification(Long jobID, long failTime, int failCount) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(38));
        if (failTime == -1L) {
            map.put(failTimeField, null);
        } else {
            map.put(failTimeField, new Long(failTime));
        }
        if (failCount == -1) {
            map.put(failCountField, null);
        } else {
            map.put(failCountField, failCount);
        }
        map.put(processIDField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void startJob(Long jobID, Long windowEnd, boolean requestMinimum) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(requestMinimum ? 24 : 23));
        map.put(endTimeField, null);
        map.put(errorField, null);
        map.put(windowEndField, windowEnd);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void assessMarkedJobs() throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(assessmentStateField, (Object)Jobs.assessmentStateToString(1))});
        IResultSet set = this.performQuery("SELECT id,status,connectionname FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", newList, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long jobID = (Long)row.getValue(idField);
            String connectionName = (String)row.getValue(connectionNameField);
            String[] transformationNames = this.pipelineManager.getTransformationConnectionNames(jobID);
            String[] outputNames = this.pipelineManager.getOutputConnectionNames(jobID);
            int statusValue = Jobs.stringToStatus((String)row.getValue(statusField));
            switch (statusValue) {
                case 42: {
                    int newValue;
                    if (this.checkOutputsInstalled(outputNames)) {
                        newValue = 35;
                        break;
                    }
                    return;
                }
                case 40: {
                    int newValue;
                    if (this.connectionMgr.checkConnectorExists(connectionName) && this.checkTransformationsInstalled(transformationNames) && this.checkOutputsInstalled(outputNames)) {
                        newValue = 1;
                        break;
                    }
                    return;
                }
                case 41: {
                    int newValue;
                    if (this.connectionMgr.checkConnectorExists(connectionName) && this.checkTransformationsInstalled(transformationNames) && this.checkOutputsInstalled(outputNames)) {
                        newValue = 2;
                        break;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            ArrayList list = new ArrayList();
            query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(assessmentStateField, Jobs.assessmentStateToString(0));
            this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        }
    }

    public void returnJobToActive(Long jobID) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            IResultSet set = this.performQuery("SELECT status,connectionname FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Can't find job " + jobID.toString());
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus((String)row.getValue(statusField));
            switch (status) {
                case 15: {
                    String[] transformationConnectionNames = this.pipelineManager.getTransformationConnectionNames(jobID);
                    String[] outputConnectionNames = this.pipelineManager.getOutputConnectionNames(jobID);
                    String connectionName = (String)row.getValue(connectionNameField);
                    if (!(this.checkTransformationsInstalled(transformationConnectionNames) && this.checkOutputsInstalled(outputConnectionNames) && this.connectionMgr.checkConnectorExists(connectionName))) {
                        newStatus = 40;
                        break;
                    }
                    newStatus = 1;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected job status encountered: " + Integer.toString(status));
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(statusField, Jobs.statusToString(newStatus));
            map.put(processIDField, null);
            this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (RuntimeException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected boolean checkTransformationsInstalled(String[] transformationNames) throws ManifoldCFException {
        for (String transformationName : transformationNames) {
            if (this.transMgr.checkConnectorExists(transformationName)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkOutputsInstalled(String[] outputNames) throws ManifoldCFException {
        for (String outputName : outputNames) {
            if (this.outputMgr.checkConnectorExists(outputName)) continue;
            return false;
        }
        return true;
    }

    public void noteJobDeleteStarted(Long jobID, long startTime) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Can't find job " + jobID.toString());
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus((String)row.getValue(statusField));
            String[] outputNames = this.pipelineManager.getOutputConnectionNames(jobID);
            switch (status) {
                case 36: {
                    if (this.checkOutputsInstalled(outputNames)) {
                        newStatus = 35;
                        break;
                    }
                    newStatus = 42;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected job status encountered: " + Integer.toString(status));
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(statusField, Jobs.statusToString(newStatus));
            if (newStatus == 35 || newStatus == 42) {
                map.put(startTimeField, new Long(startTime));
            }
            map.put(seedingVersionField, null);
            this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (RuntimeException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void noteJobStarted(Long jobID, long startTime, String seedVersionString) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            IResultSet set = this.performQuery("SELECT status,connectionname FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Can't find job " + jobID.toString());
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus((String)row.getValue(statusField));
            switch (status) {
                case 19: 
                case 20: {
                    String[] transformationConnectionNames = this.pipelineManager.getTransformationConnectionNames(jobID);
                    String[] outputConnectionNames = this.pipelineManager.getOutputConnectionNames(jobID);
                    String connectionName = (String)row.getValue(connectionNameField);
                    if (!(this.checkTransformationsInstalled(transformationConnectionNames) && this.checkOutputsInstalled(outputConnectionNames) && this.connectionMgr.checkConnectorExists(connectionName))) {
                        newStatus = 40;
                        break;
                    }
                    newStatus = 1;
                    break;
                }
                case 31: {
                    newStatus = 27;
                    break;
                }
                case 32: {
                    newStatus = 28;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected job status encountered: " + Integer.toString(status));
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(statusField, Jobs.statusToString(newStatus));
            if (newStatus == 1 || newStatus == 40) {
                map.put(startTimeField, new Long(startTime));
            }
            map.put(seedingVersionField, seedVersionString);
            map.put(failTimeField, null);
            map.put(failCountField, null);
            map.put(processIDField, null);
            this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (RuntimeException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void noteJobSeeded(Long jobID, String seedVersionString) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Can't find job " + jobID.toString());
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus((String)row.getValue(statusField));
            switch (status) {
                case 2: {
                    newStatus = 1;
                    break;
                }
                case 8: {
                    newStatus = 7;
                    break;
                }
                case 4: {
                    newStatus = 3;
                    break;
                }
                case 10: {
                    newStatus = 9;
                    break;
                }
                case 41: {
                    newStatus = 40;
                    break;
                }
                case 6: {
                    newStatus = 5;
                    break;
                }
                case 12: {
                    newStatus = 11;
                    break;
                }
                case 14: {
                    newStatus = 13;
                    break;
                }
                case 29: {
                    newStatus = 27;
                    break;
                }
                case 30: {
                    newStatus = 28;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected job status encountered: " + Integer.toString(status));
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(statusField, Jobs.statusToString(newStatus));
            map.put(processIDField, null);
            map.put(seedingVersionField, seedVersionString);
            map.put(failTimeField, null);
            map.put(failCountField, null);
            this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (RuntimeException e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void unwaitJob(Long jobID, int newStatus, Long windowEnd) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(newStatus));
        map.put(windowEndField, windowEnd);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void waitJob(Long jobID, int newStatus) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(newStatus));
        map.put(assessmentStateField, Jobs.assessmentStateToString(0));
        map.put(windowEndField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public boolean abortJob(Long jobID, String errorText) throws ManifoldCFException {
        int newStatus;
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
        if (set.getRowCount() == 0) {
            throw new ManifoldCFException("Job does not exist: " + jobID);
        }
        IResultRow row = set.getRow(0);
        int status = Jobs.stringToStatus(row.getValue(statusField).toString());
        if (status == 18 || status == 37) {
            return false;
        }
        switch (status) {
            case 34: {
                newStatus = 0;
                break;
            }
            case 19: 
            case 31: {
                newStatus = 18;
                break;
            }
            case 20: 
            case 32: {
                newStatus = 18;
                break;
            }
            case 15: {
                newStatus = 37;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 40: {
                newStatus = 18;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 29: 
            case 30: 
            case 41: {
                newStatus = 18;
                break;
            }
            default: {
                throw new ManifoldCFException("Job " + jobID + " is not active");
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(newStatus));
        map.put(errorField, errorText);
        map.put(processIDField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        return true;
    }

    public void abortRestartJob(Long jobID, boolean requestMinimum) throws ManifoldCFException {
        int newStatus;
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
        if (set.getRowCount() == 0) {
            throw new ManifoldCFException("Job does not exist: " + jobID);
        }
        IResultRow row = set.getRow(0);
        int status = Jobs.stringToStatus(row.getValue(statusField).toString());
        if (status == 27 || status == 29 || status == 31 || status == 28 || status == 30 || status == 32) {
            return;
        }
        switch (status) {
            case 19: 
            case 20: {
                newStatus = requestMinimum ? 32 : 31;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 23: 
            case 24: 
            case 40: {
                newStatus = requestMinimum ? 28 : 27;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 41: {
                newStatus = requestMinimum ? 30 : 29;
                break;
            }
            default: {
                throw new ManifoldCFException("Job " + jobID + " is not restartable");
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(newStatus));
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void pauseJob(Long jobID) throws ManifoldCFException {
        int newStatus;
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
        if (set.getRowCount() == 0) {
            throw new ManifoldCFException("Job does not exist: " + jobID);
        }
        IResultRow row = set.getRow(0);
        int status = Jobs.stringToStatus(row.getValue(statusField).toString());
        switch (status) {
            case 1: 
            case 40: {
                newStatus = 7;
                break;
            }
            case 3: {
                newStatus = 9;
                break;
            }
            case 5: {
                newStatus = 13;
                break;
            }
            case 2: 
            case 41: {
                newStatus = 8;
                break;
            }
            case 4: {
                newStatus = 10;
                break;
            }
            case 6: {
                newStatus = 14;
                break;
            }
            default: {
                throw new ManifoldCFException("Job " + jobID + " is not active");
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(newStatus));
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void restartJob(Long jobID) throws ManifoldCFException {
        int newStatus;
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
        if (set.getRowCount() == 0) {
            throw new ManifoldCFException("Job does not exist: " + jobID);
        }
        IResultRow row = set.getRow(0);
        int status = Jobs.stringToStatus(row.getValue(statusField).toString());
        switch (status) {
            case 11: {
                newStatus = 16;
                break;
            }
            case 13: {
                newStatus = 5;
                break;
            }
            case 12: {
                newStatus = 17;
                break;
            }
            case 14: {
                newStatus = 6;
                break;
            }
            default: {
                throw new ManifoldCFException("Job " + jobID + " is not paused");
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(newStatus));
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void writeTransientStatus(Long jobID, int status, Long reseedTime, String processID) throws ManifoldCFException {
        this.writeStatus(jobID, status, reseedTime, processID, false);
    }

    public void writePermanentStatus(Long jobID, int status, Long reseedTime) throws ManifoldCFException {
        this.writeStatus(jobID, status, reseedTime, null, false);
    }

    public void writePermanentStatus(Long jobID, int status, Long reseedTime, boolean clearFailTime) throws ManifoldCFException {
        this.writeStatus(jobID, status, reseedTime, null, clearFailTime);
    }

    protected void writeStatus(Long jobID, int status, Long reseedTime, String processID, boolean clearFailTime) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(status));
        map.put(processIDField, processID);
        map.put(reseedTimeField, reseedTime);
        if (clearFailTime) {
            map.put(failTimeField, null);
            map.put(failCountField, null);
        }
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void writeTransientStatus(Long jobID, int status, String processID) throws ManifoldCFException {
        this.writeStatus(jobID, status, processID, false);
    }

    public void writePermanentStatus(Long jobID, int status) throws ManifoldCFException {
        this.writeStatus(jobID, status, null, false);
    }

    public void writePermanentStatus(Long jobID, int status, boolean clearFailTime) throws ManifoldCFException {
        this.writeStatus(jobID, status, null, clearFailTime);
    }

    protected void writeStatus(Long jobID, int status, String processID, boolean clearFailTime) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(status));
        map.put(processIDField, processID);
        if (clearFailTime) {
            map.put(failTimeField, null);
            map.put(failCountField, null);
        }
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void updateLastTime(Long jobID, long currentTime) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(lastTimeField, new Long(currentTime));
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    public void finishJob(Long jobID, long finishTime) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(33));
        map.put(errorField, null);
        map.put(endTimeField, new Long(finishTime));
        map.put(lastTimeField, new Long(finishTime));
        map.put(windowEndField, null);
        map.put(reseedTimeField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void finishJobCleanup(Long jobID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(38));
        map.put(errorField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void finishResumeJob(Long jobID, long currentTime) throws ManifoldCFException {
        this.beginTransaction();
        try {
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            IResultSet set = this.performQuery("SELECT status,connectionname FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Job does not exist: " + jobID);
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus(row.getValue(statusField).toString());
            String[] transformationConnectionNames = this.pipelineManager.getTransformationConnectionNames(jobID);
            String[] outputConnectionNames = this.pipelineManager.getOutputConnectionNames(jobID);
            String connectionName = (String)row.getValue(connectionNameField);
            HashMap<String, String> map = new HashMap<String, String>();
            switch (status) {
                case 16: {
                    int newStatus = !this.checkTransformationsInstalled(transformationConnectionNames) || !this.checkOutputsInstalled(outputConnectionNames) || !this.connectionMgr.checkConnectorExists(connectionName) ? 40 : 1;
                    map.put(statusField, Jobs.statusToString(newStatus));
                    break;
                }
                case 17: {
                    int newStatus = !this.checkTransformationsInstalled(transformationConnectionNames) || !this.checkOutputsInstalled(outputConnectionNames) || !this.connectionMgr.checkConnectorExists(connectionName) ? 41 : 2;
                    map.put(statusField, Jobs.statusToString(newStatus));
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected value for job status: " + Integer.toString(status));
                }
            }
            this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void finishStopJob(Long jobID, long currentTime) throws ManifoldCFException {
        this.beginTransaction();
        try {
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
            IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Job does not exist: " + jobID);
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus(row.getValue(statusField).toString());
            HashMap<String, Object> map = new HashMap<String, Object>();
            switch (status) {
                case 18: 
                case 37: {
                    map.put(statusField, Jobs.statusToString(33));
                    map.put(endTimeField, null);
                    map.put(lastTimeField, new Long(currentTime));
                    map.put(windowEndField, null);
                    map.put(reseedTimeField, null);
                    break;
                }
                case 27: {
                    map.put(statusField, Jobs.statusToString(23));
                    map.put(endTimeField, null);
                    map.put(errorField, null);
                    map.put(windowEndField, null);
                    break;
                }
                case 28: {
                    map.put(statusField, Jobs.statusToString(24));
                    map.put(endTimeField, null);
                    map.put(errorField, null);
                    map.put(windowEndField, null);
                    break;
                }
                case 7: {
                    map.put(statusField, Jobs.statusToString(11));
                    break;
                }
                case 8: {
                    map.put(statusField, Jobs.statusToString(12));
                    break;
                }
                case 3: {
                    map.put(statusField, Jobs.statusToString(5));
                    break;
                }
                case 4: {
                    map.put(statusField, Jobs.statusToString(6));
                    break;
                }
                case 9: {
                    map.put(statusField, Jobs.statusToString(13));
                    break;
                }
                case 10: {
                    map.put(statusField, Jobs.statusToString(14));
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected value for job status: " + Integer.toString(status));
                }
            }
            this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void notificationComplete(Long jobID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)jobID)});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(0));
        map.put(processIDField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        this.performUpdate(map, "WHERE " + query, list, new StringSet(Jobs.getJobStatusKey()));
    }

    public boolean checkIfReference(String connectionName) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(connectionNameField, (Object)connectionName)});
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + query, list, new StringSet(Jobs.getJobsKey()), null);
        return set.getRowCount() > 0;
    }

    public boolean checkIfNotificationReference(String connectionName) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new UnitaryClause("notificationname", (Object)connectionName);
        String query = this.buildConjunctionClause(list, clauseDescriptionArray);
        IResultSet set = this.performQuery("SELECT " + "ownerid" + " FROM " + this.notificationManager.getTableName() + " WHERE " + query, list, new StringSet(Jobs.getJobsKey()), null);
        return set.getRowCount() > 0;
    }

    public boolean checkIfOutputReference(String connectionName) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new UnitaryClause("outputname", (Object)connectionName);
        String query = this.buildConjunctionClause(list, clauseDescriptionArray);
        IResultSet set = this.performQuery("SELECT " + "ownerid" + " FROM " + this.pipelineManager.getTableName() + " WHERE " + query, list, new StringSet(Jobs.getJobsKey()), null);
        return set.getRowCount() > 0;
    }

    public boolean checkIfTransformationReference(String connectionName) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new UnitaryClause("transformationname", (Object)connectionName);
        String query = this.buildConjunctionClause(list, clauseDescriptionArray);
        IResultSet set = this.performQuery("SELECT " + "ownerid" + " FROM " + this.pipelineManager.getTableName() + " WHERE " + query, list, new StringSet(Jobs.getJobsKey()), null);
        return set.getRowCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJobDescription[] findJobsForConnection(String connectionName) throws ManifoldCFException {
        this.lockManager.enterReadLock(jobsLock);
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(Jobs.getJobsKey());
            StringSet cacheKeys = new StringSet(ssb);
            ArrayList list = new ArrayList();
            String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(connectionNameField, (Object)connectionName)});
            IResultSet set = this.performQuery("SELECT id,description FROM " + this.getTableName() + " WHERE " + query + " ORDER BY " + descriptionField + " ASC", list, cacheKeys, null);
            Long[] ids = new Long[set.getRowCount()];
            boolean[] readOnlies = new boolean[set.getRowCount()];
            for (int i = 0; i < ids.length; ++i) {
                IResultRow row = set.getRow(i);
                ids[i] = (Long)row.getValue(idField);
                readOnlies[i] = true;
            }
            IJobDescription[] iJobDescriptionArray = this.loadMultiple(ids, readOnlies);
            return iJobDescriptionArray;
        }
        finally {
            this.lockManager.leaveReadLock(jobsLock);
        }
    }

    public boolean deletingJobsPresent() throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(35))});
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + query + " " + this.constructOffsetLimitClause(0, 1), list, new StringSet(Jobs.getJobStatusKey()), null, 1);
        return set.getRowCount() > 0;
    }

    public boolean cleaningJobsPresent() throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)Jobs.statusToString(15))});
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + query + " " + this.constructOffsetLimitClause(0, 1), list, new StringSet(Jobs.getJobStatusKey()), null, 1);
        return set.getRowCount() > 0;
    }

    public boolean activeJobsPresent() throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{Jobs.statusToString(1), Jobs.statusToString(2)})});
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + query + " " + this.constructOffsetLimitClause(0, 1), list, new StringSet(Jobs.getJobStatusKey()), null, 1);
        return set.getRowCount() > 0;
    }

    public static int stringToStatus(String value) throws ManifoldCFException {
        Integer x = statusMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad status value: '" + value + "'");
        }
        return x;
    }

    public static String statusToString(int status) throws ManifoldCFException {
        switch (status) {
            case 0: {
                return "N";
            }
            case 1: {
                return "A";
            }
            case 11: {
                return "P";
            }
            case 15: {
                return "S";
            }
            case 34: {
                return "n";
            }
            case 33: {
                return "s";
            }
            case 39: {
                return "j";
            }
            case 38: {
                return "d";
            }
            case 5: {
                return "W";
            }
            case 13: {
                return "Z";
            }
            case 18: {
                return "X";
            }
            case 27: {
                return "Y";
            }
            case 28: {
                return "M";
            }
            case 19: {
                return "B";
            }
            case 20: {
                return "b";
            }
            case 31: {
                return "T";
            }
            case 32: {
                return "t";
            }
            case 23: {
                return "C";
            }
            case 24: {
                return "c";
            }
            case 25: {
                return "E";
            }
            case 36: {
                return "V";
            }
            case 35: {
                return "e";
            }
            case 2: {
                return "a";
            }
            case 12: {
                return "p";
            }
            case 6: {
                return "w";
            }
            case 14: {
                return "z";
            }
            case 29: {
                return "y";
            }
            case 30: {
                return "m";
            }
            case 40: {
                return "R";
            }
            case 41: {
                return "r";
            }
            case 42: {
                return "D";
            }
            case 3: {
                return "H";
            }
            case 4: {
                return "h";
            }
            case 7: {
                return "F";
            }
            case 8: {
                return "f";
            }
            case 9: {
                return "G";
            }
            case 10: {
                return "g";
            }
            case 16: {
                return "I";
            }
            case 17: {
                return "i";
            }
            case 37: {
                return "v";
            }
            case 100: {
                return "O";
            }
            case 101: {
                return "o";
            }
            case 102: {
                return "U";
            }
            case 103: {
                return "u";
            }
        }
        throw new ManifoldCFException("Bad status value: " + Integer.toString(status));
    }

    public static int stringToType(String value) throws ManifoldCFException {
        Integer x = typeMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad type value: '" + value + "'");
        }
        return x;
    }

    public static String typeToString(int type) throws ManifoldCFException {
        switch (type) {
            case 0: {
                return "C";
            }
            case 1: {
                return "S";
            }
        }
        throw new ManifoldCFException("Bad type: " + Integer.toString(type));
    }

    public static int stringToAssessmentState(String value) throws ManifoldCFException {
        if (value == null || value.length() == 0) {
            return 0;
        }
        Integer x = assessmentMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad assessment value: '" + value + "'");
        }
        return x;
    }

    public static String assessmentStateToString(int value) throws ManifoldCFException {
        switch (value) {
            case 0: {
                return "Y";
            }
            case 1: {
                return "N";
            }
        }
        throw new ManifoldCFException("Unknown assessment state value " + Integer.toString(value));
    }

    public static int stringToHopcountMode(String value) throws ManifoldCFException {
        if (value == null || value.length() == 0) {
            return 0;
        }
        Integer x = hopmodeMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad hopcount mode value: '" + value + "'");
        }
        return x;
    }

    public static String hopcountModeToString(int value) throws ManifoldCFException {
        switch (value) {
            case 0: {
                return "A";
            }
            case 1: {
                return "N";
            }
            case 2: {
                return "V";
            }
        }
        throw new ManifoldCFException("Unknown hopcount mode value " + Integer.toString(value));
    }

    public static int stringToStartMethod(String value) throws ManifoldCFException {
        Integer x = startMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad start method value: '" + value + "'");
        }
        return x;
    }

    public static String startMethodToString(int startMethod) throws ManifoldCFException {
        switch (startMethod) {
            case 0: {
                return "B";
            }
            case 1: {
                return "I";
            }
            case 2: {
                return "D";
            }
        }
        throw new ManifoldCFException("Bad start method: " + Integer.toString(startMethod));
    }

    public static EnumeratedValues stringToEnumeratedValue(String value) throws ManifoldCFException {
        if (value == null) {
            return null;
        }
        try {
            ArrayList<Integer> valStore = new ArrayList<Integer>();
            if (!value.equals("*")) {
                int curpos = 0;
                while (true) {
                    int newpos;
                    if ((newpos = value.indexOf(",", curpos)) == -1) {
                        valStore.add(new Integer(value.substring(curpos)));
                        break;
                    }
                    valStore.add(new Integer(value.substring(curpos, newpos)));
                    curpos = newpos + 1;
                }
            }
            return new EnumeratedValues(valStore);
        }
        catch (NumberFormatException e) {
            throw new ManifoldCFException("Bad number: '" + value + "'", (Throwable)e);
        }
    }

    public static String enumeratedValueToString(EnumeratedValues values) {
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return "*";
        }
        StringBuilder rval = new StringBuilder();
        Iterator iter = values.getValues();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                rval.append(',');
            }
            rval.append(((Integer)iter.next()).toString());
        }
        return rval.toString();
    }

    protected static String getJobsKey() {
        return CacheKeyFactory.makeJobsKey();
    }

    protected static String getJobIDKey(Long jobID) {
        return CacheKeyFactory.makeJobIDKey(jobID.toString());
    }

    protected static String getJobStatusKey() {
        return CacheKeyFactory.makeJobStatusKey();
    }

    protected JobDescription[] getJobsMultiple(Long[] ids) throws ManifoldCFException {
        HashSet<Long> uniqueIDs = new HashSet<Long>();
        for (Long id : ids) {
            uniqueIDs.add(id);
        }
        HashMap<Long, JobDescription> returnValues = new HashMap<Long, JobDescription>();
        this.beginTransaction();
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<Long> params = new ArrayList<Long>();
            int j = 0;
            int maxIn = this.getMaxInClause();
            for (Long uniqueID : uniqueIDs) {
                if (j == maxIn) {
                    this.getJobsChunk(returnValues, sb.toString(), params);
                    sb.setLength(0);
                    params.clear();
                    j = 0;
                }
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('?');
                params.add(uniqueID);
                ++j;
            }
            if (j > 0) {
                this.getJobsChunk(returnValues, sb.toString(), params);
            }
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
        JobDescription[] rval = new JobDescription[ids.length];
        for (int i = 0; i < rval.length; ++i) {
            Long id = ids[i];
            JobDescription jd = (JobDescription)returnValues.get(id);
            if (jd != null) {
                jd.makeReadOnly();
            }
            rval[i] = jd;
        }
        return rval;
    }

    protected void getJobsChunk(Map<Long, JobDescription> returnValues, String idList, ArrayList params) throws ManifoldCFException {
        try {
            IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + idField + " IN (" + idList + ")", params, null, null);
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i++);
                Long id = (Long)row.getValue(idField);
                JobDescription rc = new JobDescription();
                rc.setID(id);
                rc.setIsNew(false);
                rc.setDescription(row.getValue(descriptionField).toString());
                rc.setConnectionName(row.getValue(connectionNameField).toString());
                rc.setType(Jobs.stringToType(row.getValue(typeField).toString()));
                rc.setStartMethod(Jobs.stringToStartMethod(row.getValue(startMethodField).toString()));
                rc.setHopcountMode(Jobs.stringToHopcountMode((String)row.getValue(hopcountModeField)));
                rc.getSpecification().fromXML(row.getValue(documentSpecField).toString());
                rc.setInterval((Long)row.getValue(intervalField));
                rc.setMaxInterval((Long)row.getValue(maxIntervalField));
                rc.setReseedInterval((Long)row.getValue(reseedIntervalField));
                rc.setExpiration((Long)row.getValue(expirationField));
                rc.setPriority(Integer.parseInt(row.getValue(priorityField).toString()));
                returnValues.put(id, rc);
            }
            this.pipelineManager.getRows(returnValues, idList, params);
            this.notificationManager.getRows(returnValues, idList, params);
            this.scheduleManager.getRows(returnValues, idList, params);
            this.hopFilterManager.getRows(returnValues, idList, params);
            this.forcedParamManager.getRows(returnValues, idList, params);
        }
        catch (NumberFormatException e) {
            throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        statusMap.put("N", new Integer(0));
        statusMap.put("A", new Integer(1));
        statusMap.put("P", new Integer(11));
        statusMap.put("S", new Integer(15));
        statusMap.put("s", new Integer(33));
        statusMap.put("n", new Integer(34));
        statusMap.put("d", new Integer(38));
        statusMap.put("j", new Integer(39));
        statusMap.put("W", new Integer(5));
        statusMap.put("Z", new Integer(13));
        statusMap.put("X", new Integer(18));
        statusMap.put("B", new Integer(19));
        statusMap.put("b", new Integer(20));
        statusMap.put("C", new Integer(23));
        statusMap.put("c", new Integer(24));
        statusMap.put("E", new Integer(25));
        statusMap.put("V", new Integer(36));
        statusMap.put("e", new Integer(35));
        statusMap.put("Y", new Integer(27));
        statusMap.put("M", new Integer(28));
        statusMap.put("T", new Integer(31));
        statusMap.put("t", new Integer(32));
        statusMap.put("a", new Integer(2));
        statusMap.put("p", new Integer(12));
        statusMap.put("w", new Integer(6));
        statusMap.put("z", new Integer(14));
        statusMap.put("y", new Integer(29));
        statusMap.put("m", new Integer(30));
        statusMap.put("v", new Integer(37));
        statusMap.put("H", new Integer(3));
        statusMap.put("h", new Integer(4));
        statusMap.put("F", new Integer(7));
        statusMap.put("f", new Integer(8));
        statusMap.put("G", new Integer(9));
        statusMap.put("g", new Integer(10));
        statusMap.put("I", new Integer(16));
        statusMap.put("i", new Integer(17));
        statusMap.put("R", new Integer(40));
        statusMap.put("r", new Integer(41));
        statusMap.put("D", new Integer(42));
        statusMap.put("O", new Integer(100));
        statusMap.put("o", new Integer(101));
        statusMap.put("U", new Integer(102));
        statusMap.put("u", new Integer(103));
        typeMap = new HashMap<String, Integer>();
        typeMap.put("C", new Integer(0));
        typeMap.put("S", new Integer(1));
        startMap = new HashMap<String, Integer>();
        startMap.put("B", new Integer(0));
        startMap.put("I", new Integer(1));
        startMap.put("D", new Integer(2));
        hopmodeMap = new HashMap<String, Integer>();
        hopmodeMap.put("A", new Integer(0));
        hopmodeMap.put("N", new Integer(1));
        hopmodeMap.put("V", new Integer(2));
        assessmentMap = new HashMap<String, Integer>();
        assessmentMap.put("Y", new Integer(0));
        assessmentMap.put("N", new Integer(1));
    }

    protected static class JobObjectExecutor
    extends ExecutorBase {
        protected Jobs thisManager;
        protected JobDescription[] returnValues;
        protected HashMap returnMap = new HashMap();

        public JobObjectExecutor(Jobs manager, JobObjectDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new JobDescription[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getJobID(), new Integer(i));
            }
        }

        public JobDescription[] getResults(boolean[] readOnlies, int inputIndex) {
            JobDescription[] rval = new JobDescription[this.returnValues.length];
            for (int i = 0; i < rval.length; ++i) {
                JobDescription jd = this.returnValues[i];
                rval[i] = jd != null ? jd.duplicate(readOnlies[inputIndex + i]) : null;
            }
            return rval;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            Long[] ids = new Long[objectDescriptions.length];
            for (int i = 0; i < ids.length; ++i) {
                JobObjectDescription desc = (JobObjectDescription)objectDescriptions[i];
                ids[i] = desc.getJobID();
            }
            return this.thisManager.getJobsMultiple(ids);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            JobDescription ci;
            JobObjectDescription objectDesc = (JobObjectDescription)objectDescription;
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getJobID())).intValue()] = ci = (JobDescription)cachedObject;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class JobObjectDescription
    extends BaseDescription {
        protected Long jobID;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public JobObjectDescription(Long jobID, StringSet invKeys) {
            super("jobdescriptioncache");
            this.jobID = jobID;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + jobID.toString();
            this.cacheKeys = invKeys;
        }

        public Long getJobID() {
            return this.jobID;
        }

        public int hashCode() {
            return this.jobID.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof JobObjectDescription)) {
                return false;
            }
            JobObjectDescription d = (JobObjectDescription)((Object)o);
            return d.jobID.equals(this.jobID);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

