/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.notifications.email;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.notifications.BaseNotificationConnector;
import org.apache.manifoldcf.crawler.notifications.email.EmailSession;
import org.apache.manifoldcf.crawler.notifications.email.Messages;
import org.apache.manifoldcf.crawler.system.Logging;

public class EmailConnector
extends BaseNotificationConnector {
    protected static final long SESSION_EXPIRATION_MILLISECONDS = 300000L;
    protected long sessionExpiration = -1L;
    protected String server = null;
    protected String portString = null;
    protected String username = null;
    protected String password = null;
    protected String protocol = null;
    protected Properties properties = null;
    protected EmailSession session = null;
    private static Map<String, String> providerMap = new HashMap<String, String>();

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
        this.server = configParameters.getParameter("server");
        this.portString = configParameters.getParameter("port");
        this.protocol = configParameters.getParameter("protocol");
        this.username = configParameters.getParameter("username");
        this.password = configParameters.getObfuscatedParameter("password");
        this.properties = new Properties();
        int i = 0;
        while (i < configParameters.getChildCount()) {
            ConfigNode cn;
            if (!(cn = configParameters.getChild(i++)).getType().equals("properties")) continue;
            String findParameterName = cn.getAttributeValue("name");
            String findParameterValue = cn.getAttributeValue("value");
            this.properties.setProperty(findParameterName, findParameterValue);
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.server = null;
        this.portString = null;
        this.protocol = null;
        this.username = null;
        this.password = null;
        this.properties = null;
        this.finalizeConnection();
        super.disconnect();
    }

    public void poll() throws ManifoldCFException {
        if (this.session != null && System.currentTimeMillis() >= this.sessionExpiration) {
            this.finalizeConnection();
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        this.finalizeConnection();
        this.getSession();
        try {
            CheckConnectionThread cct = new CheckConnectionThread(this.session);
            cct.start();
            cct.finishUp();
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (MessagingException e) {
            EmailConnector.handleMessagingException(e, "checking the connection");
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            int port;
            if (this.server == null) {
                throw new ManifoldCFException("Missing server parameter");
            }
            if (this.properties == null) {
                throw new ManifoldCFException("Missing server properties");
            }
            if (this.protocol == null) {
                throw new ManifoldCFException("Missing protocol parameter");
            }
            if (this.portString != null && this.portString.length() > 0) {
                try {
                    port = Integer.parseInt(this.portString);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Port number has bad format: " + e.getMessage(), (Throwable)e);
                }
            } else {
                port = -1;
            }
            try {
                ConnectThread connectThread = new ConnectThread(this.server, port, this.username, this.password, providerMap.get(this.protocol), this.properties);
                connectThread.start();
                this.session = connectThread.finishUp();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), 2);
            }
            catch (MessagingException e) {
                EmailConnector.handleMessagingException(e, "connecting");
            }
        }
        this.sessionExpiration = System.currentTimeMillis() + 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeConnection() {
        if (this.session != null) {
            try {
                CloseSessionThread closeSessionThread = new CloseSessionThread(this.session);
                closeSessionThread.start();
                closeSessionThread.finishUp();
            }
            catch (InterruptedException e) {
            }
            catch (MessagingException e) {
                Logging.connectors.warn((Object)("Error while closing connection to server: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.session = null;
            }
        }
    }

    public void notifyOfJobStopErrorAbort(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendMail(spec, "erroraborted");
    }

    public void notifyOfJobStopManualAbort(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendMail(spec, "manualaborted");
    }

    public void notifyOfJobStopManualPause(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendMail(spec, "manualpaused");
    }

    public void notifyOfJobStopSchedulePause(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendMail(spec, "schedulepaused");
    }

    public void notifyOfJobStopRestart(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendMail(spec, "restarted");
    }

    public void notifyOfJobEnd(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendMail(spec, "finished");
    }

    protected void sendMail(Specification spec, String nodeType) throws ManifoldCFException, ServiceInterruption {
        int i;
        ArrayList<String> to = new ArrayList<String>();
        String from = null;
        String subject = "";
        String body = "";
        for (i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (sn.getType().equals("to")) {
                to.add(sn.getAttributeValue("value"));
                continue;
            }
            if (sn.getType().equals("from")) {
                from = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("subject")) {
                subject = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("body")) continue;
            body = sn.getAttributeValue("value");
        }
        if (nodeType != null) {
            for (i = 0; i < spec.getChildCount(); ++i) {
                SpecificationNode childNode = spec.getChild(i);
                if (!childNode.getType().equals(nodeType)) continue;
                int j = 0;
                while (j < childNode.getChildCount()) {
                    SpecificationNode sn = childNode.getChild(j);
                    if (sn.getType().equals("to")) {
                        to.add(sn.getAttributeValue("value"));
                    } else if (sn.getType().equals("from")) {
                        from = sn.getAttributeValue("value");
                    } else if (sn.getType().equals("subject")) {
                        subject = sn.getAttributeValue("value");
                    } else if (sn.getType().equals("body")) {
                        body = sn.getAttributeValue("value");
                    }
                    ++i;
                }
            }
        }
        if (to.size() == 0) {
            return;
        }
        this.getSession();
        SendThread st = new SendThread(this.session, to, from, subject, body);
        st.start();
        try {
            st.finishUp();
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (MessagingException e) {
            EmailConnector.handleMessagingException(e, "sending email");
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "EmailConnector.Server"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        EmailConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "ConfigurationHeader.js", paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        EmailConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "Configuration_Server.html", paramMap);
    }

    private static void fillInServerConfigurationMap(Map<String, Object> paramMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        int i = 0;
        String username = parameters.getParameter("username");
        String password = parameters.getObfuscatedParameter("password");
        String protocol = parameters.getParameter("protocol");
        String server = parameters.getParameter("server");
        String port = parameters.getParameter("port");
        ArrayList list = new ArrayList();
        while (i < parameters.getChildCount()) {
            ConfigNode cn;
            if (!(cn = parameters.getChild(i++)).getType().equals("properties")) continue;
            String findParameterName = cn.getAttributeValue("name");
            String findParameterValue = cn.getAttributeValue("value");
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("name", findParameterName);
            row.put("value", findParameterValue);
            list.add(row);
        }
        if (username == null) {
            username = "";
        }
        password = password == null ? "" : mapper.mapPasswordToKey(password);
        if (protocol == null) {
            protocol = "IMAP";
        }
        if (server == null) {
            server = "";
        }
        if (port == null) {
            port = "";
        }
        paramMap.put("USERNAME", username);
        paramMap.put("PASSWORD", password);
        paramMap.put("PROTOCOL", protocol);
        paramMap.put("SERVER", server);
        paramMap.put("PORT", port);
        paramMap.put("PROPERTIES", list);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String operation;
        String port;
        String server;
        String protocol;
        String password;
        String userName = variableContext.getParameter("username");
        if (userName != null) {
            parameters.setParameter("username", userName);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((protocol = variableContext.getParameter("protocol")) != null) {
            parameters.setParameter("protocol", protocol);
        }
        if ((server = variableContext.getParameter("server")) != null) {
            parameters.setParameter("server", server);
        }
        if ((port = variableContext.getParameter("port")) != null) {
            parameters.setParameter("port", port);
        }
        EmailConnector.removeNodes(parameters, "properties");
        String findCountString = variableContext.getParameter("findcount");
        if (findCountString != null) {
            int findCount = Integer.parseInt(findCountString);
            int i = 0;
            while (i < findCount) {
                String suffix = "_" + Integer.toString(i++);
                String findParameterOp = variableContext.getParameter("findop" + suffix);
                if (findParameterOp != null && findParameterOp.equals("Delete")) continue;
                String findParameterName = variableContext.getParameter("findname" + suffix);
                String findParameterValue = variableContext.getParameter("findvalue" + suffix);
                EmailConnector.addFindParameterNode(parameters, findParameterName, findParameterValue);
            }
        }
        if ((operation = variableContext.getParameter("findop")) != null && operation.equals("Add")) {
            String findParameterName = variableContext.getParameter("findname");
            String findParameterValue = variableContext.getParameter("findvalue");
            EmailConnector.addFindParameterNode(parameters, findParameterName, findParameterValue);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        EmailConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "ConfigurationView.html", paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "EmailConnector.Message"));
        Messages.outputResourceWithVelocity(out, locale, "SpecificationHeader.js", paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        this.outputMessageTab(out, locale, ds, tabName, connectionSequenceNumber, actualSequenceNumber);
    }

    protected void outputMessageTab(IHTTPOutput out, Locale locale, Specification ds, String tabName, int connectionSequenceNumber, int actualSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        EmailConnector.fillInMessageTab(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "Specification_Message.html", paramMap);
    }

    protected static void fillInMessageTab(Map<String, Object> paramMap, Specification ds) {
        int i;
        String toValue = "";
        String fromValue = "";
        String subjectValue = "";
        String bodyValue = "";
        for (i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals("to")) {
                toValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("from")) {
                fromValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("subject")) {
                subjectValue = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("body")) continue;
            bodyValue = sn.getAttributeValue("value");
        }
        if (toValue.length() > 0) {
            EmailConnector.addRecord(paramMap, "finished", toValue, fromValue, subjectValue, bodyValue);
            EmailConnector.addRecord(paramMap, "erroraborted", toValue, fromValue, subjectValue, bodyValue);
            EmailConnector.addRecord(paramMap, "manualaborted", toValue, fromValue, subjectValue, bodyValue);
            EmailConnector.addRecord(paramMap, "manualpaused", toValue, fromValue, subjectValue, bodyValue);
            EmailConnector.addRecord(paramMap, "schedulepaused", toValue, fromValue, subjectValue, bodyValue);
            EmailConnector.addRecord(paramMap, "restarted", toValue, fromValue, subjectValue, bodyValue);
        } else {
            EmailConnector.addRecord(paramMap, "finished", "", "", "", "");
            EmailConnector.addRecord(paramMap, "erroraborted", "", "", "", "");
            EmailConnector.addRecord(paramMap, "manualaborted", "", "", "", "");
            EmailConnector.addRecord(paramMap, "manualpaused", "", "", "", "");
            EmailConnector.addRecord(paramMap, "schedulepaused", "", "", "", "");
            EmailConnector.addRecord(paramMap, "restarted", "", "", "", "");
            for (i = 0; i < ds.getChildCount(); ++i) {
                SpecificationNode childNode = ds.getChild(i);
                if (!childNode.getType().equals("finished") && !childNode.getType().equals("erroraborted") && !childNode.getType().equals("manualaborted") && !childNode.getType().equals("manualpaused") && !childNode.getType().equals("schedulepaused") && !childNode.getType().equals("restarted")) continue;
                toValue = "";
                fromValue = "";
                subjectValue = "";
                bodyValue = "";
                for (int j = 0; j < childNode.getChildCount(); ++j) {
                    SpecificationNode sn = childNode.getChild(j);
                    if (sn.getType().equals("to")) {
                        toValue = sn.getAttributeValue("value");
                        continue;
                    }
                    if (sn.getType().equals("from")) {
                        fromValue = sn.getAttributeValue("value");
                        continue;
                    }
                    if (sn.getType().equals("subject")) {
                        subjectValue = sn.getAttributeValue("value");
                        continue;
                    }
                    if (!sn.getType().equals("body")) continue;
                    bodyValue = sn.getAttributeValue("value");
                }
                EmailConnector.addRecord(paramMap, childNode.getType(), toValue, fromValue, subjectValue, bodyValue);
            }
        }
    }

    protected static void addRecord(Map<String, Object> paramMap, String nodeType, String toValue, String fromValue, String subjectValue, String bodyValue) {
        paramMap.put(nodeType + "_TO", toValue);
        paramMap.put(nodeType + "_FROM", fromValue);
        paramMap.put(nodeType + "_SUBJECT", subjectValue);
        paramMap.put(nodeType + "_BODY", bodyValue);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        return this.processMessageTab(variableContext, ds, connectionSequenceNumber);
    }

    protected String processMessageTab(IPostParameters variableContext, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        EmailConnector.removeNodes(ds, "to");
        EmailConnector.removeNodes(ds, "from");
        EmailConnector.removeNodes(ds, "subject");
        EmailConnector.removeNodes(ds, "body");
        EmailConnector.gatherRecord(ds, seqPrefix, variableContext, "finished");
        EmailConnector.gatherRecord(ds, seqPrefix, variableContext, "erroraborted");
        EmailConnector.gatherRecord(ds, seqPrefix, variableContext, "manualaborted");
        EmailConnector.gatherRecord(ds, seqPrefix, variableContext, "manualpaused");
        EmailConnector.gatherRecord(ds, seqPrefix, variableContext, "schedulepaused");
        EmailConnector.gatherRecord(ds, seqPrefix, variableContext, "restarted");
        return null;
    }

    protected static void gatherRecord(Specification ds, String seqPrefix, IPostParameters variableContext, String nodeType) {
        String bodyString;
        String subjectString;
        String fromString;
        EmailConnector.removeNodes(ds, nodeType);
        SpecificationNode sn = new SpecificationNode(nodeType);
        String toString = variableContext.getParameter(seqPrefix + nodeType + "_to");
        if (toString != null) {
            EmailConnector.addNodeValue(sn, "to", toString);
        }
        if ((fromString = variableContext.getParameter(seqPrefix + nodeType + "_from")) != null) {
            EmailConnector.addNodeValue(sn, "from", fromString);
        }
        if ((subjectString = variableContext.getParameter(seqPrefix + nodeType + "_subject")) != null) {
            EmailConnector.addNodeValue(sn, "subject", subjectString);
        }
        if ((bodyString = variableContext.getParameter(seqPrefix + nodeType + "_body")) != null) {
            EmailConnector.addNodeValue(sn, "body", bodyString);
        }
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        EmailConnector.fillInMessageTab(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "SpecificationView.html", paramMap);
    }

    protected static void addFindParameterNode(ConfigParams parameters, String findParameterName, String findParameterValue) {
        ConfigNode cn = new ConfigNode("properties");
        cn.setAttribute("name", findParameterName);
        cn.setAttribute("value", findParameterValue);
        parameters.addChild(parameters.getChildCount(), (ConfigurationNode)cn);
    }

    protected static void removeNodes(ConfigParams parameters, String nodeTypeName) {
        int i = 0;
        while (i < parameters.getChildCount()) {
            ConfigNode cn = parameters.getChild(i);
            if (cn.getType().equals(nodeTypeName)) {
                parameters.removeChild(i);
                continue;
            }
            ++i;
        }
    }

    protected static void removeNodes(Specification ds, String nodeTypeName) {
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals(nodeTypeName)) {
                ds.removeChild(i);
                continue;
            }
            ++i;
        }
    }

    protected static void addNodeValue(SpecificationNode ds, String nodeType, String value) {
        SpecificationNode sn = new SpecificationNode(nodeType);
        sn.setAttribute("value", value);
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
    }

    protected static void handleMessagingException(MessagingException e, String context) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.error((Object)("Email: Error " + context + ": " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("Error " + context + ": " + e.getMessage(), (Throwable)e);
    }

    static {
        providerMap.put("POP3", "pop3");
        providerMap.put("POP3-SSL", "pop3s");
        providerMap.put("IMAP", "imap");
        providerMap.put("IMAP-SSL", "imaps");
    }

    protected static class SendThread
    extends Thread {
        protected final EmailSession session;
        protected final List<String> to;
        protected final String from;
        protected final String subject;
        protected final String body;
        protected Throwable exception = null;

        public SendThread(EmailSession session, List<String> to, String from, String subject, String body) {
            this.session = session;
            this.to = to;
            this.from = from;
            this.subject = subject;
            this.body = body;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.send(this.to, this.from, this.subject, this.body);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class CheckConnectionThread
    extends Thread {
        protected final EmailSession session;
        protected Throwable exception = null;

        public CheckConnectionThread(EmailSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.checkConnection();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class CloseSessionThread
    extends Thread {
        protected final EmailSession session;
        protected Throwable exception = null;

        public CloseSessionThread(EmailSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.close();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class ConnectThread
    extends Thread {
        protected final String server;
        protected final int port;
        protected final String username;
        protected final String password;
        protected final String protocol;
        protected final Properties properties;
        protected EmailSession session = null;
        protected Throwable exception = null;

        public ConnectThread(String server, int port, String username, String password, String protocol, Properties properties) {
            this.server = server;
            this.port = port;
            this.username = username;
            this.password = password;
            this.protocol = protocol;
            this.properties = properties;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session = new EmailSession(this.server, this.port, this.username, this.password, this.protocol, this.properties);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public EmailSession finishUp() throws MessagingException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof MessagingException) {
                        throw (MessagingException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
                return this.session;
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }
}

