/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.database.RRow;
import org.apache.manifoldcf.core.database.RSet;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.PersistentDatabaseObject;
import org.apache.manifoldcf.core.interfaces.TempFileCharacterInput;
import org.apache.manifoldcf.core.interfaces.TempFileInput;
import org.apache.manifoldcf.core.interfaces.TimeMarker;
import org.apache.manifoldcf.core.jdbcpool.WrappedConnection;
import org.apache.manifoldcf.jdbc.IDynamicResultRow;
import org.apache.manifoldcf.jdbc.IDynamicResultSet;
import org.apache.manifoldcf.jdbc.JDBCConnectionFactory;

public class JDBCConnection {
    public static final String _rcsid = "@(#)$Id: JDBCConnection.java 988245 2010-08-23 18:39:35Z kwright $";
    protected String jdbcProvider = null;
    protected boolean useName;
    protected String driverString = null;
    protected String userName = null;
    protected String password = null;

    public JDBCConnection(String jdbcProvider, boolean useName, String host, String databaseName, String rawDriverString, String userName, String password) throws ManifoldCFException {
        this.jdbcProvider = jdbcProvider;
        this.useName = useName;
        this.driverString = JDBCConnectionFactory.getJDBCDriverString(jdbcProvider, host, databaseName, rawDriverString);
        this.userName = userName;
        this.password = password;
    }

    protected static IDynamicResultRow readNextResultRowViaThread(ResultSet rs, ResultSetMetaData rsmd, String[] resultCols) throws ManifoldCFException, ServiceInterruption {
        NextResultRowThread t = new NextResultRowThread(rs, rsmd, resultCols);
        try {
            t.start();
            return t.finishUp();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    protected static IDynamicResultRow readNextResultRow(ResultSet rs, ResultSetMetaData rsmd, String[] resultCols) throws ManifoldCFException, ServiceInterruption {
        try {
            if (rs.next()) {
                return JDBCConnection.readResultRow(rs, rsmd, resultCols);
            }
            return null;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Result set error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void closeResultset(ResultSet rs) throws ManifoldCFException, ServiceInterruption {
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception closing resultset: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void closeStmt(Statement stmt) throws ManifoldCFException, ServiceInterruption {
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception closing statement: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void closePS(PreparedStatement ps) throws ManifoldCFException, ServiceInterruption {
        try {
            ps.close();
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception closing statement: " + e.getMessage(), (Throwable)e);
        }
    }

    public void testConnection() throws ManifoldCFException, ServiceInterruption {
        TestConnectionThread t = new TestConnectionThread();
        try {
            t.start();
            t.finishUp();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    public IDynamicResultSet executeUncachedQuery(String query, ArrayList params, int maxResults) throws ManifoldCFException, ServiceInterruption {
        if (params == null) {
            return new JDBCResultSet(query, maxResults);
        }
        return new JDBCPSResultSet(query, params, maxResults);
    }

    public void executeOperation(String query, ArrayList params) throws ManifoldCFException, ServiceInterruption {
        ExecuteOperationThread t = new ExecuteOperationThread(query, params);
        try {
            t.start();
            t.finishUp();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(Object o) throws ManifoldCFException {
        if (o instanceof BinaryInput) {
            BinaryInput bi = (BinaryInput)o;
            try {
                String string;
                InputStream is = bi.getStream();
                try {
                    int x;
                    InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                    StringBuilder sb = new StringBuilder();
                    while ((x = reader.read()) != -1) {
                        sb.append((char)x);
                    }
                    string = sb.toString();
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                    }
                }
                is.close();
                return string;
            }
            finally {
                bi.doneWithStream();
            }
        }
        if (o instanceof CharacterInput) {
            CharacterInput ci = (CharacterInput)o;
            try {
                String string;
                Reader reader = ci.getStream();
                try {
                    int x;
                    StringBuilder sb = new StringBuilder();
                    while ((x = reader.read()) != -1) {
                        sb.append((char)x);
                    }
                    string = sb.toString();
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                    }
                }
                reader.close();
                return string;
            }
            finally {
                ci.doneWithStream();
            }
        }
        return o.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected static IResultSet execute(Connection connection, String query, ArrayList params, boolean bResults, int maxResults, boolean useName) throws ManifoldCFException, ServiceInterruption {
        try {
            if (params == null) {
                try (Statement stmt = connection.createStatement();){
                    IResultSet iResultSet;
                    block24: {
                        ResultSet rs;
                        block22: {
                            IResultSet iResultSet2;
                            block23: {
                                stmt.execute(query);
                                rs = stmt.getResultSet();
                                try {
                                    if (!bResults) break block22;
                                    iResultSet2 = JDBCConnection.getData(rs, maxResults, useName);
                                    if (rs == null) break block23;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return iResultSet2;
                        }
                        iResultSet = null;
                        if (rs == null) break block24;
                        rs.close();
                    }
                    return iResultSet;
                }
            }
            PreparedStatement ps = connection.prepareStatement(query);
            JDBCConnection.loadPS(ps, params);
            if (bResults) {
                try (ResultSet rs = ps.executeQuery();){
                    IResultSet iResultSet = JDBCConnection.getData(rs, maxResults, useName);
                    return iResultSet;
                }
            }
            ps.executeUpdate();
            IResultSet iResultSet = null;
            return iResultSet;
            finally {
                ps.close();
                JDBCConnection.cleanupParameters(params);
            }
        }
        catch (ManifoldCFException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception doing connector query '" + query + "': " + e.getMessage(), (Throwable)e);
        }
    }

    protected static IDynamicResultRow readResultRow(ResultSet rs, ResultSetMetaData rsmd, String[] resultCols) throws ManifoldCFException, ServiceInterruption {
        try {
            Object value = null;
            RDynamicRow m = new RDynamicRow();
            for (int i = 0; i < resultCols.length; ++i) {
                String key = resultCols[i];
                int colnum = JDBCConnection.findColumn(rs, key);
                if (colnum > -1) {
                    if (JDBCConnection.isBinaryData(rsmd, colnum)) {
                        InputStream bis = rs.getBinaryStream(colnum);
                        if (bis != null) {
                            try {
                                value = new TempFileInput(bis);
                            }
                            catch (IOException e) {
                                JDBCConnection.handleIOException(e, "reading binary data");
                            }
                        }
                    } else if (JDBCConnection.isBLOB(rsmd, colnum)) {
                        Blob blob = JDBCConnection.getBLOB(rs, colnum);
                        if (blob != null) {
                            try {
                                value = new TempFileInput(blob.getBinaryStream(), blob.length());
                            }
                            catch (IOException e) {
                                JDBCConnection.handleIOException(e, "reading blob");
                            }
                        }
                    } else if (JDBCConnection.isCLOB(rsmd, colnum)) {
                        Clob clob = JDBCConnection.getCLOB(rs, colnum);
                        if (clob != null) {
                            try {
                                value = new TempFileCharacterInput(clob.getCharacterStream(), clob.length());
                            }
                            catch (IOException e) {
                                JDBCConnection.handleIOException(e, "reading clob");
                            }
                        }
                    } else {
                        value = JDBCConnection.getObject(rs, rsmd, colnum);
                    }
                }
                if (value == null) continue;
                m.put(key, value);
            }
            return m;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Resultset error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException {
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException("IO exception while " + context + ": " + e.getMessage(), (Throwable)e);
    }

    protected static String[] readColumnNames(ResultSetMetaData rsmd, boolean useName) throws ManifoldCFException, ServiceInterruption {
        try {
            String[] resultCols;
            if (rsmd != null) {
                int colcount = rsmd.getColumnCount();
                resultCols = new String[colcount];
                for (int i = 0; i < colcount; ++i) {
                    String name = useName ? rsmd.getColumnName(i + 1) : rsmd.getColumnLabel(i + 1);
                    resultCols[i] = name;
                }
            } else {
                resultCols = new String[]{};
            }
            return resultCols;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Sql exception reading column names: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static IResultSet getData(ResultSet rs, int maxResults, boolean useName) throws ManifoldCFException, ServiceInterruption {
        try {
            RSet results = new RSet();
            if (rs != null) {
                ResultSetMetaData rsmd = rs.getMetaData();
                String[] resultCols = JDBCConnection.readColumnNames(rsmd, useName);
                if (resultCols.length == 0) {
                    throw new ManifoldCFException("Empty query, no columns returned", 0);
                }
                while (rs.next() && (maxResults == -1 || maxResults > 0)) {
                    IDynamicResultRow m = JDBCConnection.readResultRow(rs, rsmd, resultCols);
                    if (maxResults != -1) {
                        --maxResults;
                    }
                    results.addRow((IResultRow)m);
                }
            }
            return results;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Resultset error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void loadPS(PreparedStatement ps, ArrayList data) throws SQLException, ManifoldCFException {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                String value;
                Object x = data.get(i);
                if (x instanceof String) {
                    value = (String)x;
                    ps.setString(i + 1, value);
                    continue;
                }
                if (x instanceof BinaryInput) {
                    value = (BinaryInput)x;
                    ps.setBinaryStream(i + 1, value.getStream(), value.getLength());
                    continue;
                }
                if (x instanceof CharacterInput) {
                    value = (CharacterInput)x;
                    ps.setCharacterStream(i + 1, value.getStream(), value.getCharacterLength());
                    continue;
                }
                if (x instanceof java.util.Date) {
                    ps.setDate(i + 1, new Date(((java.util.Date)x).getTime()));
                    continue;
                }
                if (x instanceof Long) {
                    ps.setLong(i + 1, (Long)x);
                    continue;
                }
                if (x instanceof TimeMarker) {
                    ps.setTimestamp(i + 1, new Timestamp((Long)x));
                    continue;
                }
                if (x instanceof Double) {
                    ps.setDouble(i + 1, (Double)x);
                    continue;
                }
                if (x instanceof Integer) {
                    ps.setInt(i + 1, (Integer)x);
                    continue;
                }
                if (x instanceof Float) {
                    ps.setFloat(i + 1, ((Float)x).floatValue());
                    continue;
                }
                throw new ManifoldCFException("Unknown data type: " + x.getClass().getName());
            }
        }
    }

    protected static void discardDatabaseObject(Object x) throws ManifoldCFException {
        if (x instanceof PersistentDatabaseObject) {
            PersistentDatabaseObject value = (PersistentDatabaseObject)x;
            value.discard();
        }
    }

    protected static void cleanupDatabaseObject(Object x) throws ManifoldCFException {
        if (x instanceof PersistentDatabaseObject) {
            PersistentDatabaseObject value = (PersistentDatabaseObject)x;
            value.doneWithStream();
        }
    }

    protected static void cleanupParameters(ArrayList data) throws ManifoldCFException {
        if (data != null) {
            for (Object x : data) {
                JDBCConnection.cleanupDatabaseObject(x);
            }
        }
    }

    protected static int findColumn(ResultSet rs, String name) throws ManifoldCFException, ServiceInterruption {
        try {
            return rs.findColumn(name);
        }
        catch (SQLException e) {
            return -1;
        }
    }

    protected static Blob getBLOB(ResultSet rs, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            return rs.getBlob(col);
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in getBlob(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static Clob getCLOB(ResultSet rs, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            return rs.getClob(col);
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in getClob(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static boolean isBLOB(ResultSetMetaData rsmd, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            int type = rsmd.getColumnType(col);
            return type == 2004;
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in isBlob(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static boolean isBinaryData(ResultSetMetaData rsmd, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            int type = rsmd.getColumnType(col);
            return type == -3 || type == -2 || type == -4;
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in isBinaryData(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static boolean isCLOB(ResultSetMetaData rsmd, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            int type = rsmd.getColumnType(col);
            return type == 2005 || type == -1;
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in isClob(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static Object getObject(ResultSet rs, ResultSetMetaData rsmd, int col) throws ManifoldCFException, ServiceInterruption {
        Object result = null;
        try {
            switch (rsmd.getColumnType(col)) {
                case 1: {
                    String resultString = rs.getString(col);
                    if (resultString == null) break;
                    if (rsmd.getColumnDisplaySize(col) < resultString.length()) {
                        result = resultString.substring(0, rsmd.getColumnDisplaySize(col));
                        break;
                    }
                    result = resultString;
                    break;
                }
                case 2005: {
                    Clob clob = rs.getClob(col);
                    if (clob == null) break;
                    result = clob.getSubString(1L, (int)clob.length());
                    break;
                }
                case -5: {
                    long l = rs.getLong(col);
                    if (rs.wasNull()) break;
                    result = new Long(l);
                    break;
                }
                case 4: {
                    int i = rs.getInt(col);
                    if (rs.wasNull()) break;
                    result = new Integer(i);
                    break;
                }
                case 6: 
                case 7: {
                    float f = rs.getFloat(col);
                    if (rs.wasNull()) break;
                    result = new Float(f);
                    break;
                }
                case 8: {
                    double d = rs.getDouble(col);
                    if (rs.wasNull()) break;
                    result = new Double(d);
                    break;
                }
                case 91: {
                    Date date = rs.getDate(col);
                    if (date == null) break;
                    result = new java.util.Date(date.getTime());
                    break;
                }
                case 93: {
                    Timestamp timestamp = rs.getTimestamp(col);
                    if (timestamp == null) break;
                    result = new TimeMarker(timestamp.getTime());
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    throw new ManifoldCFException("Binary type is not a string, column = " + col, 0);
                }
                default: {
                    result = rs.getString(col);
                }
            }
            if (rs.wasNull()) {
                result = null;
            }
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception in getString(): " + e.getMessage(), (Throwable)e, 1);
        }
        return result;
    }

    protected static class RDynamicRow
    extends RRow
    implements IDynamicResultRow {
        @Override
        public void close() throws ManifoldCFException {
            Iterator columns = this.getColumns();
            while (columns.hasNext()) {
                String column = (String)columns.next();
                Object o = this.getValue(column);
                JDBCConnection.discardDatabaseObject(o);
            }
        }
    }

    protected class PreparedStatementQueryThread
    extends Thread {
        protected ArrayList params;
        protected String query;
        protected WrappedConnection connection = null;
        protected Throwable exception = null;
        protected PreparedStatement ps = null;
        protected ResultSet rs = null;
        protected ResultSetMetaData rsmd = null;
        protected String[] resultCols = null;

        public PreparedStatementQueryThread(String query, ArrayList params) {
            this.setDaemon(true);
            this.query = query;
            this.params = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block22: {
                try {
                    this.connection = JDBCConnectionFactory.getConnection(JDBCConnection.this.jdbcProvider, JDBCConnection.this.driverString, JDBCConnection.this.userName, JDBCConnection.this.password);
                    this.ps = this.connection.getConnection().prepareStatement(this.query);
                    JDBCConnection.loadPS(this.ps, this.params);
                    this.rs = this.ps.executeQuery();
                    this.rsmd = this.rs.getMetaData();
                    this.resultCols = JDBCConnection.readColumnNames(this.rsmd, JDBCConnection.this.useName);
                }
                catch (Throwable e) {
                    this.exception = e;
                    if (this.rs != null) {
                        try {
                            JDBCConnection.closeResultset(this.rs);
                        }
                        catch (ManifoldCFException e2) {
                            if (e2.getErrorCode() == 2) {
                                this.exception = e2;
                            }
                        }
                        catch (Throwable e2) {
                        }
                        finally {
                            this.rs = null;
                        }
                    }
                    if (this.ps != null) {
                        try {
                            JDBCConnection.closePS(this.ps);
                        }
                        catch (ManifoldCFException e2) {
                            if (e2.getErrorCode() == 2) {
                                this.exception = e2;
                            }
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            this.ps = null;
                        }
                    }
                    if (this.connection == null) break block22;
                    JDBCConnectionFactory.releaseConnection(this.connection);
                    this.connection = null;
                }
            }
        }

        public void finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                JDBCConnection.cleanupParameters(this.params);
                if (thr instanceof SQLException) {
                    throw new ManifoldCFException("Exception doing connector query '" + this.query + "': " + thr.getMessage(), thr);
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }

        public WrappedConnection getConnection() {
            return this.connection;
        }

        public PreparedStatement getPreparedStatement() {
            return this.ps;
        }

        public ResultSet getResultSet() {
            return this.rs;
        }

        public ResultSetMetaData getResultSetMetaData() {
            return this.rsmd;
        }

        public String[] getColumnNames() {
            return this.resultCols;
        }
    }

    protected class JDBCPSResultSet
    implements IDynamicResultSet {
        protected WrappedConnection connection;
        protected PreparedStatement ps;
        protected ResultSet rs;
        protected ResultSetMetaData rsmd;
        protected String[] resultCols;
        protected int maxResults;
        protected ArrayList params;

        public JDBCPSResultSet(String query, ArrayList params, int maxResults) throws ManifoldCFException, ServiceInterruption {
            this.maxResults = maxResults;
            this.params = params;
            PreparedStatementQueryThread t = new PreparedStatementQueryThread(query, params);
            try {
                t.start();
                t.finishUp();
                this.connection = t.getConnection();
                this.ps = t.getPreparedStatement();
                this.rs = t.getResultSet();
                this.rsmd = t.getResultSetMetaData();
                this.resultCols = t.getColumnNames();
            }
            catch (InterruptedException e) {
                JDBCConnection.cleanupParameters(params);
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
        }

        @Override
        public IDynamicResultRow getNextRow() throws ManifoldCFException, ServiceInterruption {
            if (this.maxResults == -1 || this.maxResults > 0) {
                IDynamicResultRow row = JDBCConnection.readNextResultRowViaThread(this.rs, this.rsmd, this.resultCols);
                if (row != null && this.maxResults != -1) {
                    --this.maxResults;
                }
                return row;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws ManifoldCFException, ServiceInterruption {
            ManifoldCFException rval = null;
            Error error = null;
            RuntimeException rtException = null;
            if (this.rs != null) {
                try {
                    JDBCConnection.closeResultset(this.rs);
                }
                catch (ServiceInterruption e) {
                }
                catch (ManifoldCFException e) {
                    if (rval == null || e.getErrorCode() == 2) {
                        rval = e;
                    }
                }
                catch (Error e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    rtException = e;
                }
                finally {
                    this.rs = null;
                }
            }
            if (this.ps != null) {
                try {
                    JDBCConnection.closePS(this.ps);
                }
                catch (ServiceInterruption e) {
                }
                catch (ManifoldCFException e) {
                    if (rval == null || e.getErrorCode() == 2) {
                        rval = e;
                    }
                }
                catch (Error e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    rtException = e;
                }
                finally {
                    this.ps = null;
                }
            }
            if (this.connection != null) {
                try {
                    JDBCConnectionFactory.releaseConnection(this.connection);
                }
                catch (Error e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    rtException = e;
                }
                finally {
                    this.connection = null;
                }
            }
            if (this.params != null) {
                try {
                    JDBCConnection.cleanupParameters(this.params);
                }
                catch (ManifoldCFException e) {
                    if (rval == null || e.getErrorCode() == 2) {
                        rval = e;
                    }
                }
                catch (Error e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    rtException = e;
                }
                finally {
                    this.params = null;
                }
            }
            if (error != null) {
                throw error;
            }
            if (rtException != null) {
                throw rtException;
            }
            if (rval != null) {
                throw rval;
            }
        }
    }

    protected class StatementQueryThread
    extends Thread {
        protected String query;
        protected Throwable exception = null;
        protected WrappedConnection connection = null;
        protected Statement stmt = null;
        protected ResultSet rs = null;
        protected ResultSetMetaData rsmd = null;
        protected String[] resultCols = null;

        public StatementQueryThread(String query) {
            this.setDaemon(true);
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block22: {
                try {
                    this.connection = JDBCConnectionFactory.getConnection(JDBCConnection.this.jdbcProvider, JDBCConnection.this.driverString, JDBCConnection.this.userName, JDBCConnection.this.password);
                    this.stmt = this.connection.getConnection().createStatement();
                    this.stmt.execute(this.query);
                    this.rs = this.stmt.getResultSet();
                    this.rsmd = this.rs.getMetaData();
                    this.resultCols = JDBCConnection.readColumnNames(this.rsmd, JDBCConnection.this.useName);
                }
                catch (Throwable e) {
                    this.exception = e;
                    if (this.rs != null) {
                        try {
                            JDBCConnection.closeResultset(this.rs);
                        }
                        catch (ManifoldCFException e2) {
                            if (e2.getErrorCode() == 2) {
                                this.exception = e2;
                            }
                        }
                        catch (Throwable e2) {
                        }
                        finally {
                            this.rs = null;
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            JDBCConnection.closeStmt(this.stmt);
                        }
                        catch (ManifoldCFException e2) {
                            if (e2.getErrorCode() == 2) {
                                this.exception = e2;
                            }
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            this.stmt = null;
                        }
                    }
                    if (this.connection == null) break block22;
                    JDBCConnectionFactory.releaseConnection(this.connection);
                    this.connection = null;
                }
            }
        }

        public void finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof SQLException) {
                    throw new ManifoldCFException("Exception doing connector query '" + this.query + "': " + thr.getMessage(), thr);
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }

        public WrappedConnection getConnection() {
            return this.connection;
        }

        public Statement getStatement() {
            return this.stmt;
        }

        public ResultSet getResultSet() {
            return this.rs;
        }

        public ResultSetMetaData getResultSetMetaData() {
            return this.rsmd;
        }

        public String[] getColumnNames() {
            return this.resultCols;
        }
    }

    protected class JDBCResultSet
    implements IDynamicResultSet {
        protected WrappedConnection connection;
        protected Statement stmt;
        protected ResultSet rs;
        protected ResultSetMetaData rsmd;
        protected String[] resultCols;
        protected int maxResults;

        public JDBCResultSet(String query, int maxResults) throws ManifoldCFException, ServiceInterruption {
            this.maxResults = maxResults;
            StatementQueryThread t = new StatementQueryThread(query);
            try {
                t.start();
                t.finishUp();
                this.connection = t.getConnection();
                this.stmt = t.getStatement();
                this.rs = t.getResultSet();
                this.rsmd = t.getResultSetMetaData();
                this.resultCols = t.getColumnNames();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
        }

        @Override
        public IDynamicResultRow getNextRow() throws ManifoldCFException, ServiceInterruption {
            if (this.maxResults == -1 || this.maxResults > 0) {
                IDynamicResultRow row = JDBCConnection.readNextResultRowViaThread(this.rs, this.rsmd, this.resultCols);
                if (row != null && this.maxResults != -1) {
                    --this.maxResults;
                }
                return row;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws ManifoldCFException, ServiceInterruption {
            ManifoldCFException rval = null;
            Error error = null;
            RuntimeException rtException = null;
            if (this.rs != null) {
                try {
                    JDBCConnection.closeResultset(this.rs);
                }
                catch (ManifoldCFException e) {
                    if (rval == null || e.getErrorCode() == 2) {
                        rval = e;
                    }
                }
                catch (Error e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    rtException = e;
                }
                finally {
                    this.rs = null;
                }
            }
            if (this.stmt != null) {
                try {
                    JDBCConnection.closeStmt(this.stmt);
                }
                catch (ManifoldCFException e) {
                    if (rval == null || e.getErrorCode() == 2) {
                        rval = e;
                    }
                }
                catch (Error e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    rtException = e;
                }
                finally {
                    this.stmt = null;
                }
            }
            if (this.connection != null) {
                try {
                    JDBCConnectionFactory.releaseConnection(this.connection);
                }
                catch (Error e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    rtException = e;
                }
                finally {
                    this.connection = null;
                }
            }
            if (error != null) {
                throw error;
            }
            if (rtException != null) {
                throw rtException;
            }
            if (rval != null) {
                throw rval;
            }
        }
    }

    protected class ExecuteOperationThread
    extends Thread {
        protected String query;
        protected ArrayList params;
        protected Throwable exception = null;

        public ExecuteOperationThread(String query, ArrayList params) {
            this.setDaemon(true);
            this.query = query;
            this.params = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WrappedConnection tempConnection = JDBCConnectionFactory.getConnection(JDBCConnection.this.jdbcProvider, JDBCConnection.this.driverString, JDBCConnection.this.userName, JDBCConnection.this.password);
                try {
                    JDBCConnection.execute(tempConnection.getConnection(), this.query, this.params, false, 0, JDBCConnection.this.useName);
                }
                finally {
                    JDBCConnectionFactory.releaseConnection(tempConnection);
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof SQLException) {
                    throw new ManifoldCFException("Exception doing connector query '" + this.query + "': " + thr.getMessage(), thr);
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
    }

    protected class TestConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public TestConnectionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                WrappedConnection tempConnection = JDBCConnectionFactory.getConnection(JDBCConnection.this.jdbcProvider, JDBCConnection.this.driverString, JDBCConnection.this.userName, JDBCConnection.this.password);
                JDBCConnectionFactory.releaseConnection(tempConnection);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof SQLException) {
                    throw new ManifoldCFException("Error doing JDBC connection test: " + thr.getMessage(), thr);
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
    }

    protected static class NextResultRowThread
    extends Thread {
        protected ResultSet rs;
        protected ResultSetMetaData rsmd;
        protected String[] resultCols;
        protected Throwable exception = null;
        protected IDynamicResultRow response = null;

        public NextResultRowThread(ResultSet rs, ResultSetMetaData rsmd, String[] resultCols) {
            this.setDaemon(true);
            this.rs = rs;
            this.rsmd = rsmd;
            this.resultCols = resultCols;
        }

        @Override
        public void run() {
            try {
                this.response = JDBCConnection.readNextResultRow(this.rs, this.rsmd, this.resultCols);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public IDynamicResultRow finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof SQLException) {
                    throw new ManifoldCFException("Error fetching next JDBC result row: " + thr.getMessage(), thr);
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
            return this.response;
        }
    }
}

