/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.throttler;

import java.util.ArrayList;
import java.util.List;
import org.apache.manifoldcf.core.interfaces.IConnectionThrottler;
import org.apache.manifoldcf.core.interfaces.IFetchThrottler;
import org.apache.manifoldcf.core.interfaces.IStreamThrottler;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IThrottleGroups;
import org.apache.manifoldcf.core.interfaces.IThrottleSpec;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.interfaces.ThrottleGroupsFactory;
import org.apache.manifoldcf.core.tests.BaseDerby;
import org.junit.Test;

public class TestThrottler
extends BaseDerby {
    @Test
    public void multiThreadConnectionPoolTest() throws Exception {
        int i;
        IThreadContext threadContext = ThreadContextFactory.make();
        IThrottleGroups tg = ThrottleGroupsFactory.make((IThreadContext)threadContext);
        tg.createOrUpdateThrottleGroup("test", "test", (IThrottleSpec)new ThrottleSpec());
        IConnectionThrottler connectionThrottler = tg.obtainConnectionThrottler("test", "test", new String[]{"A", "B", "C"});
        System.out.println("Connection throttler obtained");
        PollingThread pt = new PollingThread();
        pt.start();
        EventLog eventLog = new EventLog();
        int numThreads = 10;
        TesterThread[] threads = new TesterThread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new TesterThread(connectionThrottler, eventLog);
            threads[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].finishUp();
        }
        pt.interrupt();
        pt.finishUp();
        tg.removeThrottleGroup("test", "test");
        eventLog.analyze();
        System.out.println("Done test");
    }

    protected static class State {
        public int outstandingConnections = 0;
        public long lastFetch = 0L;
        public long firstByteReadTime = -1L;
        public long byteTotal = 0L;

        protected State() {
        }
    }

    protected static class ReadDoneEvent
    extends LogEntry {
        final int actual;

        public ReadDoneEvent(int actual) {
            super(System.currentTimeMillis());
            this.actual = actual;
        }

        @Override
        public void apply(State state) throws Exception {
            state.byteTotal += (long)this.actual;
        }

        @Override
        public String toString() {
            return super.toString() + "; Read done(" + this.actual + ")";
        }
    }

    protected static class ReadStartEvent
    extends LogEntry {
        final int proposed;

        public ReadStartEvent(int proposed) {
            super(System.currentTimeMillis());
            this.proposed = proposed;
        }

        @Override
        public void apply(State state) throws Exception {
            if (state.firstByteReadTime == -1L) {
                state.firstByteReadTime = this.timestamp;
            } else {
                long minTime = (long)((double)state.byteTotal * 0.75 + 0.5);
                if (this.timestamp - state.firstByteReadTime < minTime) {
                    throw new Exception("Took too short a time to read " + state.byteTotal + " bytes: " + (this.timestamp - state.firstByteReadTime));
                }
            }
        }

        @Override
        public String toString() {
            return super.toString() + "; Read start(" + this.proposed + ")";
        }
    }

    protected static class FetchDoneEvent
    extends LogEntry {
        public FetchDoneEvent() {
            super(System.currentTimeMillis());
        }

        @Override
        public void apply(State state) throws Exception {
        }

        @Override
        public String toString() {
            return super.toString() + "; Fetch done";
        }
    }

    protected static class FetchStartEvent
    extends LogEntry {
        public FetchStartEvent() {
            super(System.currentTimeMillis());
        }

        @Override
        public void apply(State state) throws Exception {
            if (this.timestamp < state.lastFetch + 20L - 1L) {
                throw new Exception("Fetch too fast: took place in " + (this.timestamp - state.lastFetch) + " milliseconds");
            }
            state.lastFetch = this.timestamp;
        }

        @Override
        public String toString() {
            return super.toString() + "; Fetch start";
        }
    }

    protected static class ConnectionReturnedToPoolEvent
    extends LogEntry {
        public ConnectionReturnedToPoolEvent() {
            super(System.currentTimeMillis());
        }

        @Override
        public void apply(State state) throws Exception {
        }

        @Override
        public String toString() {
            return super.toString() + "; Connection back to pool";
        }
    }

    protected static class ConnectionFromPoolEvent
    extends LogEntry {
        public ConnectionFromPoolEvent() {
            super(System.currentTimeMillis());
        }

        @Override
        public void apply(State state) throws Exception {
        }

        @Override
        public String toString() {
            return super.toString() + "; Connection from pool";
        }
    }

    protected static class ConnectionDestroyedEvent
    extends LogEntry {
        public ConnectionDestroyedEvent() {
            super(System.currentTimeMillis());
        }

        @Override
        public void apply(State state) throws Exception {
            --state.outstandingConnections;
        }

        @Override
        public String toString() {
            return super.toString() + "; Connection destroyed";
        }
    }

    protected static class ConnectionCreatedEvent
    extends LogEntry {
        public ConnectionCreatedEvent() {
            super(System.currentTimeMillis());
        }

        @Override
        public void apply(State state) throws Exception {
            if (state.outstandingConnections + 1 > 3) {
                throw new Exception("Too many outstanding connections at once!");
            }
            ++state.outstandingConnections;
        }

        @Override
        public String toString() {
            return super.toString() + "; Connection created";
        }
    }

    protected static abstract class LogEntry {
        protected final long timestamp;

        public LogEntry(long timestamp) {
            this.timestamp = timestamp;
        }

        public abstract void apply(State var1) throws Exception;

        public String toString() {
            return "Time: " + this.timestamp;
        }
    }

    protected static class EventLog {
        protected final List<LogEntry> logList = new ArrayList<LogEntry>();

        public synchronized void addLogEntry(LogEntry x) {
            System.out.println(x.toString());
            this.logList.add(x);
        }

        public synchronized void analyze() throws Exception {
            State s = new State();
            for (LogEntry l : this.logList) {
                l.apply(s);
            }
        }
    }

    protected static class ThrottleSpec
    implements IThrottleSpec {
        public int getMaxOpenConnections(String binName) {
            if (binName.equals("A")) {
                return 3;
            }
            if (binName.equals("B")) {
                return 4;
            }
            return Integer.MAX_VALUE;
        }

        public double getMinimumMillisecondsPerByte(String binName) {
            if (binName.equals("B")) {
                return 0.5;
            }
            if (binName.equals("C")) {
                return 0.75;
            }
            return 0.0;
        }

        public long getMinimumMillisecondsPerFetch(String binName) {
            if (binName.equals("A")) {
                return 5L;
            }
            if (binName.equals("C")) {
                return 20L;
            }
            return 0L;
        }
    }

    protected static class TesterThread
    extends Thread {
        protected final EventLog eventLog;
        protected final IConnectionThrottler connectionThrottler;
        protected Throwable exception = null;

        public TesterThread(IConnectionThrottler connectionThrottler, EventLog eventLog) {
            this.connectionThrottler = connectionThrottler;
            this.eventLog = eventLog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int numberConnectionCycles = 3;
                int numberFetchesPerCycle = 3;
                for (int k = 0; k < numberConnectionCycles; ++k) {
                    int rval = this.connectionThrottler.waitConnectionAvailable();
                    if (rval == -1) {
                        throw new Exception("Unexpected return value from waitConnectionAvailable()");
                    }
                    if (rval == 1) {
                        this.eventLog.addLogEntry(new ConnectionCreatedEvent());
                    } else {
                        this.eventLog.addLogEntry(new ConnectionFromPoolEvent());
                    }
                    IFetchThrottler fetchThrottler = this.connectionThrottler.getNewConnectionFetchThrottler();
                    for (int l = 0; l < numberFetchesPerCycle; ++l) {
                        if (!fetchThrottler.obtainFetchDocumentPermission()) {
                            throw new Exception("Unexpected return value for obtainFetchDocumentPermission()");
                        }
                        this.eventLog.addLogEntry(new FetchStartEvent());
                        IStreamThrottler streamThrottler = fetchThrottler.createFetchStream();
                        try {
                            if (!streamThrottler.obtainReadPermission(1000)) {
                                throw new Exception("False from obtainReadPermission!");
                            }
                            this.eventLog.addLogEntry(new ReadStartEvent(1000));
                            streamThrottler.releaseReadPermission(1000, 1000);
                            this.eventLog.addLogEntry(new ReadDoneEvent(1000));
                            if (!streamThrottler.obtainReadPermission(1000)) {
                                throw new Exception("False from obtainReadPermission!");
                            }
                            this.eventLog.addLogEntry(new ReadStartEvent(1000));
                            streamThrottler.releaseReadPermission(1000, 1000);
                            this.eventLog.addLogEntry(new ReadDoneEvent(1000));
                            if (!streamThrottler.obtainReadPermission(1000)) {
                                throw new Exception("False from obtainReadPermission!");
                            }
                            this.eventLog.addLogEntry(new ReadStartEvent(1000));
                            streamThrottler.releaseReadPermission(1000, 100);
                            this.eventLog.addLogEntry(new ReadDoneEvent(100));
                        }
                        finally {
                            streamThrottler.closeStream();
                        }
                        this.eventLog.addLogEntry(new FetchDoneEvent());
                    }
                    boolean destroyIt = this.connectionThrottler.noteReturnedConnection();
                    if (destroyIt) {
                        this.eventLog.addLogEntry(new ConnectionDestroyedEvent());
                        this.connectionThrottler.noteConnectionDestroyed();
                        continue;
                    }
                    this.eventLog.addLogEntry(new ConnectionReturnedToPoolEvent());
                    this.connectionThrottler.noteConnectionReturnedToPool();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.exception = e;
            }
        }

        public void finishUp() throws Exception {
            this.join();
            if (this.exception != null) {
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                if (this.exception instanceof Error) {
                    throw (Error)this.exception;
                }
                if (this.exception instanceof Exception) {
                    throw (Exception)this.exception;
                }
                throw new RuntimeException("Unknown exception: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
            }
        }
    }

    protected static class PollingThread
    extends Thread {
        protected Throwable exception = null;

        @Override
        public void run() {
            try {
                IThreadContext threadContext = ThreadContextFactory.make();
                IThrottleGroups throttleGroups = ThrottleGroupsFactory.make((IThreadContext)threadContext);
                while (true) {
                    throttleGroups.poll("test");
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public void finishUp() throws Exception {
            this.join();
            if (this.exception != null) {
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                if (this.exception instanceof Error) {
                    throw (Error)this.exception;
                }
                if (this.exception instanceof Exception) {
                    throw (Exception)this.exception;
                }
                throw new RuntimeException("Unknown exception: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
            }
        }
    }
}

