/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.hdfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.manifoldcf.agents.output.hdfs.HDFSOutputParam;
import org.apache.manifoldcf.agents.output.hdfs.ParameterEnum;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.json.JSONException;
import org.json.JSONObject;

public class HDFSOutputSpecs
extends HDFSOutputParam {
    private static final long serialVersionUID = 1145652730572662025L;
    public static final ParameterEnum[] SPECIFICATIONLIST = new ParameterEnum[]{ParameterEnum.rootpath};
    private String rootPath = null;

    public HDFSOutputSpecs(String json) throws JSONException, ManifoldCFException {
        this(new JSONObject(json));
    }

    public HDFSOutputSpecs(JSONObject json) throws JSONException, ManifoldCFException {
        super(SPECIFICATIONLIST);
        for (ParameterEnum param : SPECIFICATIONLIST) {
            String value = null;
            value = json.getString(param.name());
            if (value == null) {
                value = param.defaultValue;
            }
            this.put(param, value);
        }
        this.rootPath = this.getRootPath();
    }

    public HDFSOutputSpecs(ConfigurationNode node) throws ManifoldCFException {
        super(SPECIFICATIONLIST);
        for (ParameterEnum param : SPECIFICATIONLIST) {
            String value = null;
            if (node != null) {
                value = node.getAttributeValue(param.name());
            }
            if (value == null) {
                value = param.defaultValue;
            }
            this.put(param, value);
        }
        this.rootPath = this.getRootPath();
    }

    public static void contextToSpecNode(IPostParameters variableContext, ConfigurationNode specNode, int sequenceNumber) {
        for (ParameterEnum param : SPECIFICATIONLIST) {
            String p = variableContext.getParameter("s" + sequenceNumber + "_" + param.name().toLowerCase());
            if (p == null) continue;
            specNode.setAttribute(param.name(), p);
        }
    }

    public JSONObject toJson() {
        return new JSONObject((Map)this);
    }

    public String getRootPath() {
        return (String)this.get((Object)ParameterEnum.rootpath);
    }

    private static final TreeSet<String> createStringSet(String content) throws ManifoldCFException {
        TreeSet<String> treeSet;
        block6: {
            TreeSet<String> set = new TreeSet<String>();
            BufferedReader br = null;
            StringReader sr = null;
            try {
                sr = new StringReader(content);
                br = new BufferedReader(sr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    set.add(line);
                }
                treeSet = set;
                if (br == null) break block6;
            }
            catch (IOException e) {
                try {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        IOUtils.closeQuietly(br);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)br);
        }
        return treeSet;
    }
}

