/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.nullconnector;

import java.io.IOException;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputNotifyActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class NullConnector
extends BaseOutputConnector {
    public static final String _rcsid = "@(#)$Id: NullConnector.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String INGEST_ACTIVITY = "document ingest";
    public static final String REMOVE_ACTIVITY = "document deletion";
    public static final String JOB_COMPLETE_ACTIVITY = "output notification";

    public String[] getActivitiesList() {
        return new String[]{INGEST_ACTIVITY, REMOVE_ACTIVITY, JOB_COMPLETE_ACTIVITY};
    }

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
    }

    public void disconnect() throws ManifoldCFException {
        super.disconnect();
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Transient error: " + e.getMessage();
        }
    }

    public VersionContext getPipelineDescription(Specification spec) throws ManifoldCFException, ServiceInterruption {
        return new VersionContext("", this.params, spec);
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext outputDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        this.getSession();
        activities.recordActivity(null, INGEST_ACTIVITY, new Long(document.getBinaryLength()), documentURI, "OK", null);
        return 0;
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        activities.recordActivity(null, REMOVE_ACTIVITY, null, documentURI, "OK", null);
    }

    public void noteJobComplete(IOutputNotifyActivity activities) throws ManifoldCFException, ServiceInterruption {
        activities.recordActivity(null, JOB_COMPLETE_ACTIVITY, null, "", "OK", null);
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }
}

