/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoShapeFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.shape.ShapeFetchService;

public class GeoShapeQueryParser
implements QueryParser {
    public static final String NAME = "geo_shape";
    private ShapeFetchService fetchService;

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        ShapeRelation shapeRelation = ShapeRelation.INTERSECTS;
        String strategyName = null;
        ShapeBuilder shape = null;
        String id = null;
        String type = null;
        String index = "shapes";
        String shapePath = "shape";
        String currentFieldName = null;
        float boost = 1.0f;
        String queryName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if ("shape".equals(currentFieldName)) {
                        shape = ShapeBuilder.parse(parser);
                        continue;
                    }
                    if ("strategy".equals(currentFieldName)) {
                        strategyName = parser.text();
                        continue;
                    }
                    if ("relation".equals(currentFieldName)) {
                        shapeRelation = ShapeRelation.getRelationByName(parser.text());
                        if (shapeRelation != null) continue;
                        throw new QueryParsingException(parseContext.index(), "Unknown shape operation [" + parser.text() + " ]");
                    }
                    if ("indexed_shape".equals(currentFieldName) || "indexedShape".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("id".equals(currentFieldName)) {
                                id = parser.text();
                                continue;
                            }
                            if ("type".equals(currentFieldName)) {
                                type = parser.text();
                                continue;
                            }
                            if ("index".equals(currentFieldName)) {
                                index = parser.text();
                                continue;
                            }
                            if (!"path".equals(currentFieldName)) continue;
                            shapePath = parser.text();
                        }
                        if (id == null) {
                            throw new QueryParsingException(parseContext.index(), "ID for indexed shape not provided");
                        }
                        if (type == null) {
                            throw new QueryParsingException(parseContext.index(), "Type for indexed shape not provided");
                        }
                        shape = this.fetchService.fetch(id, type, index, shapePath);
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[geo_shape] query does not support [" + currentFieldName + "]");
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[geo_shape] query does not support [" + currentFieldName + "]");
        }
        if (shape == null) {
            throw new QueryParsingException(parseContext.index(), "No Shape defined");
        }
        if (shapeRelation == null) {
            throw new QueryParsingException(parseContext.index(), "No Shape Relation defined");
        }
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers == null || !smartNameFieldMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "Failed to find geo_shape field [" + fieldName + "]");
        }
        FieldMapper fieldMapper = smartNameFieldMappers.mapper();
        if (!(fieldMapper instanceof GeoShapeFieldMapper)) {
            throw new QueryParsingException(parseContext.index(), "Field [" + fieldName + "] is not a geo_shape");
        }
        GeoShapeFieldMapper shapeFieldMapper = (GeoShapeFieldMapper)fieldMapper;
        PrefixTreeStrategy strategy = shapeFieldMapper.defaultStrategy();
        if (strategyName != null) {
            strategy = shapeFieldMapper.resolveStrategy(strategyName);
        }
        Query query = strategy.makeQuery(GeoShapeQueryParser.getArgs(shape, shapeRelation));
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }

    @Inject(optional=true)
    public void setFetchService(@Nullable ShapeFetchService fetchService) {
        this.fetchService = fetchService;
    }

    public static SpatialArgs getArgs(ShapeBuilder shape, ShapeRelation relation) {
        switch (relation) {
            case DISJOINT: {
                return new SpatialArgs(SpatialOperation.IsDisjointTo, shape.build());
            }
            case INTERSECTS: {
                return new SpatialArgs(SpatialOperation.Intersects, shape.build());
            }
            case WITHIN: {
                return new SpatialArgs(SpatialOperation.IsWithin, shape.build());
            }
        }
        throw new ElasticsearchIllegalArgumentException("");
    }

    public static class DEFAULTS {
        public static final String INDEX_NAME = "shapes";
        public static final String SHAPE_FIELD_NAME = "shape";
    }
}

