/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class ProduceResponse
extends AbstractRequestResponse {
    private static Schema curSchema = ProtoUtils.currentResponseSchema(ApiKeys.PRODUCE.id);
    private static String RESPONSES_KEY_NAME = "responses";
    private static String TOPIC_KEY_NAME = "topic";
    private static String PARTITION_RESPONSES_KEY_NAME = "partition_responses";
    private static String PARTITION_KEY_NAME = "partition";
    private static String ERROR_CODE_KEY_NAME = "error_code";
    private static String BASE_OFFSET_KEY_NAME = "base_offset";
    private final Map<TopicPartition, PartitionResponse> responses;

    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses) {
        super(new Struct(curSchema));
        Map<String, Map<Integer, PartitionResponse>> responseByTopic = CollectionUtils.groupDataByTopic(responses);
        ArrayList<Struct> topicDatas = new ArrayList<Struct>(responseByTopic.size());
        for (Map.Entry<String, Map<Integer, PartitionResponse>> entry : responseByTopic.entrySet()) {
            Struct topicData = this.struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionResponse> partitionEntry : entry.getValue().entrySet()) {
                PartitionResponse part = partitionEntry.getValue();
                Struct partStruct = topicData.instance(PARTITION_RESPONSES_KEY_NAME).set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey()).set(ERROR_CODE_KEY_NAME, (Object)part.errorCode).set(BASE_OFFSET_KEY_NAME, (Object)part.baseOffset);
                partitionArray.add(partStruct);
            }
            topicData.set(PARTITION_RESPONSES_KEY_NAME, (Object)partitionArray.toArray());
            topicDatas.add(topicData);
        }
        this.struct.set(RESPONSES_KEY_NAME, (Object)topicDatas.toArray());
        this.responses = responses;
    }

    public ProduceResponse(Struct struct) {
        super(struct);
        this.responses = new HashMap<TopicPartition, PartitionResponse>();
        for (Object topicResponse : struct.getArray("responses")) {
            Struct topicRespStruct = (Struct)topicResponse;
            String topic = topicRespStruct.getString("topic");
            for (Object partResponse : topicRespStruct.getArray("partition_responses")) {
                Struct partRespStruct = (Struct)partResponse;
                int partition = partRespStruct.getInt("partition");
                short errorCode = partRespStruct.getShort("error_code");
                long offset = partRespStruct.getLong("base_offset");
                TopicPartition tp = new TopicPartition(topic, partition);
                this.responses.put(tp, new PartitionResponse(errorCode, offset));
            }
        }
    }

    public Map<TopicPartition, PartitionResponse> responses() {
        return this.responses;
    }

    public static ProduceResponse parse(ByteBuffer buffer) {
        return new ProduceResponse((Struct)curSchema.read(buffer));
    }

    public static final class PartitionResponse {
        public short errorCode;
        public long baseOffset;

        public PartitionResponse(short errorCode, long baseOffset) {
            this.errorCode = errorCode;
            this.baseOffset = baseOffset;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('{');
            b.append("error: ");
            b.append(this.errorCode);
            b.append(",offset: ");
            b.append(this.baseOffset);
            b.append('}');
            return b.toString();
        }
    }
}

