/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.util.Deque;
import java.util.EnumSet;
import java.util.Locale;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class FormattingUtils {
    private FormattingUtils() {
    }

    public static void ensureFormattingState(XHTMLContentHandler xhtml, EnumSet<Tag> desired, Deque<Tag> currentState) throws SAXException {
        EnumSet<Tag> undesired = EnumSet.complementOf(desired);
        while (!currentState.isEmpty()) {
            if (!currentState.stream().anyMatch(undesired::contains)) break;
            xhtml.endElement(currentState.pop().tagName());
        }
        desired.removeAll(currentState);
        for (Tag tag : desired) {
            currentState.push(tag);
            xhtml.startElement(tag.tagName());
        }
    }

    public static void closeStyleTags(XHTMLContentHandler xhtml, Deque<Tag> formattingState) throws SAXException {
        FormattingUtils.ensureFormattingState(xhtml, EnumSet.noneOf(Tag.class), formattingState);
    }

    public static EnumSet<Tag> toTags(org.apache.poi.wp.usermodel.CharacterRun run) {
        CharacterRun hwpfRun;
        EnumSet<Tag> tags = EnumSet.noneOf(Tag.class);
        if (run.isBold()) {
            tags.add(Tag.B);
        }
        if (run.isItalic()) {
            tags.add(Tag.I);
        }
        if (run.isStrikeThrough()) {
            tags.add(Tag.S);
        }
        if (run instanceof XWPFRun) {
            XWPFRun xwpfRun = (XWPFRun)run;
            if (xwpfRun.getUnderline() != UnderlinePatterns.NONE) {
                tags.add(Tag.U);
            }
        } else if (run instanceof CharacterRun && (hwpfRun = (CharacterRun)run).getUnderlineCode() != 0) {
            tags.add(Tag.U);
        }
        return tags;
    }

    public static enum Tag {
        B,
        I,
        S,
        U;


        public String tagName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

