/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

public enum ApiKeys {
    PRODUCE(0, "produce"),
    FETCH(1, "fetch"),
    LIST_OFFSETS(2, "list_offsets"),
    METADATA(3, "metadata"),
    LEADER_AND_ISR(4, "leader_and_isr"),
    STOP_REPLICA(5, "stop_replica"),
    OFFSET_COMMIT(8, "offset_commit"),
    OFFSET_FETCH(9, "offset_fetch"),
    CONSUMER_METADATA(10, "consumer_metadata"),
    JOIN_GROUP(11, "join_group"),
    HEARTBEAT(12, "heartbeat");

    private static ApiKeys[] codeToType;
    public static int MAX_API_KEY;
    public final short id;
    public final String name;

    private ApiKeys(int id, String name) {
        this.id = (short)id;
        this.name = name;
    }

    public static ApiKeys forId(int id) {
        return codeToType[id];
    }

    static {
        MAX_API_KEY = -1;
        for (ApiKeys key : ApiKeys.values()) {
            MAX_API_KEY = Math.max(MAX_API_KEY, key.id);
        }
        codeToType = new ApiKeys[MAX_API_KEY + 1];
        ApiKeys[] arr$ = ApiKeys.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ApiKeys key;
            ApiKeys.codeToType[key.id] = key = arr$[i$];
        }
    }
}

