/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.DirectoryIteratorException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.LocalizedException;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

public final class Exceptions
extends Static {
    private Exceptions() {
    }

    public static String getLocalizedMessage(Throwable throwable, Locale locale) {
        String string;
        InternationalString internationalString;
        if (throwable == null) {
            return null;
        }
        if (locale == null) {
            return throwable.getMessage();
        }
        if (throwable instanceof LocalizedException && (internationalString = ((LocalizedException)((Object)throwable)).getInternationalMessage()) != null && (string = internationalString.toString(locale)) != null) {
            return string;
        }
        return throwable.getLocalizedMessage();
    }

    public static <T extends Throwable> T setMessage(T t, String string, boolean bl) {
        Object object;
        if (bl && (object = CharSequences.trimWhitespaces(t.getLocalizedMessage())) != null && !((String)object).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(CharSequences.trimWhitespaces(string));
            int n = stringBuilder.length();
            if (n != 0 && Character.isLetterOrDigit(stringBuilder.charAt(n - 1))) {
                stringBuilder.append(". ");
            }
            string = stringBuilder.append((String)object).toString();
        }
        try {
            object = (Throwable)t.getClass().getConstructor(String.class).newInstance(string);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return t;
        }
        ((Throwable)object).setStackTrace(t.getStackTrace());
        return (T)object;
    }

    public static boolean messageEquals(Throwable throwable, Throwable throwable2) {
        if (throwable == throwable2) {
            return true;
        }
        if (throwable == null || throwable2 == null) {
            return false;
        }
        return throwable.getClass() == throwable2.getClass() && Objects.equals(throwable.getMessage(), throwable2.getMessage());
    }

    public static String formatChainedMessages(Locale locale, String string, Throwable throwable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = null;
        Vocabulary vocabulary = null;
        while (throwable != null) {
            SQLException sQLException;
            String string2 = CharSequences.trimWhitespaces(Exceptions.getLocalizedMessage(throwable, locale));
            if (string2 != null && !string2.isEmpty()) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(128);
                    if (string != null) {
                        int n = CharSequences.skipTrailingWhitespaces(string, 0, string.length());
                        if (n > 0) {
                            stringBuilder.append(string, 0, n);
                        }
                        arrayList.add(string);
                    }
                }
                if (!Exceptions.contains(arrayList, string2)) {
                    arrayList.add(string2);
                    if (stringBuilder.length() != 0) {
                        if (vocabulary == null) {
                            vocabulary = Vocabulary.getResources(locale);
                        }
                        stringBuilder.append(System.lineSeparator()).append(vocabulary.getString((short)21, throwable.getClass())).append(": ");
                    }
                    stringBuilder.append(string2);
                }
            }
            if (throwable instanceof SQLException && (sQLException = ((SQLException)throwable).getNextException()) != null) {
                throwable = sQLException;
                continue;
            }
            throwable = throwable.getCause();
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    private static boolean contains(List<String> list, String string) {
        int n = list.size();
        while (--n >= 0) {
            if (!list.get(n).contains(string)) continue;
            return true;
        }
        return false;
    }

    public static Exception unwrap(Exception exception) {
        if (exception != null) {
            Throwable throwable;
            while (exception.getSuppressed().length == 0 && (exception instanceof InvocationTargetException || exception instanceof ExecutionException || exception instanceof BackingStoreException || exception instanceof UncheckedIOException || exception instanceof DirectoryIteratorException) && (throwable = exception.getCause()) instanceof Exception) {
                exception = (Exception)throwable;
            }
            while (exception.getSuppressed().length == 0) {
                throwable = exception.getCause();
                if (!exception.getClass().isInstance(throwable)) break;
                exception = (Exception)throwable;
            }
        }
        return exception;
    }
}

