/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;

class LowLevelIteratorAggregate
implements LowLevelIterator {
    private final LowLevelIterator[] iterators;
    private int iteratorIndex = 0;

    public LowLevelIteratorAggregate(List<LowLevelIterator> c) {
        this.iterators = new LowLevelIterator[c.size()];
        for (int i = 0; i < c.size(); ++i) {
            this.iterators[i] = c.get(i);
        }
        this.moveToFirst();
    }

    private LowLevelIteratorAggregate(LowLevelIterator[] c) {
        this.iterators = c;
        this.moveToFirst();
    }

    @Override
    public void moveToFirst() {
        this.iteratorIndex = 0;
        while (this.iteratorIndex < this.iterators.length) {
            LowLevelIterator it = this.iterators[this.iteratorIndex];
            it.moveToFirst();
            if (it.isValid()) {
                return;
            }
            ++this.iteratorIndex;
        }
    }

    @Override
    public void moveToLast() {
        this.iteratorIndex = this.iterators.length - 1;
        while (this.iteratorIndex >= 0) {
            LowLevelIterator it = this.iterators[this.iteratorIndex];
            it.moveToLast();
            if (it.isValid()) {
                return;
            }
            --this.iteratorIndex;
        }
    }

    @Override
    public boolean isValid() {
        return this.iteratorIndex < this.iterators.length;
    }

    @Override
    public int ll_get() throws NoSuchElementException {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        return this.iterators[this.iteratorIndex].ll_get();
    }

    @Override
    public void moveToNext() {
        if (!this.isValid()) {
            return;
        }
        LowLevelIterator current = this.iterators[this.iteratorIndex];
        current.moveToNext();
        if (current.isValid()) {
            return;
        }
        ++this.iteratorIndex;
        while (this.iteratorIndex < this.iterators.length) {
            current = this.iterators[this.iteratorIndex];
            current.moveToFirst();
            if (current.isValid()) {
                return;
            }
            ++this.iteratorIndex;
        }
    }

    @Override
    public void moveToPrevious() {
        if (!this.isValid()) {
            return;
        }
        LowLevelIterator current = this.iterators[this.iteratorIndex];
        current.moveToPrevious();
        if (current.isValid()) {
            return;
        }
        --this.iteratorIndex;
        while (this.iteratorIndex >= 0) {
            current = this.iterators[this.iteratorIndex];
            current.moveToLast();
            if (current.isValid()) {
                return;
            }
            --this.iteratorIndex;
        }
        this.iteratorIndex = this.iterators.length;
    }

    @Override
    public void moveTo(int fsRef) {
        throw new UnsupportedOperationException("This operation is not supported on an aggregate ll_iterator.");
    }

    @Override
    public Object copy() {
        LowLevelIterator[] itCopies = new LowLevelIterator[this.iterators.length];
        for (int i = 0; i < this.iterators.length; ++i) {
            itCopies[i] = (LowLevelIterator)this.iterators[i].copy();
        }
        LowLevelIteratorAggregate copy = new LowLevelIteratorAggregate(itCopies);
        copy.iteratorIndex = this.iteratorIndex;
        return copy;
    }

    @Override
    public int ll_indexSize() {
        return 0;
    }

    @Override
    public LowLevelIndex ll_getIndex() {
        return null;
    }
}

