/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes.local;

import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.local.KeyListStorage;
import java.util.ArrayList;
import java.util.List;

public class MixinsDefinitionsStorage
implements Cloneable {
    private KeyListStorage<String, FullMixinDefinition> coolStorage = new KeyListStorage();

    public void store(FullMixinDefinition mixin) {
        List<ReusableStructureName> names = mixin.getMixin().getNames();
        for (ReusableStructureName name : names) {
            this.coolStorage.add(name.asString(), mixin);
        }
    }

    public void store(String name, List<FullMixinDefinition> value) {
        this.coolStorage.add(name, value);
    }

    public void storeAll(List<FullMixinDefinition> mixins) {
        for (FullMixinDefinition mixin : mixins) {
            this.store(mixin);
        }
    }

    public void storeAll(MixinsDefinitionsStorage otherStorage) {
        this.coolStorage.add(otherStorage.coolStorage);
    }

    public List<FullMixinDefinition> getMixins(List<String> nameChain, ReusableStructureName name) {
        return this.getMixins(this.toMixinName(nameChain, name));
    }

    private String toMixinName(List<String> nameChain, ReusableStructureName name) {
        StringBuilder result = new StringBuilder();
        for (String str : nameChain) {
            result.append(str);
        }
        result.append(name.asString());
        return result.toString();
    }

    public List<FullMixinDefinition> getMixins(ReusableStructureName name) {
        return this.getMixins(name.asString());
    }

    public List<FullMixinDefinition> getMixins(String name) {
        ArrayList mixins = this.coolStorage.getValues(name);
        return mixins != null ? mixins : new ArrayList();
    }

    public List<FullMixinDefinition> getAllMixins() {
        return this.coolStorage.getAllValues();
    }

    public void addToPlaceholder(MixinsDefinitionsStorage otherStorage) {
        this.coolStorage.addDataToFirstPlaceholder(otherStorage.coolStorage);
    }

    public void replacePlaceholder(MixinsPlaceholder mixinsPlaceholder, MixinsDefinitionsStorage otherStorage) {
        this.coolStorage.replacePlaceholder(mixinsPlaceholder.coolPlaceholder, otherStorage.coolStorage);
    }

    public void addAll(MixinsDefinitionsStorage source) {
        this.coolStorage.add(source.coolStorage);
    }

    public MixinsPlaceholder createPlaceholder() {
        KeyListStorage.ListPlaceholder<String, FullMixinDefinition> coolPlaceholder = this.coolStorage.createPlaceholder();
        return new MixinsPlaceholder(coolPlaceholder);
    }

    public void closePlaceholder() {
        this.coolStorage.closeFirstPlaceholder();
    }

    public int size() {
        return this.coolStorage.getAllValues().size();
    }

    public MixinsDefinitionsStorage clone() {
        try {
            MixinsDefinitionsStorage clone = (MixinsDefinitionsStorage)super.clone();
            clone.coolStorage = this.coolStorage.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible state.");
        }
    }

    public String toString() {
        return this.coolStorage.toString();
    }

    public static class MixinsPlaceholder {
        private final KeyListStorage.ListPlaceholder<String, FullMixinDefinition> coolPlaceholder;

        public MixinsPlaceholder(KeyListStorage.ListPlaceholder<String, FullMixinDefinition> coolPlaceholder) {
            this.coolPlaceholder = coolPlaceholder;
        }
    }
}

