/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JEnumConstant;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public final class JEnum
extends JClass {
    private JNamedMap _constants = new JNamedMap();

    protected JEnum(String name) {
        super(name);
        this.getJDocComment().setComment("Enumeration " + this.getLocalName() + ".");
    }

    public void addMember(JMember jMember) {
        if (jMember instanceof JEnumConstant) {
            this.addConstant((JEnumConstant)jMember);
        } else {
            super.addMember(jMember);
        }
    }

    public void addConstant(JEnumConstant jConstant) {
        if (jConstant == null) {
            throw new IllegalArgumentException("Enum fields cannot be null");
        }
        String name = jConstant.getName();
        if (this._constants.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        this._constants.put(name, jConstant);
    }

    public JEnumConstant getConstant(String name) {
        return (JEnumConstant)this._constants.get(name);
    }

    public JEnumConstant[] getConstants() {
        int size = this._constants.size();
        JEnumConstant[] farray = new JEnumConstant[size];
        for (int i = 0; i < size; ++i) {
            farray[i] = (JEnumConstant)this._constants.get(i);
        }
        return farray;
    }

    public void setSuperClass(String superClass) {
        throw new RuntimeException("Enum classes are not allowed to extend other classes.");
    }

    public void print(JSourceWriter jsw) {
        Enumeration enumeration;
        int i;
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuffer buffer = new StringBuffer();
        this.printHeader(jsw);
        this.printPackageDeclaration(jsw);
        Vector<String> removeImports = null;
        if (this._innerClasses != null && this._innerClasses.size() > 0) {
            removeImports = new Vector<String>();
            for (i = 0; i < this._innerClasses.size(); ++i) {
                JClass iClass = (JClass)this._innerClasses.elementAt(i);
                enumeration = iClass.getImports();
                while (enumeration.hasMoreElements()) {
                    String classname = (String)enumeration.nextElement();
                    if (this.hasImport(classname)) continue;
                    this.addImport(classname);
                    removeImports.addElement(classname);
                }
            }
        }
        this.printImportDeclarations(jsw);
        if (removeImports != null) {
            for (i = 0; i < removeImports.size(); ++i) {
                this.removeImport((String)removeImports.elementAt(i));
            }
        }
        this.getJDocComment().print(jsw);
        buffer.setLength(0);
        this.getAnnotatedElementHelper().printAnnotations(jsw);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        buffer.append("enum ");
        buffer.append(this.getLocalName());
        buffer.append(' ');
        if (this.getInterfaceCount() > 0) {
            boolean endl = false;
            if (this.getInterfaceCount() > 1) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
                endl = true;
            }
            buffer.append("implements ");
            enumeration = this.getInterfaces();
            while (enumeration.hasMoreElements()) {
                buffer.append(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                buffer.append(", ");
            }
            if (endl) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
            } else {
                buffer.append(' ');
            }
        }
        buffer.append('{');
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
        jsw.writeln();
        jsw.indent();
        if (this._constants.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //------------------/");
            jsw.writeln(" //- Enum Constants -/");
            jsw.writeln("//------------------/");
            jsw.writeln();
        }
        for (int i2 = 0; i2 < this._constants.size(); ++i2) {
            JEnumConstant jConstant = (JEnumConstant)this._constants.get(i2);
            jConstant.print(jsw);
            if (i2 < this._constants.size() - 1) {
                jsw.write(",");
            } else {
                jsw.write(";");
            }
            jsw.writeln();
        }
        this.printMemberVariables(jsw);
        this.printStaticInitializers(jsw);
        this.printConstructors(jsw);
        this.printMethods(jsw);
        this.printInnerClasses(jsw);
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
    }

    private void printMemberVariables(JSourceWriter jsw) {
        if (this._fields.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //--------------------------/");
            jsw.writeln(" //- Class/Member Variables -/");
            jsw.writeln("//--------------------------/");
            jsw.writeln();
        }
        for (int i = 0; i < this._fields.size(); ++i) {
            JField jField = (JField)this._fields.get(i);
            JDocComment comment = jField.getComment();
            if (comment != null) {
                comment.print(jsw);
            }
            jField.printAnnotations(jsw);
            jsw.write(jField.getModifiers().toString());
            jsw.write(32);
            JType type = jField.getType();
            String typeName = type.toString();
            if (typeName.equals(this.toString())) {
                typeName = type.getLocalName();
            }
            jsw.write(typeName);
            jsw.write(32);
            jsw.write(jField.getName());
            String init = jField.getInitString();
            if (init != null) {
                jsw.write(" = ");
                jsw.write(init);
            }
            jsw.writeln(';');
            jsw.writeln();
        }
    }

    private void printStaticInitializers(JSourceWriter jsw) {
        if (!this._staticInitializer.isEmpty()) {
            jsw.writeln();
            jsw.writeln("static {");
            jsw.writeln(this._staticInitializer.toString());
            jsw.writeln("};");
            jsw.writeln();
        }
    }

    private void printConstructors(JSourceWriter jsw) {
        if (this._constructors.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //----------------/");
            jsw.writeln(" //- Constructors -/");
            jsw.writeln("//----------------/");
            jsw.writeln();
        }
        for (int i = 0; i < this._constructors.size(); ++i) {
            JConstructor jConstructor = (JConstructor)this._constructors.elementAt(i);
            jConstructor.print(jsw);
            jsw.writeln();
        }
    }

    private void printMethods(JSourceWriter jsw) {
        if (this._methods.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------/");
            jsw.writeln(" //- Methods -/");
            jsw.writeln("//-----------/");
            jsw.writeln();
        }
        for (int i = 0; i < this._methods.size(); ++i) {
            JMethod jMethod = (JMethod)this._methods.elementAt(i);
            jMethod.print(jsw);
            jsw.writeln();
        }
    }

    private void printInnerClasses(JSourceWriter jsw) {
        if (this._innerClasses != null && this._innerClasses.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------------/");
            jsw.writeln(" //- Inner Classes -/");
            jsw.writeln("//-----------------/");
            jsw.writeln();
            for (int i = 0; i < this._innerClasses.size(); ++i) {
                JClass jClass = (JClass)this._innerClasses.elementAt(i);
                jClass.print(jsw, true);
                jsw.writeln();
            }
        }
    }

    public static void main(String[] args) {
        JSourceWriter jsw = new JSourceWriter(new PrintWriter(System.out));
        JEnum color1 = new JEnum("Color");
        color1.addConstant(new JEnumConstant("RED"));
        color1.addConstant(new JEnumConstant("GREEN"));
        color1.addConstant(new JEnumConstant("BLUE"));
        color1.print(jsw);
        JEnum color2 = new JEnum("Color");
        color2.addField(new JField(new JType("String"), "_rgb"));
        JConstructor jConstructor2 = new JConstructor(color2);
        jConstructor2.addParameter(new JParameter(new JType("String"), "rgb"));
        jConstructor2.setSourceCode("_rgb = rgb;");
        color2.addConstructor(jConstructor2);
        color2.addConstant(new JEnumConstant("RED", new String[]{"\"#FF0000\""}));
        color2.addConstant(new JEnumConstant("GREEN", new String[]{"\"#00FF00\""}));
        color2.addConstant(new JEnumConstant("BLUE", new String[]{"\"#0000FF\""}));
        color2.print(jsw);
        JEnum operation3 = new JEnum("Operation");
        JEnumConstant plus3 = new JEnumConstant("PLUS");
        JMethod jMethod3 = new JMethod("eval", new JType("double"), "the sum of the arguments.");
        jMethod3.getModifiers().makePackage();
        jMethod3.addParameter(new JParameter(JType.DOUBLE, "x"));
        jMethod3.addParameter(new JParameter(JType.DOUBLE, "y"));
        jMethod3.setSourceCode("return x + y;");
        plus3.addMethod(jMethod3);
        operation3.addConstant(plus3);
        JEnumConstant minus3 = new JEnumConstant("MINUS");
        jMethod3 = new JMethod("eval", JType.DOUBLE, "the difference of the arguments.");
        jMethod3.getModifiers().makePackage();
        jMethod3.addParameter(new JParameter(JType.DOUBLE, "x"));
        jMethod3.addParameter(new JParameter(JType.DOUBLE, "y"));
        jMethod3.setSourceCode("return x - y;");
        minus3.addMethod(jMethod3);
        operation3.addConstant(minus3);
        JEnumConstant times3 = new JEnumConstant("TIMES");
        jMethod3 = new JMethod("eval", JType.DOUBLE, "the result of x * y");
        jMethod3.getModifiers().makePackage();
        jMethod3.addParameter(new JParameter(JType.DOUBLE, "x"));
        jMethod3.addParameter(new JParameter(JType.DOUBLE, "y"));
        jMethod3.setSourceCode("return x * y;");
        times3.addMethod(jMethod3);
        operation3.addConstant(times3);
        jMethod3 = new JMethod("eval", JType.DOUBLE, "the value of the provided evaluation");
        jMethod3.getModifiers().makePackage();
        jMethod3.addParameter(new JParameter(JType.DOUBLE, "x"));
        jMethod3.addParameter(new JParameter(JType.DOUBLE, "y"));
        jMethod3.getModifiers().setAbstract(true);
        operation3.addMethod(jMethod3);
        operation3.print(jsw);
        jsw.flush();
    }
}

