/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.expressions.GuardValue;
import com.github.sommeri.less4j.core.compiler.expressions.MixinsGuardsValidator;
import com.github.sommeri.less4j.core.compiler.scopes.FoundMixin;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.InScopeSnapshotRunner;
import com.github.sommeri.less4j.core.compiler.stages.AstNodesStack;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;

public class MixinReferenceFinder {
    private final ReferencesSolver parentSolver;
    private final AstNodesStack semiCompiledNodes;
    private boolean foundNamespace = false;
    private final ProblemsHandler problemsHandler;
    private final LessCompiler.Configuration configuration;

    public MixinReferenceFinder(ReferencesSolver referencesSolver, AstNodesStack semiCompiledNodes, ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.parentSolver = referencesSolver;
        this.semiCompiledNodes = semiCompiledNodes;
        this.problemsHandler = problemsHandler;
        this.configuration = configuration;
    }

    public List<FoundMixin> getNearestMixins(IScope scope, MixinReference reference) {
        this.foundNamespace = false;
        List<String> nameChain = reference.getNameChainAsStrings();
        IScope space = scope;
        List<FoundMixin> result = this.findInMatchingNamespace(scope, nameChain, reference);
        while (result.isEmpty() && space.hasParent()) {
            space = space.getParent();
            result = this.findInMatchingNamespace(space, nameChain, reference);
        }
        return result;
    }

    public boolean foundNamespace() {
        return this.foundNamespace;
    }

    private List<FoundMixin> getNearestLocalMixins(IScope scope, List<String> nameChain, ReusableStructureName name) {
        List<FullMixinDefinition> mixins;
        if (scope.isBodyOwnerScope()) {
            scope = scope.firstChild();
        }
        if ((mixins = scope.getMixinsByName(nameChain, name)) != null) {
            mixins = this.removeLegalCycles(mixins, name);
        }
        ArrayList<FoundMixin> result = new ArrayList<FoundMixin>();
        if (mixins == null) {
            return result;
        }
        for (FullMixinDefinition fulDefinition : mixins) {
            result.add(new FoundMixin(fulDefinition));
        }
        return result;
    }

    private List<FullMixinDefinition> removeLegalCycles(List<FullMixinDefinition> value, ReusableStructureName name) {
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (FullMixinDefinition mixin : value) {
            if (this.participatesInCuttableCycle(mixin)) continue;
            result.add(mixin);
        }
        return result;
    }

    private boolean participatesInCuttableCycle(FullMixinDefinition mixin) {
        return mixin.getMixin().isAlsoRuleset() && this.semiCompiledNodes.contains(mixin.getMixin());
    }

    private List<FoundMixin> findInMatchingNamespace(IScope scope, List<String> nameChain, MixinReference reference) {
        ArrayList<FoundMixin> result = new ArrayList<FoundMixin>();
        if (nameChain.isEmpty()) {
            this.foundNamespace = true;
        } else {
            for (int prefix = 1; prefix <= nameChain.size(); ++prefix) {
                String name = this.toName(nameChain.subList(0, prefix));
                ArrayList<String> theRest = prefix == nameChain.size() ? new ArrayList<String>() : nameChain.subList(prefix, nameChain.size());
                for (FullMixinDefinition fullNamespace : scope.getMixinsByName(name)) {
                    List<FoundMixin> foundInNamespaces = this.buildAndFind(fullNamespace, theRest, reference);
                    result.addAll(foundInNamespaces);
                }
            }
        }
        result.addAll(this.getNearestLocalMixins(scope, nameChain, reference.getFinalName()));
        return result;
    }

    private String toName(List<String> list) {
        StringBuilder builder = new StringBuilder();
        for (String string : list) {
            builder.append(string);
        }
        return builder.toString();
    }

    private List<FoundMixin> buildAndFind(FullMixinDefinition fullNamespace, final List<String> nameChain, final MixinReference reference) {
        final ArrayList<FoundMixin> result = new ArrayList<FoundMixin>();
        final ReusableStructure namespace = fullNamespace.getMixin();
        final GeneralBody bodyClone = namespace.getBody().clone();
        final IScope scope = fullNamespace.getScope();
        if (namespace.hasMandatoryParameters()) {
            return result;
        }
        InScopeSnapshotRunner.runInLocalDataSnapshot(scope, new InScopeSnapshotRunner.ITask(){

            @Override
            public void run() {
                MixinsGuardsValidator guardsValidator;
                GuardValue guardValue;
                if (!MixinReferenceFinder.this.semiCompiledNodes.contains(bodyClone)) {
                    MixinReferenceFinder.this.parentSolver.unsafeDoSolveReferences((ASTCssNode)bodyClone, scope);
                    ExpressionEvaluator evaluator = new ExpressionEvaluator(scope, MixinReferenceFinder.this.problemsHandler, MixinReferenceFinder.this.configuration);
                    evaluator.evaluateValues(scope);
                }
                if ((guardValue = (guardsValidator = new MixinsGuardsValidator(scope, MixinReferenceFinder.this.problemsHandler, MixinReferenceFinder.this.configuration)).evaluateGuards(namespace)) != GuardValue.DO_NOT_USE) {
                    List found = MixinReferenceFinder.this.findInMatchingNamespace(scope, nameChain, reference);
                    for (FoundMixin foundMixin : found) {
                        foundMixin.prefixGuardValue(guardValue);
                        result.add(foundMixin);
                    }
                }
            }
        });
        return result;
    }
}

