/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.configuration;

import org.apache.commons.lang3.Validate;
import org.apache.maven.configuration.BeanConfigurationPathTranslator;
import org.apache.maven.configuration.BeanConfigurationRequest;
import org.apache.maven.configuration.BeanConfigurationValuePreprocessor;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.codehaus.plexus.util.StringUtils;

public class DefaultBeanConfigurationRequest
implements BeanConfigurationRequest {
    private Object bean;
    private Object configuration;
    private String configurationElement;
    private ClassLoader classLoader;
    private BeanConfigurationValuePreprocessor valuePreprocessor;
    private BeanConfigurationPathTranslator pathTranslator;

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public DefaultBeanConfigurationRequest setBean(Object bean) {
        this.bean = bean;
        return this;
    }

    @Override
    public Object getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getConfigurationElement() {
        return this.configurationElement;
    }

    @Override
    public DefaultBeanConfigurationRequest setConfiguration(Object configuration) {
        return this.setConfiguration(configuration, null);
    }

    @Override
    public DefaultBeanConfigurationRequest setConfiguration(Object configuration, String element) {
        this.configuration = configuration;
        this.configurationElement = element;
        return this;
    }

    public DefaultBeanConfigurationRequest setConfiguration(Model model, String pluginGroupId, String pluginArtifactId, String pluginExecutionId) {
        Plugin plugin = this.findPlugin(model, pluginGroupId, pluginArtifactId);
        if (plugin != null) {
            if (StringUtils.isNotEmpty((String)pluginExecutionId)) {
                for (PluginExecution execution : plugin.getExecutions()) {
                    if (!pluginExecutionId.equals(execution.getId())) continue;
                    this.setConfiguration(execution.getConfiguration());
                    break;
                }
            } else {
                this.setConfiguration(plugin.getConfiguration());
            }
        }
        return this;
    }

    private Plugin findPlugin(Model model, String groupId, String artifactId) {
        Build build;
        Validate.notBlank((CharSequence)groupId, (String)"groupId can neither be null, empty nor blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifactId, (String)"artifactId can neither be null, empty nor blank", (Object[])new Object[0]);
        if (model != null && (build = model.getBuild()) != null) {
            for (Plugin plugin : build.getPlugins()) {
                if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                return plugin;
            }
            PluginManagement mgmt = build.getPluginManagement();
            if (mgmt != null) {
                for (Plugin plugin : mgmt.getPlugins()) {
                    if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                    return plugin;
                }
            }
        }
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public DefaultBeanConfigurationRequest setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public BeanConfigurationValuePreprocessor getValuePreprocessor() {
        return this.valuePreprocessor;
    }

    @Override
    public DefaultBeanConfigurationRequest setValuePreprocessor(BeanConfigurationValuePreprocessor valuePreprocessor) {
        this.valuePreprocessor = valuePreprocessor;
        return this;
    }

    @Override
    public BeanConfigurationPathTranslator getPathTranslator() {
        return this.pathTranslator;
    }

    @Override
    public DefaultBeanConfigurationRequest setPathTranslator(BeanConfigurationPathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }
}

