/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.impl.store.access.heap.HeapScan;

class HeapCompressScan
extends HeapScan {
    private long pagenum_to_start_moving_rows = -1L;

    public int fetchNextGroup(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray, RowLocation[] rowLocationArray2) throws StandardException {
        return this.fetchRowsForCompress(dataValueDescriptorArray, rowLocationArray, rowLocationArray2);
    }

    private int fetchRowsForCompress(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray, RowLocation[] rowLocationArray2) throws StandardException {
        RecordHandle[] recordHandleArray;
        int n = 0;
        Object[] objectArray = null;
        if (this.getScanState() == 2) {
            this.positionAtResumeScan(this.scan_position);
        } else if (this.getScanState() == 1) {
            recordHandleArray = this.open_conglom.getContainer().getSpaceInfo();
            this.pagenum_to_start_moving_rows = recordHandleArray.getNumAllocatedPages();
            this.positionAtStartForForwardScan(this.scan_position);
        } else if (this.getScanState() == 5) {
            this.reopenAfterEndTransaction();
            this.open_conglom.latchPageAndRepositionScan(this.scan_position);
            this.setScanState(2);
        } else if (this.getScanState() == 4) {
            this.reopenAfterEndTransaction();
            this.positionAtStartForForwardScan(this.scan_position);
        } else {
            return 0;
        }
        while (this.scan_position.current_page != null) {
            while (this.scan_position.current_slot + 1 < this.scan_position.current_page.recordCount()) {
                if (objectArray == null) {
                    if (dataValueDescriptorArray[n] == null) {
                        dataValueDescriptorArray[n] = this.open_conglom.getRuntimeMem().get_row_for_export();
                    }
                    objectArray = dataValueDescriptorArray[n];
                }
                this.scan_position.positionAtNextSlot();
                ++this.stat_numrows_visited;
                if (this.scan_position.current_page.isDeletedAtSlot(this.scan_position.current_slot)) {
                    this.scan_position.current_page.purgeAtSlot(this.scan_position.current_slot, 1, false);
                    this.scan_position.positionAtPrevSlot();
                    continue;
                }
                if (this.scan_position.current_page.getPageNumber() <= this.pagenum_to_start_moving_rows) continue;
                recordHandleArray = new RecordHandle[1];
                RecordHandle[] recordHandleArray2 = new RecordHandle[1];
                long[] lArray = new long[1];
                if (this.scan_position.current_page.moveRecordForCompressAtSlot(this.scan_position.current_slot, objectArray, recordHandleArray, recordHandleArray2) != 1) continue;
                this.scan_position.positionAtPrevSlot();
                ++this.stat_numrows_qualified;
                this.setRowLocationArray(rowLocationArray, ++n - 1, recordHandleArray[0]);
                this.setRowLocationArray(rowLocationArray2, n - 1, recordHandleArray2[0]);
                objectArray = null;
            }
            ++this.stat_numpages_visited;
            if (this.scan_position.current_page.recordCount() == 0) {
                this.scan_position.current_pageno = this.scan_position.current_page.getPageNumber();
                this.open_conglom.getContainer().removePage(this.scan_position.current_page);
                this.scan_position.current_page = null;
            } else {
                this.positionAfterThisPage(this.scan_position);
                this.scan_position.unlatch();
            }
            if (n > 0) {
                return n;
            }
            this.positionAtResumeScan(this.scan_position);
        }
        this.positionAtDoneScan(this.scan_position);
        --this.stat_numpages_visited;
        return n;
    }

    protected void positionAtResumeScan(RowPosition rowPosition) throws StandardException {
        this.open_conglom.latchPageAndRepositionScan(this.scan_position);
    }

    protected void positionAtStartForForwardScan(RowPosition rowPosition) throws StandardException {
        if (rowPosition.current_rh == null) {
            rowPosition.current_page = this.open_conglom.getContainer().getNextPage(1L);
            rowPosition.current_slot = -1;
        } else {
            this.open_conglom.latchPageAndRepositionScan(rowPosition);
            --rowPosition.current_slot;
        }
        rowPosition.current_rh = null;
        this.stat_numpages_visited = 1;
        this.setScanState(2);
    }

    private void positionAfterThisPage(RowPosition rowPosition) throws StandardException {
        rowPosition.current_rh = null;
        rowPosition.current_pageno = rowPosition.current_page.getPageNumber();
    }
}

