/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.mina;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.vysper.mina.codec.StanzaWriteInfo;
import org.apache.vysper.xml.fragment.Renderer;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.writer.DenseStanzaLogRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StanzaLoggingFilter
extends IoFilterAdapter {
    final Logger serverLogger = LoggerFactory.getLogger((String)"stanza.server");
    final Logger clientLogger = LoggerFactory.getLogger((String)"stanza.client");

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (message instanceof XMLElement) {
            XMLElement element = (XMLElement)message;
            if (this.clientLogger.isDebugEnabled()) {
                boolean openElement = true;
                boolean closeElement = true;
                if (element.getName().equals("stream")) {
                    if (element.getAttributes().size() > 0) {
                        closeElement = false;
                    } else {
                        openElement = false;
                    }
                }
                String xml = this.toXml(element, openElement, closeElement);
                this.clientLogger.debug("< " + xml);
            } else if (this.clientLogger.isInfoEnabled()) {
                this.clientLogger.info(DenseStanzaLogRenderer.render(element));
            }
        }
        nextFilter.messageReceived(session, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest request) throws Exception {
        Object message = request.getMessage();
        if (message instanceof StanzaWriteInfo) {
            StanzaWriteInfo stanzaWriteInfo = (StanzaWriteInfo)message;
            if (this.serverLogger.isDebugEnabled()) {
                String xml = this.toXml(stanzaWriteInfo.getStanza(), stanzaWriteInfo.isWriteOpeningElement(), stanzaWriteInfo.isWriteClosingElement());
                this.serverLogger.debug("> " + xml);
            } else if (this.serverLogger.isInfoEnabled()) {
                this.serverLogger.info(DenseStanzaLogRenderer.render(stanzaWriteInfo.getStanza()));
            }
        }
        nextFilter.messageSent(session, request);
    }

    private String toXml(XMLElement element, boolean openElement, boolean closeElement) {
        Renderer renderer = new Renderer(element);
        StringBuffer xml = new StringBuffer();
        if (openElement) {
            xml.append(renderer.getOpeningElement());
        }
        xml.append(renderer.getElementContent());
        if (closeElement) {
            xml.append(renderer.getClosingElement());
        }
        return xml.toString();
    }
}

