/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.storage.jcr;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.vysper.storage.jcr.JcrStorageException;
import org.apache.vysper.xmpp.addressing.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrStorage {
    final Logger logger = LoggerFactory.getLogger(JcrStorage.class);
    protected static JcrStorage jcrStorageSingleton;
    protected Session session = null;

    protected JcrStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JcrStorage getInstance() {
        Class<JcrStorage> clazz = JcrStorage.class;
        synchronized (JcrStorage.class) {
            if (jcrStorageSingleton == null) {
                jcrStorageSingleton = new JcrStorage();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return jcrStorageSingleton;
        }
    }

    public Session getRepositorySession() throws JcrStorageException {
        if (this.session != null) {
            return this.session;
        }
        try {
            TransientRepository repository = new TransientRepository();
            this.session = repository.login((Credentials)new SimpleCredentials("xmpp-admin", "adminpassword".toCharArray()));
            return this.session;
        }
        catch (Exception e) {
            throw new JcrStorageException(e);
        }
    }

    public Node getRootNode() throws JcrStorageException {
        try {
            return this.getRepositorySession().getRootNode();
        }
        catch (RepositoryException e) {
            throw new JcrStorageException(e);
        }
    }

    public Node getEntityNode(Entity bareEntity, String namespace, boolean createIfMissing) throws JcrStorageException {
        String path;
        bareEntity = bareEntity.getBareJID();
        if (namespace != null) {
            namespace = namespace.replace(':', '_');
        }
        if (!this.itemExists(path = "/accountentity/" + bareEntity.getFullQualifiedName() + (namespace != null ? "/" + namespace : ""))) {
            if (!createIfMissing) {
                return null;
            }
            Node accountEntityNode = this.getOrCreate(this.getRootNode(), "accountentity");
            Node entityNode = this.getOrCreate(accountEntityNode, bareEntity.getFullQualifiedName());
            if (namespace != null) {
                entityNode = this.getOrCreate(entityNode, namespace);
            }
            return entityNode;
        }
        try {
            return (Node)this.getRepositorySession().getItem(path);
        }
        catch (RepositoryException e) {
            throw new JcrStorageException(e);
        }
    }

    private boolean itemExists(String absolutePath) throws JcrStorageException {
        try {
            return this.getRepositorySession().itemExists(absolutePath);
        }
        catch (RepositoryException e) {
            throw new JcrStorageException(e);
        }
        catch (JcrStorageException e) {
            throw e;
        }
    }

    protected Node getOrCreate(Node parent, String nodeName) throws JcrStorageException {
        Node childNode;
        try {
            childNode = parent.getNode(nodeName);
        }
        catch (RepositoryException e) {
            childNode = null;
        }
        if (childNode == null) {
            try {
                childNode = parent.addNode(nodeName);
                parent.save();
                childNode.save();
                this.logger.info("JCR node created: " + childNode);
            }
            catch (RepositoryException e) {
                throw new JcrStorageException(e);
            }
        }
        return childNode;
    }
}

