/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.protocol;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0077_inbandreg.InBandRegistrationHandler;
import org.apache.vysper.xmpp.protocol.ResponseWriter;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.protocol.StanzaProcessor;
import org.apache.vysper.xmpp.protocol.StateAwareProtocolWorker;
import org.apache.vysper.xmpp.protocol.exception.TLSException;
import org.apache.vysper.xmpp.protocol.worker.AuthenticatedProtocolWorker;
import org.apache.vysper.xmpp.protocol.worker.EncryptedProtocolWorker;
import org.apache.vysper.xmpp.protocol.worker.EncryptionStartedProtocolWorker;
import org.apache.vysper.xmpp.protocol.worker.EndOrClosedProtocolWorker;
import org.apache.vysper.xmpp.protocol.worker.InitiatedProtocolWorker;
import org.apache.vysper.xmpp.protocol.worker.StartedProtocolWorker;
import org.apache.vysper.xmpp.protocol.worker.UnconnectedProtocolWorker;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;
import org.apache.vysper.xmpp.writer.DenseStanzaLogRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolWorker
implements StanzaProcessor {
    final Logger logger = LoggerFactory.getLogger(ProtocolWorker.class);
    private final Map<SessionState, StateAwareProtocolWorker> stateWorker = new HashMap<SessionState, StateAwareProtocolWorker>();
    private final ResponseWriter responseWriter = new ResponseWriter();

    public ProtocolWorker() {
        this.stateWorker.put(SessionState.UNCONNECTED, new UnconnectedProtocolWorker());
        this.stateWorker.put(SessionState.INITIATED, new InitiatedProtocolWorker());
        this.stateWorker.put(SessionState.STARTED, new StartedProtocolWorker());
        this.stateWorker.put(SessionState.ENCRYPTION_STARTED, new EncryptionStartedProtocolWorker());
        this.stateWorker.put(SessionState.ENCRYPTED, new EncryptedProtocolWorker());
        this.stateWorker.put(SessionState.AUTHENTICATED, new AuthenticatedProtocolWorker());
        this.stateWorker.put(SessionState.ENDED, new EndOrClosedProtocolWorker());
        this.stateWorker.put(SessionState.CLOSED, new EndOrClosedProtocolWorker());
    }

    public void processStanza(ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext, Stanza stanza, SessionStateHolder sessionStateHolder) {
        if (stanza == null) {
            throw new RuntimeException("cannot process NULL stanzas");
        }
        StanzaHandler stanzaHandler = serverRuntimeContext.getHandler(stanza);
        if (stanzaHandler == null) {
            this.responseWriter.handleUnsupportedStanzaType(sessionContext, stanza);
            return;
        }
        if (sessionContext == null && stanzaHandler.isSessionRequired()) {
            throw new IllegalStateException("handler requires session context");
        }
        StateAwareProtocolWorker stateAwareProtocolWorker = this.stateWorker.get((Object)sessionContext.getState());
        if (stateAwareProtocolWorker == null) {
            throw new IllegalStateException("no protocol worker for state " + sessionContext.getState().toString());
        }
        if (sessionStateHolder.getState() != SessionState.AUTHENTICATED && XMPPCoreStanza.getWrapper(stanza) != null && !(stanzaHandler instanceof InBandRegistrationHandler)) {
            this.responseWriter.handleNotAuthorized(sessionContext, stanza);
            return;
        }
        Entity from = stanza.getFrom();
        if (sessionContext.isServerToServer()) {
            XMPPCoreStanza coreStanza = XMPPCoreStanza.getWrapper(stanza);
            if (coreStanza != null) {
                if (from == null) {
                    Stanza errorStanza = ServerErrorResponses.getStanzaError(StanzaErrorCondition.UNKNOWN_SENDER, coreStanza, StanzaErrorType.MODIFY, "Missing from attribute", null, null);
                    ResponseWriter.writeResponse(sessionContext, errorStanza);
                    return;
                }
                if (!from.getDomain().equals(sessionContext.getInitiatingEntity().getDomain())) {
                    Stanza errorStanza = ServerErrorResponses.getStanzaError(StanzaErrorCondition.UNKNOWN_SENDER, coreStanza, StanzaErrorType.MODIFY, "Incorrect from attribute", null, null);
                    ResponseWriter.writeResponse(sessionContext, errorStanza);
                    return;
                }
                Entity to = stanza.getTo();
                if (to == null) {
                    Stanza errorStanza = ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, coreStanza, StanzaErrorType.MODIFY, "Missing to attribute", null, null);
                    ResponseWriter.writeResponse(sessionContext, errorStanza);
                    return;
                }
                if (!to.getDomain().equals(serverRuntimeContext.getServerEnitity().getDomain())) {
                    Stanza errorStanza = ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, coreStanza, StanzaErrorType.MODIFY, "Invalid to attribute", null, null);
                    ResponseWriter.writeResponse(sessionContext, errorStanza);
                    return;
                }
                stanza = StanzaBuilder.rewriteNamespace(stanza, "jabber:server", "jabber:client");
            }
        } else {
            List<String> boundResources;
            if (from != null && sessionContext.getInitiatingEntity() != null) {
                Entity fromBare = from.getBareJID();
                Entity initiatingEntity = sessionContext.getInitiatingEntity();
                if (!initiatingEntity.equals(fromBare)) {
                    this.responseWriter.handleWrongFromJID(sessionContext, stanza);
                    return;
                }
            }
            if (from != null && from.getResource() != null && (boundResources = sessionContext.getServerRuntimeContext().getResourceRegistry().getBoundResources(from, false)).size() == 0) {
                this.responseWriter.handleWrongFromJID(sessionContext, stanza);
                return;
            }
            if (from != null && from.getResource() == null && (boundResources = sessionContext.getServerRuntimeContext().getResourceRegistry().getResourcesForSession(sessionContext)).size() > 1) {
                this.responseWriter.handleWrongFromJID(sessionContext, stanza);
                return;
            }
        }
        try {
            stateAwareProtocolWorker.processStanza(sessionContext, sessionStateHolder, stanza, stanzaHandler);
        }
        catch (Exception e) {
            this.logger.error("error executing handler {} with stanza {}", (Object)stanzaHandler.getClass().getName(), (Object)DenseStanzaLogRenderer.render(stanza));
            this.logger.debug("error executing handler exception: ", (Throwable)e);
        }
    }

    public void processTLSEstablished(SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        ProtocolWorker.processTLSEstablishedInternal(sessionContext, sessionStateHolder, this.responseWriter);
    }

    static void processTLSEstablishedInternal(SessionContext sessionContext, SessionStateHolder sessionStateHolder, ResponseWriter responseWriter) {
        if (sessionContext.getState() != SessionState.ENCRYPTION_STARTED) {
            ResponseWriter.handleProtocolError(new TLSException(), sessionContext, null);
            return;
        }
        sessionStateHolder.setState(SessionState.ENCRYPTED);
        sessionContext.setIsReopeningXMLStream();
    }
}

