/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server.s2s;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.failure.RemoteServerNotFoundException;
import org.apache.vysper.xmpp.delivery.failure.RemoteServerTimeoutException;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.s2s.DefaultXMPPServerConnector;
import org.apache.vysper.xmpp.server.s2s.XMPPServerConnector;
import org.apache.vysper.xmpp.server.s2s.XMPPServerConnectorRegistry;

public class DefaultXMPPServerConnectorRegistry
implements XMPPServerConnectorRegistry {
    private ServerRuntimeContext serverRuntimeContext;
    private Map<Entity, DefaultXMPPServerConnector> connectors = new ConcurrentHashMap<Entity, DefaultXMPPServerConnector>();

    public DefaultXMPPServerConnectorRegistry(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public synchronized XMPPServerConnector connect(Entity server) throws RemoteServerNotFoundException, RemoteServerTimeoutException {
        DefaultXMPPServerConnector connector = this.connectors.get(server);
        if (connector != null && connector.isClosed()) {
            this.connectors.remove(server);
            connector = null;
        }
        if (connector == null) {
            connector = new DefaultXMPPServerConnector(server, this.serverRuntimeContext, null, null);
            connector.start();
            this.connectors.put(server, connector);
        }
        return connector;
    }

    public synchronized XMPPServerConnector connectForDialback(Entity server, SessionContext orginalSessionContext, SessionStateHolder originalSessionStateHolder) throws RemoteServerNotFoundException, RemoteServerTimeoutException {
        DefaultXMPPServerConnector connector = new DefaultXMPPServerConnector(server, this.serverRuntimeContext, orginalSessionContext, originalSessionStateHolder);
        connector.start();
        return connector;
    }

    public void close() {
        for (DefaultXMPPServerConnector connector : this.connectors.values()) {
            connector.close();
        }
    }
}

