/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLElementBuilder;
import org.apache.vysper.xml.fragment.XMLFragment;
import org.apache.vysper.xml.fragment.XMLText;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubPrivilege;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubServiceConfiguration;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.AbstractPubSubGeneralHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.CollectionNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LeafNode;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class PubSubPublishHandler
extends AbstractPubSubGeneralHandler {
    public PubSubPublishHandler(PubSubServiceConfiguration serviceConfiguration) {
        super(serviceConfiguration);
    }

    protected String getWorkerElement() {
        return "publish";
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity serverJID = this.serviceConfiguration.getDomainJID();
        CollectionNode root = this.serviceConfiguration.getRootNode();
        Entity sender = PubSubPublishHandler.extractSenderJID((XMPPCoreStanza)stanza, (SessionContext)sessionContext);
        StanzaBuilder sb = StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, (boolean)false, (IQStanzaType)IQStanzaType.RESULT);
        sb.startInnerElement("pubsub", "http://jabber.org/protocol/pubsub");
        XMLElement publish = stanza.getFirstInnerElement().getFirstInnerElement();
        String nodeName = publish.getAttributeValue("node");
        XMLElement item = publish.getFirstInnerElement();
        String strID = item.getAttributeValue("id");
        LeafNode node = root.find(nodeName);
        if (node == null) {
            return this.errorStanzaGenerator.generateNoNodeErrorStanza(sender, serverJID, stanza);
        }
        if (!node.isAuthorized(sender, PubSubPrivilege.PUBLISH)) {
            return this.errorStanzaGenerator.generateInsufficientPrivilegesErrorStanza(sender, serverJID, stanza);
        }
        StanzaRelay relay = serverRuntimeContext.getStanzaRelay();
        XMLElementBuilder eventItemBuilder = new XMLElementBuilder("item", "http://jabber.org/protocol/pubsub#event");
        if (strID == null) {
            strID = this.idGenerator.create();
        }
        eventItemBuilder.addAttribute("id", strID);
        for (XMLFragment fragment : item.getInnerFragments()) {
            if (fragment instanceof XMLElement) {
                eventItemBuilder.addPreparedElement((XMLElement)fragment);
                continue;
            }
            eventItemBuilder.addText(((XMLText)fragment).getText());
        }
        node.publish(sender, relay, strID, eventItemBuilder.build());
        this.buildSuccessStanza(sb, nodeName, strID);
        sb.endInnerElement();
        return new IQStanza((Stanza)sb.build());
    }

    private void buildSuccessStanza(StanzaBuilder sb, String node, String id) {
        sb.startInnerElement("publish", "http://jabber.org/protocol/pubsub");
        sb.addAttribute("node", node);
        sb.startInnerElement("item", "http://jabber.org/protocol/pubsub");
        sb.addAttribute("id", id);
        sb.endInnerElement();
        sb.endInnerElement();
    }
}

