/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.SubscriberVisitor;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberPayloadNotificationVisitor
implements SubscriberVisitor {
    final Logger logger = LoggerFactory.getLogger(SubscriberPayloadNotificationVisitor.class);
    private DeliveryFailureStrategy dfs = new IgnoreFailureStrategy();
    private StanzaRelay stanzaRelay;
    private XMLElement item;
    private Entity serverJID;

    public SubscriberPayloadNotificationVisitor(Entity serverJID, StanzaRelay stanzaRelay, XMLElement item) {
        this.serverJID = serverJID;
        this.stanzaRelay = stanzaRelay;
        this.item = item;
    }

    public void visit(String nodeName, String subscriptionID, Entity subscriber) {
        block2: {
            Stanza event = this.createMessageEventStanza(nodeName, subscriber, "en", this.item);
            try {
                this.stanzaRelay.relay(subscriber, event, this.dfs);
            }
            catch (DeliveryException e1) {
                if (!this.logger.isTraceEnabled()) break block2;
                this.logger.trace("Couldn't deliver message to " + subscriber.getFullQualifiedName(), (Throwable)e1);
            }
        }
    }

    private Stanza createMessageEventStanza(String nodeName, Entity to, String lang, XMLElement item) {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("message", "jabber:client");
        stanzaBuilder.addAttribute("from", this.serverJID.getFullQualifiedName());
        stanzaBuilder.addAttribute("to", to.getFullQualifiedName());
        stanzaBuilder.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", lang);
        stanzaBuilder.startInnerElement("event", "http://jabber.org/protocol/pubsub#event");
        stanzaBuilder.startInnerElement("items", "http://jabber.org/protocol/pubsub#event");
        stanzaBuilder.addAttribute("node", nodeName);
        stanzaBuilder.addPreparedElement(item);
        stanzaBuilder.endInnerElement();
        stanzaBuilder.endInnerElement();
        return (Stanza)stanzaBuilder.build();
    }
}

