/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.roster.handler;

import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.delivery.LocalDeliveryUtils;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.modules.roster.Roster;
import org.apache.vysper.xmpp.modules.roster.RosterBadRequestException;
import org.apache.vysper.xmpp.modules.roster.RosterException;
import org.apache.vysper.xmpp.modules.roster.RosterItem;
import org.apache.vysper.xmpp.modules.roster.RosterNotAcceptableException;
import org.apache.vysper.xmpp.modules.roster.RosterStanzaUtils;
import org.apache.vysper.xmpp.modules.roster.RosterUtils;
import org.apache.vysper.xmpp.modules.roster.SubscriptionType;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManager;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceRegistry;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterIQHandler
extends DefaultIQHandler {
    final Logger logger = LoggerFactory.getLogger(RosterIQHandler.class);

    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "jabber:iq:roster");
    }

    protected boolean verifyInnerElement(Stanza stanza) {
        return this.verifyInnerElementWorker(stanza, "query");
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        ResourceRegistry registry = serverRuntimeContext.getResourceRegistry();
        RosterManager rosterManager = (RosterManager)serverRuntimeContext.getStorageProvider(RosterManager.class);
        if (rosterManager == null) {
            return this.handleCannotRetrieveRoster(stanza, sessionContext);
        }
        Entity from = RosterIQHandler.extractUniqueSenderJID(stanza, sessionContext);
        if (from == null || !from.isResourceSet()) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.UNKNOWN_SENDER, stanza, StanzaErrorType.MODIFY, "sender info insufficient: " + (from == null ? "no from" : from.getFullQualifiedName()), null, null);
        }
        String resourceId = from.getResource();
        ResourceState currentState = registry.getResourceState(resourceId);
        if (currentState != null) {
            registry.setResourceState(resourceId, ResourceState.makeInterested(currentState));
        }
        Roster roster = null;
        try {
            roster = rosterManager.retrieve(from.getBareJID());
            if (roster == null) {
                return this.handleCannotRetrieveRoster(stanza, sessionContext);
            }
        }
        catch (RosterException e) {
            return this.handleCannotRetrieveRoster(stanza, sessionContext);
        }
        StanzaBuilder stanzaBuilder = RosterStanzaUtils.createRosterItemsIQ(from, stanza.getID(), IQStanzaType.RESULT, roster);
        return (Stanza)stanzaBuilder.build();
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        RosterItem existingItem;
        RosterItem setRosterItem;
        RosterManager rosterManager = (RosterManager)serverRuntimeContext.getStorageProvider(RosterManager.class);
        if (rosterManager == null) {
            return this.handleCannotRetrieveRoster(stanza, sessionContext);
        }
        Entity user = RosterIQHandler.extractUniqueSenderJID(stanza, sessionContext);
        if (user == null || !user.isResourceSet()) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.UNKNOWN_SENDER, stanza, StanzaErrorType.MODIFY, "sender info insufficient: " + (user == null ? "no from" : user.getFullQualifiedName()), null, null);
        }
        try {
            setRosterItem = RosterUtils.parseRosterItem(stanza);
        }
        catch (RosterBadRequestException e) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.MODIFY, e.getMessage(), null, null);
        }
        catch (RosterNotAcceptableException e) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.NOT_ACCEPTABLE, stanza, StanzaErrorType.MODIFY, e.getMessage(), null, null);
        }
        Entity contactJid = setRosterItem.getJid().getBareJID();
        try {
            existingItem = rosterManager.getContact(user.getBareJID(), contactJid);
        }
        catch (RosterException e) {
            existingItem = null;
        }
        if (setRosterItem.getSubscriptionType() == SubscriptionType.REMOVE) {
            return this.rosterItemRemove(stanza, sessionContext, rosterManager, user, contactJid, existingItem);
        }
        if (existingItem == null) {
            existingItem = new RosterItem(contactJid, SubscriptionType.NONE);
        }
        if (setRosterItem.getName() != null) {
            existingItem.setName(setRosterItem.getName());
            this.logger.debug(user.getBareJID() + " roster: set roster item name to " + setRosterItem.getName());
        }
        existingItem.setGroups(setRosterItem.getGroups());
        this.logger.debug(user.getBareJID() + " roster: roster item groups set to " + setRosterItem.getGroups());
        try {
            rosterManager.addContact(user.getBareJID(), existingItem);
        }
        catch (RosterException e) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.CANCEL, "roster item contact not (yet) in roster: " + contactJid, null, null);
        }
        this.pushRosterItemToInterestedResources(sessionContext, user, existingItem);
        return RosterStanzaUtils.createRosterItemIQ(user, stanza.getID(), IQStanzaType.RESULT, existingItem);
    }

    private Stanza rosterItemRemove(IQStanza stanza, SessionContext sessionContext, RosterManager rosterManager, Entity user, Entity contactJid, RosterItem existingItem) {
        Stanza unsubscribedStanza = null;
        Stanza unsubscribeStanza = null;
        if (existingItem != null) {
            if (existingItem.hasFrom()) {
                unsubscribedStanza = (Stanza)StanzaBuilder.createPresenceStanza(user.getBareJID(), contactJid, null, PresenceStanzaType.UNSUBSCRIBED, null, null).build();
            }
            if (existingItem.hasTo()) {
                unsubscribeStanza = (Stanza)StanzaBuilder.createPresenceStanza(user.getBareJID(), contactJid, null, PresenceStanzaType.UNSUBSCRIBE, null, null).build();
            }
        }
        try {
            rosterManager.removeContact(user.getBareJID(), contactJid);
        }
        catch (RosterException e) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.ITEM_NOT_FOUND, stanza, StanzaErrorType.CANCEL, "roster item contact not in roster: " + contactJid, null, null);
        }
        if (unsubscribedStanza != null) {
            try {
                sessionContext.getServerRuntimeContext().getStanzaRelay().relay(contactJid, unsubscribedStanza, new IgnoreFailureStrategy());
            }
            catch (DeliveryException e) {
                this.logger.warn("failure sending unsubscribed on roster remove", (Throwable)e);
            }
        }
        if (unsubscribeStanza != null) {
            try {
                sessionContext.getServerRuntimeContext().getStanzaRelay().relay(contactJid, unsubscribeStanza, new IgnoreFailureStrategy());
            }
            catch (DeliveryException e) {
                this.logger.warn("failure sending unsubscribe on roster remove", (Throwable)e);
            }
        }
        this.pushRosterItemToInterestedResources(sessionContext, user, new RosterItem(contactJid, SubscriptionType.REMOVE));
        return (Stanza)StanzaBuilder.createIQStanza(null, user, IQStanzaType.RESULT, stanza.getID()).build();
    }

    private void pushRosterItemToInterestedResources(SessionContext sessionContext, Entity user, RosterItem rosterItem) {
        ResourceRegistry registry = sessionContext.getServerRuntimeContext().getResourceRegistry();
        List<String> resources = registry.getInterestedResources(user.getBareJID());
        for (String resource : resources) {
            EntityImpl userResource = new EntityImpl(user, resource);
            Stanza push = RosterStanzaUtils.createRosterItemPushIQ(userResource, sessionContext.nextSequenceValue(), rosterItem);
            LocalDeliveryUtils.relayToResourceDirectly(registry, resource, push);
        }
    }

    protected Stanza handleCannotRetrieveRoster(IQStanza stanza, SessionContext sessionContext) {
        throw new RuntimeException("gracefully handling roster management problem not implemented");
    }
}

