/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugUtils {
    private static final Log log = LogFactory.getLog((Class)DebugUtils.class);
    private static final HashSet IGNORE_ATTRIBUTES = new HashSet();
    private static final String JSF_COMPONENT_PACKAGE = "javax.faces.component.";
    private static final String MYFACES_COMPONENT_PACKAGE = "org.apache.myfaces.component.";

    private DebugUtils() {
    }

    public static void assertError(boolean condition, Log log_, String msg) throws FacesException {
        if (!condition) {
            log_.error((Object)msg);
            throw new FacesException(msg);
        }
    }

    public static void assertFatal(boolean condition, Log log_, String msg) throws FacesException {
        if (!condition) {
            log_.fatal((Object)msg);
            throw new FacesException(msg);
        }
    }

    public static void traceView(String additionalMsg) {
        if (log.isTraceEnabled()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                log.error((Object)"Cannot not print view to console (no FacesContext).");
                return;
            }
            UIViewRoot viewRoot = facesContext.getViewRoot();
            if (viewRoot == null) {
                log.error((Object)"Cannot not print view to console (no ViewRoot in FacesContext).");
                return;
            }
            DebugUtils.traceView(additionalMsg, viewRoot);
        }
    }

    private static void traceView(String additionalMsg, UIViewRoot viewRoot) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        if (additionalMsg != null) {
            ps.println(additionalMsg);
        }
        ps.println("========================================");
        DebugUtils.printView(viewRoot, ps);
        ps.println("========================================");
        ps.close();
        log.trace((Object)baos.toString());
    }

    public static void printView(UIViewRoot uiViewRoot, PrintStream stream) {
        DebugUtils.printComponent((UIComponent)uiViewRoot, stream, 0, true, null);
    }

    public static void printComponent(UIComponent comp, PrintStream stream) {
        DebugUtils.printComponent(comp, stream, 0, false, null);
    }

    private static void printComponent(UIComponent comp, PrintStream stream, int indent, boolean withChildrenAndFacets, String facetName) {
        ActionListener listener;
        ActionListener[] listeners;
        BeanInfo beanInfo;
        DebugUtils.printIndent(stream, indent);
        stream.print('<');
        String compType = comp.getClass().getName();
        if (compType.startsWith(JSF_COMPONENT_PACKAGE)) {
            compType = compType.substring(JSF_COMPONENT_PACKAGE.length());
        } else if (compType.startsWith(MYFACES_COMPONENT_PACKAGE)) {
            compType = compType.substring(MYFACES_COMPONENT_PACKAGE.length());
        }
        stream.print(compType);
        DebugUtils.printAttribute(stream, "id", comp.getId());
        if (facetName != null) {
            DebugUtils.printAttribute(stream, "facetName", facetName);
        }
        Iterator it = comp.getAttributes().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if ("id".equals(entry.getKey())) continue;
            DebugUtils.printAttribute(stream, (String)entry.getKey(), entry.getValue());
        }
        try {
            beanInfo = Introspector.getBeanInfo(comp.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        PropertyDescriptor[] propDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propDescriptors.length; ++i) {
            String name;
            if (propDescriptors[i].getReadMethod() == null || "id".equals(name = propDescriptors[i].getName())) continue;
            ValueBinding vb = comp.getValueBinding(name);
            if (vb != null) {
                DebugUtils.printAttribute(stream, name, vb.getExpressionString());
                continue;
            }
            if (name.equals("value") && comp instanceof ValueHolder || IGNORE_ATTRIBUTES.contains(name)) continue;
            try {
                Object value = comp.getAttributes().get(name);
                DebugUtils.printAttribute(stream, name, value);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
                DebugUtils.printAttribute(stream, name, null);
            }
        }
        boolean mustClose = true;
        boolean nestedObjects = false;
        if (comp instanceof UICommand && (listeners = ((UICommand)comp).getActionListeners()) != null && listeners.length > 0) {
            nestedObjects = true;
            stream.println('>');
            mustClose = false;
            for (int i = 0; i < listeners.length; ++i) {
                listener = listeners[i];
                DebugUtils.printIndent(stream, indent + 1);
                stream.print('<');
                stream.print(listener.getClass().getName());
                stream.println("/>");
            }
        }
        if (comp instanceof UIInput) {
            Validator[] validators;
            listeners = ((UIInput)comp).getValueChangeListeners();
            if (listeners != null && listeners.length > 0) {
                nestedObjects = true;
                stream.println('>');
                mustClose = false;
                for (int i = 0; i < listeners.length; ++i) {
                    listener = listeners[i];
                    DebugUtils.printIndent(stream, indent + 1);
                    stream.print('<');
                    stream.print(listener.getClass().getName());
                    stream.println("/>");
                }
            }
            if ((validators = ((UIInput)comp).getValidators()) != null && validators.length > 0) {
                nestedObjects = true;
                stream.println('>');
                mustClose = false;
                for (int i = 0; i < validators.length; ++i) {
                    Validator validator = validators[i];
                    DebugUtils.printIndent(stream, indent + 1);
                    stream.print('<');
                    stream.print(validator.getClass().getName());
                    stream.println("/>");
                }
            }
        }
        if (withChildrenAndFacets) {
            int childCount = comp.getChildCount();
            Map facetsMap = comp.getFacets();
            if (childCount > 0 || !facetsMap.isEmpty()) {
                nestedObjects = true;
                if (mustClose) {
                    stream.println('>');
                    mustClose = false;
                }
                if (childCount > 0) {
                    Iterator it2 = comp.getChildren().iterator();
                    while (it2.hasNext()) {
                        UIComponent child = (UIComponent)it2.next();
                        DebugUtils.printComponent(child, stream, indent + 1, true, null);
                    }
                }
                Iterator it3 = facetsMap.entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry entry = it3.next();
                    DebugUtils.printComponent((UIComponent)entry.getValue(), stream, indent + 1, true, (String)entry.getKey());
                }
            }
        }
        if (nestedObjects) {
            if (mustClose) {
                stream.println("/>");
            } else {
                DebugUtils.printIndent(stream, indent);
                stream.print("</");
                stream.print(compType);
                stream.println('>');
            }
        } else {
            stream.println("/>");
        }
    }

    private static void printAttribute(PrintStream stream, String name, Object value) {
        if (IGNORE_ATTRIBUTES.contains(name)) {
            return;
        }
        if (name.startsWith("javax.faces.webapp.UIComponentTag.")) {
            name = name.substring("javax.faces.webapp.UIComponentTag.".length());
        }
        stream.print(' ');
        stream.print(name.toString());
        stream.print("=\"");
        if (value != null) {
            if (value instanceof UIComponent) {
                stream.print("[id:");
                stream.print(((UIComponent)value).getId());
                stream.print(']');
            } else if (value instanceof MethodBinding) {
                stream.print(((MethodBinding)value).getExpressionString());
            } else {
                stream.print(value.toString());
            }
        } else {
            stream.print("NULL");
        }
        stream.print('\"');
    }

    private static void printIndent(PrintStream stream, int depth) {
        for (int i = 0; i < depth; ++i) {
            stream.print("  ");
        }
    }

    public static String componentAsString(UIComponent comp) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DebugUtils.printComponent(comp, new PrintStream(baos));
            baos.close();
            return baos.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        IGNORE_ATTRIBUTES.add("attributes");
        IGNORE_ATTRIBUTES.add("children");
        IGNORE_ATTRIBUTES.add("childCount");
        IGNORE_ATTRIBUTES.add("class");
        IGNORE_ATTRIBUTES.add("facets");
        IGNORE_ATTRIBUTES.add("facetsAndChildren");
        IGNORE_ATTRIBUTES.add("parent");
        IGNORE_ATTRIBUTES.add("actionListeners");
        IGNORE_ATTRIBUTES.add("valueChangeListeners");
        IGNORE_ATTRIBUTES.add("validators");
        IGNORE_ATTRIBUTES.add("rowData");
        IGNORE_ATTRIBUTES.add("javax.faces.webapp.COMPONENT_IDS");
        IGNORE_ATTRIBUTES.add("javax.faces.webapp.FACET_NAMES");
        IGNORE_ATTRIBUTES.add("javax.faces.webapp.CURRENT_VIEW_ROOT");
    }
}

