/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ResourceVisitOption;
import org.apache.myfaces.resource.ClassLoaderResourceLoader;
import org.apache.myfaces.resource.ResourceLoaderUtils;
import org.apache.myfaces.util.lang.ClassUtils;

public class ClassLoaderResourceLoaderIterator
implements Iterator<String> {
    private Iterator<String> delegate = null;

    public ClassLoaderResourceLoaderIterator(URL url, String basePath, int maxDepth, ResourceVisitOption ... options) {
        if (url == null) {
            this.delegate = null;
        } else if (url.getProtocol().equals("file")) {
            try {
                File directory = new File(url.toURI());
                this.delegate = new FileDepthIterator(directory, basePath, maxDepth, options);
            }
            catch (URISyntaxException e) {
                Logger log = Logger.getLogger(ClassLoaderResourceLoader.class.getName());
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, "url " + url.toString() + " cannot be translated to uri: " + e.getMessage(), e);
                }
            }
        } else if (ClassLoaderResourceLoaderIterator.isJarResourceProtocol(url.getProtocol()) && (url = this.getClassLoader().getResource(basePath)) != null) {
            this.delegate = new JarDepthIterator(url, basePath, maxDepth, options);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.delegate != null) {
            return this.delegate.hasNext();
        }
        return false;
    }

    @Override
    public String next() {
        if (this.delegate != null) {
            return this.delegate.next();
        }
        return null;
    }

    @Override
    public void remove() {
    }

    protected ClassLoader getClassLoader() {
        return ClassUtils.getContextClassLoader();
    }

    private static boolean isJarResourceProtocol(String protocol) {
        return "jar".equals(protocol) || "wsjar".equals(protocol) || "zip".equals(protocol);
    }

    private static class FileDepthIterator
    implements Iterator<String> {
        private File directory;
        private String basePath;
        private int maxDepth;
        private ResourceVisitOption[] options;
        private Deque<File> stack;
        private String basePathName;

        public FileDepthIterator(File directory, String basePath, int maxDepth, ResourceVisitOption ... options) {
            this.directory = directory;
            this.basePath = basePath;
            this.maxDepth = maxDepth;
            this.options = options;
            File[] list = this.directory.listFiles();
            if (list != null && list.length > 0) {
                this.stack = new LinkedList<File>();
                Collections.addAll(this.stack, list);
            }
            this.basePathName = this.directory.getPath().replace(File.separatorChar, '/');
        }

        @Override
        public boolean hasNext() {
            if (this.stack == null || this.stack.isEmpty()) {
                return false;
            }
            File file = this.stack.peek();
            do {
                if (!file.isDirectory()) continue;
                file = this.stack.pop();
                int depth = ResourceLoaderUtils.getDepth(this.calculatePath(file));
                if (depth < this.maxDepth) {
                    File[] list = file.listFiles();
                    this.stack.addAll(Arrays.asList(list));
                }
                file = !this.stack.isEmpty() ? this.stack.peek() : null;
            } while (file != null && file.isDirectory() && !this.stack.isEmpty());
            return !this.stack.isEmpty();
        }

        @Override
        public String next() {
            if (this.stack == null || this.stack.isEmpty()) {
                return null;
            }
            File file = this.stack.pop();
            do {
                if (!file.isDirectory()) continue;
                int depth = ResourceLoaderUtils.getDepth(this.calculatePath(file));
                if (depth < this.maxDepth) {
                    File[] list = file.listFiles();
                    this.stack.addAll(Arrays.asList(list));
                }
                file = !this.stack.isEmpty() ? this.stack.pop() : null;
            } while (file != null && file.isDirectory() && !this.stack.isEmpty());
            if (file != null) {
                String path = this.calculatePath(file);
                return path;
            }
            return null;
        }

        private String calculatePath(File file) {
            return file.getPath().substring(this.basePathName.length()).replace(File.separatorChar, '/');
        }

        @Override
        public void remove() {
        }
    }

    private static class JarDepthIterator
    implements Iterator<String> {
        private URL directory;
        private String basePath;
        private int maxDepth;
        private ResourceVisitOption[] options;
        private Deque<String> stack;
        Iterator<String> iterator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JarDepthIterator(URL directory, String basePath, int maxDepth, ResourceVisitOption ... options) {
            block12: {
                this.stack = new LinkedList<String>();
                this.iterator = null;
                this.directory = directory;
                this.basePath = basePath;
                this.maxDepth = maxDepth;
                this.options = options;
                if (basePath.endsWith("/")) {
                    basePath = basePath.substring(0, basePath.length() - 1);
                }
                try {
                    JarURLConnection conn = (JarURLConnection)directory.openConnection();
                    conn.setUseCaches(false);
                    try {
                        if (conn.getJarEntry().isDirectory()) {
                            JarFile file = conn.getJarFile();
                            Enumeration<JarEntry> en = file.entries();
                            while (en.hasMoreElements()) {
                                int depth;
                                String path;
                                JarEntry entry = en.nextElement();
                                String entryName = entry.getName();
                                if (!entryName.startsWith(basePath + '/') || entryName.length() == basePath.length() + 1 || (path = entryName.substring(basePath.length(), entryName.length())).endsWith("/") || (depth = ResourceLoaderUtils.getDepth(path)) >= maxDepth) continue;
                                this.stack.add(path);
                            }
                        }
                    }
                    finally {
                        try {
                            conn.getInputStream().close();
                        }
                        catch (Exception file) {}
                    }
                }
                catch (IOException e) {
                    Logger log = Logger.getLogger(ClassLoaderResourceLoader.class.getName());
                    if (!log.isLoggable(Level.WARNING)) break block12;
                    log.log(Level.WARNING, "IOException when scanning for resource in jar file:", e);
                }
            }
            this.iterator = this.stack.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
        }
    }
}

