/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.ClientWindow;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewMetadata;
import org.apache.myfaces.component.visit.MyFacesVisitHints;
import org.apache.myfaces.context.PartialResponseWriterImpl;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.renderkit.html.HtmlResponseStateManager;
import org.apache.myfaces.util.lang.StringUtils;

public class PartialViewContextImpl
extends PartialViewContext {
    private static final Logger log = Logger.getLogger(PartialViewContextImpl.class.getName());
    private static final String FACES_REQUEST = "Faces-Request";
    private static final String PARTIAL_AJAX = "partial/ajax";
    private static final String PARTIAL_AJAX_REQ = "javax.faces.partial.ajax";
    private static final String PARTIAL_PROCESS = "partial/process";
    private static final Set<VisitHint> PARTIAL_EXECUTE_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.EXECUTE_LIFECYCLE, VisitHint.SKIP_UNRENDERED));
    private FacesContext context = null;
    private boolean _released = false;
    private Boolean _ajaxRequest = null;
    private Collection<String> _executeClientIds = null;
    private Collection<String> _renderClientIds = null;
    private Boolean _partialRequest = null;
    private Boolean _renderAll = null;
    private PartialResponseWriter _partialResponseWriter = null;
    private VisitContextFactory visitContextFactory = null;
    private Boolean _resetValues = null;
    private List<String> _evalScripts = new ArrayList<String>();

    public PartialViewContextImpl(FacesContext context) {
        this.context = context;
    }

    public PartialViewContextImpl(FacesContext context, VisitContextFactory visitContextFactory) {
        this.context = context;
        this.visitContextFactory = visitContextFactory;
    }

    @Override
    public boolean isAjaxRequest() {
        this.assertNotReleased();
        if (this._ajaxRequest == null) {
            String requestType = this.context.getExternalContext().getRequestHeaderMap().get(FACES_REQUEST);
            this._ajaxRequest = requestType != null && PARTIAL_AJAX.equals(requestType);
            String reqParmamterPartialAjax = this.context.getExternalContext().getRequestParameterMap().get(PARTIAL_AJAX_REQ);
            this._ajaxRequest = this._ajaxRequest != false || reqParmamterPartialAjax != null;
        }
        return this._ajaxRequest;
    }

    @Override
    public boolean isExecuteAll() {
        String executeMode;
        this.assertNotReleased();
        return this.isAjaxRequest() && "@all".equals(executeMode = this.context.getExternalContext().getRequestParameterMap().get("javax.faces.partial.execute"));
    }

    @Override
    public boolean isPartialRequest() {
        this.assertNotReleased();
        if (this._partialRequest == null) {
            String requestType = this.context.getExternalContext().getRequestHeaderMap().get(FACES_REQUEST);
            this._partialRequest = requestType != null && PARTIAL_PROCESS.equals(requestType);
        }
        return this._partialRequest != false || this.isAjaxRequest();
    }

    @Override
    public boolean isRenderAll() {
        this.assertNotReleased();
        if (this._renderAll == null) {
            String executeMode;
            if (this.isAjaxRequest() && "@all".equals(executeMode = this.context.getExternalContext().getRequestParameterMap().get("javax.faces.partial.render"))) {
                this._renderAll = true;
            }
            if (this._renderAll == null) {
                this._renderAll = false;
            }
        }
        return this._renderAll;
    }

    @Override
    public void setPartialRequest(boolean isPartialRequest) {
        this.assertNotReleased();
        this._partialRequest = isPartialRequest;
    }

    @Override
    public void setRenderAll(boolean renderAll) {
        this.assertNotReleased();
        this._renderAll = renderAll;
    }

    @Override
    public Collection<String> getExecuteIds() {
        this.assertNotReleased();
        if (this._executeClientIds == null) {
            String executeMode = this.context.getExternalContext().getRequestParameterMap().get("javax.faces.partial.execute");
            if (executeMode != null && !executeMode.isEmpty() && !"@all".equals(executeMode)) {
                String[] clientIds = StringUtils.splitShortString(this._replaceTabOrEnterCharactersWithSpaces(executeMode), ' ');
                ArrayList<String> tempList = new ArrayList<String>(clientIds.length);
                for (String clientId : clientIds) {
                    if (clientId.length() <= 0) continue;
                    tempList.add(clientId);
                }
                String source = this.context.getExternalContext().getRequestParameterMap().get("javax.faces.source");
                if (source != null && !tempList.contains(source = source.trim())) {
                    tempList.add(source);
                }
                this._executeClientIds = tempList;
            } else {
                this._executeClientIds = new ArrayList<String>(5);
            }
        }
        return this._executeClientIds;
    }

    private String _replaceTabOrEnterCharactersWithSpaces(String mode) {
        if (mode == null) {
            return null;
        }
        char[] escaped = null;
        int modeLength = mode.length();
        for (int i = 0; i < modeLength; ++i) {
            char c = mode.charAt(i);
            if (c != '\t' && c != '\n') continue;
            if (escaped == null) {
                escaped = mode.toCharArray();
            }
            escaped[i] = 32;
        }
        if (escaped != null) {
            return String.valueOf(escaped);
        }
        return mode;
    }

    @Override
    public Collection<String> getRenderIds() {
        this.assertNotReleased();
        if (this._renderClientIds == null) {
            String renderMode = this.context.getExternalContext().getRequestParameterMap().get("javax.faces.partial.render");
            if (renderMode != null && !renderMode.isEmpty() && !"@all".equals(renderMode)) {
                String[] clientIds = StringUtils.splitShortString(this._replaceTabOrEnterCharactersWithSpaces(renderMode), ' ');
                ArrayList<String> tempList = new ArrayList<String>(clientIds.length);
                for (String clientId : clientIds) {
                    if (clientId.length() <= 0) continue;
                    tempList.add(clientId);
                }
                this._renderClientIds = tempList;
            } else {
                this._renderClientIds = new ArrayList<String>(5);
                if ("@all".equals(renderMode)) {
                    this._renderClientIds.add("javax.faces.ViewRoot");
                }
            }
        }
        return this._renderClientIds;
    }

    @Override
    public PartialResponseWriter getPartialResponseWriter() {
        this.assertNotReleased();
        if (this._partialResponseWriter == null) {
            ResponseWriter responseWriter = this.context.getResponseWriter();
            if (responseWriter == null) {
                try {
                    RenderKit renderKit = this.context.getRenderKit();
                    if (renderKit == null) {
                        String renderKitId = this.context.getApplication().getViewHandler().calculateRenderKitId(this.context);
                        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
                        renderKit = rkf.getRenderKit(this.context, renderKitId);
                    }
                    responseWriter = renderKit.createResponseWriter(this.context.getExternalContext().getResponseOutputWriter(), "text/xml", this.context.getExternalContext().getRequestCharacterEncoding());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot create Partial Response Writer", e);
                }
            }
            this._partialResponseWriter = responseWriter instanceof PartialResponseWriter ? (PartialResponseWriter)responseWriter : new PartialResponseWriterImpl(responseWriter);
        }
        return this._partialResponseWriter;
    }

    @Override
    public List<String> getEvalScripts() {
        return this._evalScripts;
    }

    @Override
    public void processPartial(PhaseId phaseId) {
        this.assertNotReleased();
        UIViewRoot viewRoot = this.context.getViewRoot();
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES || phaseId == PhaseId.PROCESS_VALIDATIONS || phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            this.processPartialExecute(viewRoot, phaseId);
        } else if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.processPartialRendering(viewRoot, phaseId);
        }
    }

    private void processPartialExecute(UIViewRoot viewRoot, PhaseId phaseId) {
        PartialViewContext pvc = this.context.getPartialViewContext();
        Collection<String> executeIds = pvc.getExecuteIds();
        if (executeIds == null || executeIds.isEmpty()) {
            return;
        }
        VisitContext visitCtx = this.getVisitContextFactory().getVisitContext(this.context, executeIds, PARTIAL_EXECUTE_HINTS);
        viewRoot.visitTree(visitCtx, new PhaseAwareVisitCallback(this.context, phaseId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPartialRendering(UIViewRoot viewRoot, PhaseId phaseId) {
        PartialResponseWriter writer = this.context.getPartialViewContext().getPartialResponseWriter();
        PartialViewContext pvc = this.context.getPartialViewContext();
        ResponseWriter oldWriter = this.context.getResponseWriter();
        boolean inDocument = false;
        ExternalContext externalContext = this.context.getExternalContext();
        externalContext.setResponseContentType("text/xml");
        externalContext.addResponseHeader("Pragma", "no-cache");
        externalContext.addResponseHeader("Cache-control", "no-cache");
        externalContext.addResponseHeader("Expires", "-1");
        try {
            String viewState;
            String currentEncoding = writer.getCharacterEncoding();
            writer.startDocument();
            writer.writeAttribute("id", viewRoot.getContainerClientId(this.context), "id");
            inDocument = true;
            this.context.setResponseWriter(writer);
            if (this.isResetValues()) {
                viewRoot.resetValues(this.context, this.getRenderIds());
            }
            if (pvc.isRenderAll()) {
                this.processRenderAll(viewRoot, writer);
            } else {
                Object rvc;
                ArrayList<UIComponent> updatedComponents;
                Collection<String> renderIds = pvc.getRenderIds();
                if (renderIds != null && !renderIds.isEmpty()) {
                    if (renderIds.contains("javax.faces.ViewRoot")) {
                        this.processRenderAll(viewRoot, writer);
                    } else {
                        updatedComponents = new ArrayList();
                        rvc = RequestViewContext.getCurrentInstance(this.context);
                        this.processRenderResource(this.context, writer, (RequestViewContext)rvc, updatedComponents, "head");
                        this.processRenderResource(this.context, writer, (RequestViewContext)rvc, updatedComponents, "body");
                        this.processRenderResource(this.context, writer, (RequestViewContext)rvc, updatedComponents, "form");
                        VisitContext visitCtx = this.getVisitContextFactory().getVisitContext(this.context, renderIds, MyFacesVisitHints.SET_SKIP_UNRENDERED);
                        viewRoot.visitTree(visitCtx, new PhaseAwareVisitCallback(this.context, phaseId, updatedComponents));
                    }
                } else {
                    updatedComponents = new ArrayList<UIComponent>();
                    rvc = RequestViewContext.getCurrentInstance(this.context);
                    this.processRenderResource(this.context, writer, (RequestViewContext)rvc, updatedComponents, "head");
                    this.processRenderResource(this.context, writer, (RequestViewContext)rvc, updatedComponents, "body");
                    this.processRenderResource(this.context, writer, (RequestViewContext)rvc, updatedComponents, "form");
                }
                List<String> evalScripts = pvc.getEvalScripts();
                if (evalScripts != null && evalScripts.size() > 0) {
                    rvc = evalScripts.iterator();
                    while (rvc.hasNext()) {
                        String script = (String)rvc.next();
                        writer.startEval();
                        writer.write(script);
                        writer.endEval();
                    }
                }
            }
            Collection<UIViewParameter> viewParams = ViewMetadata.getViewParameters(viewRoot);
            if (!viewParams.isEmpty()) {
                for (UIViewParameter param : viewParams) {
                    param.encodeAll(this.context);
                }
            }
            if ((viewState = this.context.getApplication().getStateManager().getViewState(this.context)) != null) {
                writer.startUpdate(HtmlResponseStateManager.generateUpdateViewStateId(this.context));
                writer.write(viewState);
                writer.endUpdate();
            } else if (viewRoot.isTransient()) {
                writer.startUpdate(HtmlResponseStateManager.generateUpdateViewStateId(this.context));
                writer.write("stateless");
                writer.endUpdate();
            }
            ClientWindow cw = this.context.getExternalContext().getClientWindow();
            if (cw != null) {
                writer.startUpdate(HtmlResponseStateManager.generateUpdateClientWindowId(this.context));
                writer.writeText(cw.getId(), null);
                writer.endUpdate();
            }
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "", ex);
            }
        }
        finally {
            block29: {
                try {
                    if (inDocument) {
                        writer.endDocument();
                    }
                    writer.flush();
                }
                catch (IOException ex) {
                    if (!log.isLoggable(Level.SEVERE)) break block29;
                    log.log(Level.SEVERE, "", ex);
                }
            }
            this.context.setResponseWriter(oldWriter);
        }
    }

    private void processRenderResource(FacesContext facesContext, PartialResponseWriter writer, RequestViewContext rvc, List<UIComponent> updatedComponents, String target) throws IOException {
        List<UIComponent> list;
        if (rvc.isRenderTarget(target) && (list = rvc.getRenderTargetComponentList(target)) != null && !list.isEmpty()) {
            writer.startUpdate("javax.faces.Resource");
            for (UIComponent component : list) {
                boolean resourceRendered = false;
                if ("javax.faces.resource.Script".equals(component.getRendererType()) || "javax.faces.resource.Stylesheet".equals(component.getRendererType())) {
                    String resourceName = (String)component.getAttributes().get("name");
                    String libraryName = (String)component.getAttributes().get("library");
                    if (resourceName == null || resourceName.isEmpty()) {
                        component.encodeAll(facesContext);
                        continue;
                    }
                    int index = resourceName.indexOf(63);
                    if (index >= 0) {
                        resourceName = resourceName.substring(0, index);
                    }
                    if (!this.context.getApplication().getResourceHandler().isResourceRendered(this.context, resourceName, libraryName)) {
                        component.encodeAll(facesContext);
                    }
                } else {
                    component.encodeAll(facesContext);
                }
                if (resourceRendered) continue;
                if (updatedComponents == null) {
                    updatedComponents = new ArrayList<UIComponent>();
                }
                updatedComponents.add(component);
            }
            writer.endUpdate();
        }
    }

    private void processRenderAll(UIViewRoot viewRoot, PartialResponseWriter writer) throws IOException {
        Map map = (Map)viewRoot.getTransientStateHelper().getTransient("org.apache.myfaces.RENDERED_RESOURCES_SET");
        if (map != null) {
            map.clear();
        }
        writer.startUpdate("javax.faces.ViewRoot");
        int childCount = viewRoot.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent comp = viewRoot.getChildren().get(i);
            comp.encodeAll(this.context);
        }
        writer.endUpdate();
    }

    private void assertNotReleased() {
        if (this._released) {
            throw new IllegalStateException("Error the FacesContext is already released!");
        }
    }

    @Override
    public void release() {
        this.assertNotReleased();
        this.visitContextFactory = null;
        this._executeClientIds = null;
        this._renderClientIds = null;
        this._ajaxRequest = null;
        this._partialRequest = null;
        this._renderAll = null;
        this.context = null;
        this._released = true;
    }

    private VisitContextFactory getVisitContextFactory() {
        if (this.visitContextFactory == null) {
            this.visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory("javax.faces.component.visit.VisitContextFactory");
        }
        return this.visitContextFactory;
    }

    @Override
    public boolean isResetValues() {
        if (this._resetValues == null) {
            String value = this.context.getExternalContext().getRequestParameterMap().get("javax.faces.partial.resetValues");
            this._resetValues = "true".equals(value);
        }
        return this._resetValues;
    }

    private class PhaseAwareVisitCallback
    implements VisitCallback {
        private PhaseId _phaseId;
        private FacesContext _facesContext;
        private List<UIComponent> _alreadyUpdatedComponents;

        public PhaseAwareVisitCallback(FacesContext facesContext, PhaseId phaseId) {
            this._phaseId = phaseId;
            this._facesContext = facesContext;
            this._alreadyUpdatedComponents = null;
        }

        public PhaseAwareVisitCallback(FacesContext facesContext, PhaseId phaseId, List<UIComponent> alreadyUpdatedComponents) {
            this._phaseId = phaseId;
            this._facesContext = facesContext;
            this._alreadyUpdatedComponents = alreadyUpdatedComponents;
        }

        @Override
        public VisitResult visit(VisitContext context, UIComponent target) {
            if (this._phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                target.processDecodes(this._facesContext);
            } else if (this._phaseId == PhaseId.PROCESS_VALIDATIONS) {
                target.processValidators(this._facesContext);
            } else if (this._phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                target.processUpdates(this._facesContext);
            } else if (this._phaseId == PhaseId.RENDER_RESPONSE) {
                this.processRenderComponent(target);
            } else {
                throw new IllegalStateException("PPR Response, illegale phase called");
            }
            return VisitResult.REJECT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRenderComponent(UIComponent target) {
            boolean inUpdate = false;
            PartialResponseWriter writer = (PartialResponseWriter)this._facesContext.getResponseWriter();
            if (this._alreadyUpdatedComponents != null) {
                for (UIComponent parent = target; parent != null; parent = parent.getParent()) {
                    if (!this._alreadyUpdatedComponents.contains(parent)) continue;
                    return;
                }
            }
            try {
                writer.startUpdate(target.getClientId(this._facesContext));
                inUpdate = true;
                target.encodeAll(this._facesContext);
            }
            catch (IOException ex) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, "IOException for rendering component", ex);
                }
            }
            finally {
                block16: {
                    if (inUpdate) {
                        try {
                            writer.endUpdate();
                        }
                        catch (IOException ex) {
                            if (!log.isLoggable(Level.SEVERE)) break block16;
                            log.log(Level.SEVERE, "IOException for rendering component, stopping update rendering", ex);
                        }
                    }
                }
            }
        }
    }
}

