/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.scope;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.context.FacesContext;
import org.apache.myfaces.cdi.scope.ViewTransientScopeBeanHolder;
import org.apache.myfaces.cdi.scope.ViewTransientScoped;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;

@Typed
public class ViewTransientScopedContextImpl
implements Context {
    private BeanManager beanManager;

    public ViewTransientScopedContextImpl(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    protected ViewTransientScopeBeanHolder getViewTransientScopeBeanHolder() {
        return this.getViewTransientScopeBeanHolder(FacesContext.getCurrentInstance());
    }

    protected ViewTransientScopeBeanHolder getViewTransientScopeBeanHolder(FacesContext facesContext) {
        return new ViewTransientScopeBeanHolder();
    }

    protected ContextualStorage getContextualStorage(boolean createIfNotExist, FacesContext facesContext) {
        if (facesContext == null) {
            throw new ContextNotActiveException("FacesScopedContextImpl: no current active facesContext");
        }
        if (createIfNotExist) {
            this.getViewTransientScopeBeanHolder(facesContext);
            return ViewTransientScopeBeanHolder.getContextualStorage(this.beanManager, facesContext);
        }
        return this.getViewTransientScopeBeanHolder(facesContext).getContextualStorageNoCreate(this.beanManager, facesContext);
    }

    public Class<? extends Annotation> getScope() {
        return ViewTransientScoped.class;
    }

    public boolean isActive() {
        return this.isActive(FacesContext.getCurrentInstance());
    }

    public boolean isActive(FacesContext facesContext) {
        if (facesContext == null) {
            return false;
        }
        return facesContext.getViewRoot() != null;
    }

    public <T> T get(Contextual<T> bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (facesContext != null) {
            Map<Object, ContextualInstanceInfo<?>> contextMap;
            ContextualInstanceInfo<?> contextualInstanceInfo;
            ContextualStorage storage = this.getContextualStorage(false, facesContext);
            if (storage != null && (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) != null) {
                return (T)contextualInstanceInfo.getContextualInstance();
            }
        } else {
            throw new IllegalStateException("FacesContext cannot be found when resolving bean " + bean.toString());
        }
        return null;
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (!(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(bean.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        ContextualStorage storage = this.getContextualStorage(true, facesContext);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    public boolean destroy(Contextual bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ContextualStorage storage = this.getContextualStorage(false, facesContext);
        if (storage == null) {
            return false;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return false;
        }
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        return true;
    }

    public static void destroyAllActive(ContextualStorage storage) {
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
            if ("oam.VIEW_TRANSIENT_SCOPE_MAP_INFO".equals(entry.getKey())) continue;
            Contextual<?> bean = storage.getBean(entry.getKey());
            ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
            bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        }
    }

    protected void checkActive(FacesContext facesContext) {
        if (!this.isActive(facesContext)) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }
}

