/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.validator;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.faces.FacesWrapper;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import java.lang.reflect.Type;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.validator.FacesValidatorAnnotationLiteral;

public class FacesValidatorCDIWrapper
implements PartialStateHolder,
Validator,
FacesWrapper<Validator> {
    private transient Validator delegate;
    private String validatorId;
    private boolean _transient;
    private static final Type VALIDATOR_TYPE = new TypeLiteral<Validator<?>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private boolean _initialStateMarked = false;

    public FacesValidatorCDIWrapper() {
    }

    public FacesValidatorCDIWrapper(Class<? extends Validator> validatorClass, String validatorId) {
        this.validatorId = validatorId;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        this.getWrapped().validate(context, component, value);
    }

    @Override
    public Validator getWrapped() {
        if (this.delegate == null) {
            BeanManager beanManager = CDIUtils.getBeanManager(FacesContext.getCurrentInstance().getExternalContext());
            FacesValidatorAnnotationLiteral qualifier = new FacesValidatorAnnotationLiteral(this.validatorId, false, true);
            this.delegate = (Validator)CDIUtils.getInstance(beanManager, VALIDATOR_TYPE, true, qualifier);
            if (this.delegate == null) {
                this.delegate = CDIUtils.getInstance(beanManager, Validator.class, true, qualifier);
            }
        }
        return this.delegate;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.validatorId};
            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this.validatorId = (String)values[0];
        }
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

