/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.flash;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.Flash;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PostKeepFlashValueEvent;
import jakarta.faces.event.PostPutFlashValueEvent;
import jakarta.faces.event.PreClearFlashEvent;
import jakarta.faces.event.PreRemoveFlashValueEvent;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.context.flash.FlashClientWindowTokenCollection;
import org.apache.myfaces.context.flash.FlashScopeDisabledException;
import org.apache.myfaces.context.flash.ReleasableFlash;
import org.apache.myfaces.util.ExternalContextUtils;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.util.lang.SubKeyMap;
import org.apache.myfaces.util.token.TokenGenerator;

public class FlashImpl
extends Flash
implements ReleasableFlash {
    private static final Logger log = Logger.getLogger(FlashImpl.class.getName());
    private static final String FLASH_PREFIX = "oam.Flash";
    static final String FLASH_INSTANCE = "oam.Flash.INSTANCE";
    static final String FLASH_REDIRECT = "oam.Flash.REDIRECT";
    public static final String FLASH_PREVIOUS_REQUEST_REDIRECT = "oam.Flash.REDIRECT.PREVIOUSREQUEST";
    static final String FLASH_KEEP_MESSAGES = "oam.Flash.KEEP_MESSAGES";
    static final String FLASH_KEEP_MESSAGES_LIST = "KEEPMESSAGESLIST";
    static final String FLASH_SESSION_MAP_SUBKEY_PREFIX = "oam.Flash.SCOPE";
    static final String FLASH_RENDER_MAP = "oam.Flash.RENDERMAP";
    static final String FLASH_RENDER_MAP_TOKEN = "oam.Flash.RENDERMAP.TOKEN";
    static final String FLASH_EXECUTE_MAP = "oam.Flash.EXECUTEMAP";
    static final String FLASH_EXECUTE_MAP_TOKEN = "oam.Flash.EXECUTEMAP.TOKEN";
    static final String FLASH_CW_LRU_MAP = "oam.Flash.CW.LRUMAP";
    static final char SEPARATOR_CHAR = '.';
    private boolean _flashScopeDisabled;
    private boolean _clientWindowUrlModeEnabled;

    public static Flash getCurrentInstance(ExternalContext context) {
        return FlashImpl.getCurrentInstance(context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Flash getCurrentInstance(ExternalContext context, boolean create) {
        Map applicationMap = context.getApplicationMap();
        Flash flash = (Flash)applicationMap.get(FLASH_INSTANCE);
        if (flash == null && create) {
            Map map = applicationMap;
            synchronized (map) {
                flash = (Flash)applicationMap.get(FLASH_INSTANCE);
                if (flash == null) {
                    flash = new FlashImpl(context);
                    applicationMap.put(FLASH_INSTANCE, flash);
                }
            }
        }
        return flash;
    }

    public FlashImpl(ExternalContext externalContext) {
        this._flashScopeDisabled = MyfacesConfig.getCurrentInstance(externalContext).isFlashScopeDisabled();
        this._clientWindowUrlModeEnabled = FacesConfigurator.isUrlWindowMode(externalContext);
    }

    public void doPrePhaseActions(FacesContext facesContext) {
        PhaseId currentPhaseId;
        if (!this._flashScopeDisabled && PhaseId.RESTORE_VIEW.equals(currentPhaseId = facesContext.getCurrentPhaseId())) {
            this._restoreRedirectValue(facesContext);
            this._manageFlashMapTokens(facesContext);
            this._restoreMessages(facesContext);
        }
    }

    public void doPostPhaseActions(FacesContext facesContext) {
        if (!this._flashScopeDisabled && this._isLastPhaseInRequest(facesContext)) {
            if (this._isRedirectTrueOnThisRequest(facesContext)) {
                Map<String, Object> renderMap = this._getRenderFlashMap(facesContext);
                for (Map.Entry<String, Object> entry : this._getExecuteFlashMap(facesContext).entrySet()) {
                    if (renderMap.containsKey(entry.getKey())) continue;
                    renderMap.put(entry.getKey(), entry.getValue());
                }
            }
            this._clearExecuteFlashMap(facesContext);
            this._saveMessages(facesContext);
            this._clearRenderFlashTokenIfMapEmpty(facesContext);
        }
    }

    public boolean isRedirect() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        boolean thisRedirect = this._isRedirectTrueOnThisRequest(facesContext);
        boolean prevRedirect = this._isRedirectTrueOnPreviousRequest(facesContext);
        boolean executePhase = !PhaseId.RENDER_RESPONSE.equals(facesContext.getCurrentPhaseId());
        return thisRedirect || executePhase && prevRedirect;
    }

    public void setRedirect(boolean redirect) {
        if (this._flashScopeDisabled) {
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean alreadySet = (Boolean)requestMap.get(FLASH_REDIRECT);
        Boolean bl = alreadySet = alreadySet == null ? Boolean.FALSE : Boolean.TRUE;
        if (!alreadySet.booleanValue() && redirect) {
            requestMap.put(FLASH_REDIRECT, Boolean.TRUE);
            this._saveRedirectValue(facesContext);
        } else if (alreadySet.booleanValue()) {
            log.warning("Multiple call to setRedirect() ignored.");
        } else {
            log.warning("Ignored call to setRedirect(false), because this should only be set to true by the NavigationHandler. No one else should change it.");
        }
    }

    public void keep(String key) {
        Map<String, Object> executeMap;
        this._checkFlashScopeDisabled();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object value = requestMap.get(key);
        if (value == null && (executeMap = this._getExecuteFlashMap(facesContext)) != null) {
            value = executeMap.get(key);
            requestMap.put(key, value);
        }
        this._getRenderFlashMap(facesContext).put(key, value);
        facesContext.getApplication().publishEvent(facesContext, PostKeepFlashValueEvent.class, (Object)key);
    }

    public void putNow(String key, Object value) {
        this._checkFlashScopeDisabled();
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(key, value);
    }

    public boolean isKeepMessages() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Boolean keepMessages = null;
        if (facesContext != null) {
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestMap = externalContext.getRequestMap();
            keepMessages = (Boolean)requestMap.get(FLASH_KEEP_MESSAGES);
        }
        return keepMessages == null ? Boolean.FALSE : keepMessages;
    }

    public void setKeepMessages(boolean keepMessages) {
        if (this._flashScopeDisabled) {
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        requestMap.put(FLASH_KEEP_MESSAGES, keepMessages);
    }

    public void clear() {
        this._checkFlashScopeDisabled();
        this._getFlashMapForWriting().clear();
    }

    public boolean containsKey(Object key) {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().containsKey(key);
    }

    public boolean containsValue(Object value) {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().entrySet();
    }

    public Object get(Object key) {
        this._checkFlashScopeDisabled();
        if (key == null) {
            return null;
        }
        if ("keepMessages".equals(key)) {
            return this.isKeepMessages();
        }
        if ("redirect".equals(key)) {
            return this.isRedirect();
        }
        return this._getFlashMapForReading().get(key);
    }

    public boolean isEmpty() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().isEmpty();
    }

    public Set<String> keySet() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().keySet();
    }

    public Object put(String key, Object value) {
        this._checkFlashScopeDisabled();
        if (key == null) {
            return null;
        }
        if ("keepMessages".equals(key)) {
            Boolean booleanValue = this._convertToBoolean(value);
            this.setKeepMessages(booleanValue);
            return booleanValue;
        }
        if ("redirect".equals(key)) {
            Boolean booleanValue = this._convertToBoolean(value);
            this.setRedirect(booleanValue);
            return booleanValue;
        }
        Object resp = this._getFlashMapForWriting().put(key, value);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getApplication().publishEvent(facesContext, PostPutFlashValueEvent.class, (Object)key);
        return resp;
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        this._checkFlashScopeDisabled();
        this._getFlashMapForWriting().putAll(m);
    }

    public Object remove(Object key) {
        this._checkFlashScopeDisabled();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getApplication().publishEvent(facesContext, PreRemoveFlashValueEvent.class, key);
        return this._getFlashMapForWriting().remove(key);
    }

    public int size() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().size();
    }

    public Collection<Object> values() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().values();
    }

    private boolean _isLastPhaseInRequest(FacesContext facesContext) {
        PhaseId currentPhaseId = facesContext.getCurrentPhaseId();
        boolean lastPhaseNormalRequest = PhaseId.RENDER_RESPONSE.equals(currentPhaseId);
        boolean lastPhaseIfRedirect = facesContext.getResponseComplete() && this._isRedirectTrueOnThisRequest(facesContext);
        return lastPhaseNormalRequest || lastPhaseIfRedirect;
    }

    private boolean _isRedirectTrueOnThisRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean redirect = (Boolean)requestMap.get(FLASH_REDIRECT);
        return Boolean.TRUE.equals(redirect);
    }

    private boolean _isRedirectTrueOnPreviousRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean redirect = (Boolean)requestMap.get(FLASH_PREVIOUS_REQUEST_REDIRECT);
        return Boolean.TRUE.equals(redirect);
    }

    private void _saveRedirectValue(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
        if (httpResponse != null) {
            Cookie cookie = this._createFlashCookie(FLASH_REDIRECT, "true", externalContext);
            httpResponse.addCookie(cookie);
        } else {
            externalContext.getSessionMap().put(FLASH_REDIRECT, true);
        }
    }

    private void _restoreRedirectValue(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
        if (httpResponse != null) {
            Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(FLASH_REDIRECT);
            if (cookie != null) {
                externalContext.getRequestMap().put(FLASH_PREVIOUS_REQUEST_REDIRECT, Boolean.TRUE);
                cookie.setMaxAge(0);
                cookie.setPath(this._getCookiePath(externalContext));
                httpResponse.addCookie(cookie);
            }
        } else {
            Map sessionMap = externalContext.getSessionMap();
            Boolean redirect = (Boolean)sessionMap.remove(FLASH_REDIRECT);
            externalContext.getRequestMap().put(FLASH_PREVIOUS_REQUEST_REDIRECT, redirect);
        }
    }

    private void _saveMessages(FacesContext facesContext) {
        if (this.isKeepMessages()) {
            ArrayList<MessageEntry> messageList = null;
            Iterator iterClientIds = facesContext.getClientIdsWithMessages();
            while (iterClientIds.hasNext()) {
                String clientId = (String)iterClientIds.next();
                Iterator iterMessages = facesContext.getMessages(clientId);
                while (iterMessages.hasNext()) {
                    FacesMessage message = (FacesMessage)iterMessages.next();
                    if (messageList == null) {
                        messageList = new ArrayList<MessageEntry>();
                    }
                    messageList.add(new MessageEntry(clientId, message));
                }
            }
            this._getRenderFlashMap(facesContext).put(FLASH_KEEP_MESSAGES_LIST, messageList);
        } else {
            this._getRenderFlashMap(facesContext).remove(FLASH_KEEP_MESSAGES_LIST);
        }
    }

    private void _restoreMessages(FacesContext facesContext) {
        List messageList = (List)this._getExecuteFlashMap(facesContext).get(FLASH_KEEP_MESSAGES_LIST);
        if (messageList != null) {
            for (MessageEntry entry : messageList) {
                facesContext.addMessage(entry.clientId, entry.message);
            }
            this._getExecuteFlashMap(facesContext).remove(FLASH_KEEP_MESSAGES_LIST);
        }
    }

    private void _saveRenderFlashMapTokenForNextRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String tokenValue = (String)externalContext.getRequestMap().get(FLASH_RENDER_MAP_TOKEN);
        ClientWindow clientWindow = externalContext.getClientWindow();
        if (clientWindow != null && !this._clientWindowUrlModeEnabled) {
            if (facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext)) {
                Map sessionMap = externalContext.getSessionMap();
                sessionMap.put("oam.Flash.RENDERMAP.TOKEN." + clientWindow.getId(), tokenValue);
            } else {
                FlashClientWindowTokenCollection lruMap = this.getFlashClientWindowTokenCollection(externalContext, true);
                if (lruMap != null) {
                    lruMap.put(clientWindow.getId(), tokenValue);
                }
            }
        } else {
            HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
            if (httpResponse != null) {
                Cookie cookie = this._createFlashCookie(FLASH_RENDER_MAP_TOKEN, tokenValue, externalContext);
                httpResponse.addCookie(cookie);
            } else {
                Map sessionMap = externalContext.getSessionMap();
                sessionMap.put(FLASH_RENDER_MAP_TOKEN, tokenValue);
            }
        }
    }

    private String _getRenderFlashMapTokenFromPreviousRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String tokenValue = null;
        ClientWindow clientWindow = externalContext.getClientWindow();
        if (clientWindow != null && !this._clientWindowUrlModeEnabled) {
            if (facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext)) {
                Map sessionMap = externalContext.getSessionMap();
                tokenValue = (String)sessionMap.get("oam.Flash.RENDERMAP.TOKEN." + clientWindow.getId());
            } else {
                FlashClientWindowTokenCollection lruMap = this.getFlashClientWindowTokenCollection(externalContext, false);
                if (lruMap != null) {
                    tokenValue = lruMap.get(clientWindow.getId());
                }
            }
        } else {
            HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
            if (httpResponse != null) {
                Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(FLASH_RENDER_MAP_TOKEN);
                if (cookie != null) {
                    tokenValue = cookie.getValue();
                }
            } else {
                Map sessionMap = externalContext.getSessionMap();
                tokenValue = (String)sessionMap.get(FLASH_RENDER_MAP_TOKEN);
            }
        }
        return tokenValue;
    }

    private void _manageFlashMapTokens(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        TokenGenerator tokenGenerator = new TokenGenerator();
        String previousRenderToken = this._getRenderFlashMapTokenFromPreviousRequest(facesContext);
        if (previousRenderToken != null) {
            requestMap.put(FLASH_EXECUTE_MAP_TOKEN, previousRenderToken);
        } else {
            if (facesContext.isPostback()) {
                if (facesContext.getExternalContext().getClientWindow() == null) {
                    log.warning("Identifier for execute FlashMap was lost on the postback, thus FlashScope information is gone.");
                } else {
                    requestMap.put(FLASH_EXECUTE_MAP_TOKEN, tokenGenerator.getNextToken());
                }
            }
            requestMap.put(FLASH_EXECUTE_MAP_TOKEN, tokenGenerator.getNextToken());
        }
        requestMap.put(FLASH_RENDER_MAP_TOKEN, tokenGenerator.getNextToken());
        this._saveRenderFlashMapTokenForNextRequest(facesContext);
    }

    private Map<String, Object> _createSubKeyMap(FacesContext context, String prefix) {
        ExternalContext external = context.getExternalContext();
        Map sessionMap = external.getSessionMap();
        return new SubKeyMap<Object>(sessionMap, prefix);
    }

    private Map<String, Object> _getRenderFlashMap(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Map<String, Object> map = (Map<String, Object>)requestMap.get(FLASH_RENDER_MAP);
        if (map == null) {
            String token = (String)requestMap.get(FLASH_RENDER_MAP_TOKEN);
            String fullToken = "oam.Flash.SCOPE." + token + ".";
            map = this._createSubKeyMap(context, fullToken);
            requestMap.put(FLASH_RENDER_MAP, map);
        }
        return map;
    }

    private Map<String, Object> _getExecuteFlashMap(FacesContext context) {
        Map<Object, Object> map;
        Map requestMap = context != null && context.getExternalContext() != null ? context.getExternalContext().getRequestMap() : null;
        Map map2 = map = requestMap != null ? (Map)requestMap.get(FLASH_EXECUTE_MAP) : null;
        if (map == null) {
            if (requestMap != null) {
                String token = (String)requestMap.get(FLASH_EXECUTE_MAP_TOKEN);
                String fullToken = "oam.Flash.SCOPE." + token + ".";
                map = this._createSubKeyMap(context, fullToken);
                requestMap.put(FLASH_EXECUTE_MAP, map);
            } else {
                map = Collections.emptyMap();
            }
        }
        return map;
    }

    private Map<String, Object> _getActiveFlashMap() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (PhaseId.RENDER_RESPONSE.equals(facesContext.getCurrentPhaseId()) || !facesContext.isPostback()) {
            return this._getRenderFlashMap(facesContext);
        }
        return this._getExecuteFlashMap(facesContext);
    }

    private Map<String, Object> _getFlashMapForReading() {
        return this._getExecuteFlashMap(FacesContext.getCurrentInstance());
    }

    private Map<String, Object> _getFlashMapForWriting() {
        return this._getActiveFlashMap();
    }

    private void _clearExecuteFlashMap(FacesContext facesContext) {
        Map<String, Object> map = this._getExecuteFlashMap(facesContext);
        if (!map.isEmpty()) {
            facesContext.getApplication().publishEvent(facesContext, PreClearFlashEvent.class, map);
            map.clear();
        }
    }

    private void _clearRenderFlashTokenIfMapEmpty(FacesContext facesContext) {
        Map<String, Object> map;
        ExternalContext externalContext = facesContext.getExternalContext();
        Object session = facesContext.getExternalContext().getSession(false);
        ClientWindow clientWindow = externalContext.getClientWindow();
        if (session != null && clientWindow != null && (map = this._getRenderFlashMap(facesContext)).isEmpty()) {
            if (facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext)) {
                Map sessionMap = externalContext.getSessionMap();
                sessionMap.remove("oam.Flash.RENDERMAP.TOKEN." + clientWindow.getId());
            } else {
                FlashClientWindowTokenCollection lruMap = this.getFlashClientWindowTokenCollection(externalContext, false);
                if (lruMap != null) {
                    lruMap.remove(clientWindow.getId());
                    Map sessionMap = externalContext.getSessionMap();
                    if (lruMap.isEmpty()) {
                        sessionMap.remove(FLASH_CW_LRU_MAP);
                    } else {
                        sessionMap.put(FLASH_CW_LRU_MAP, lruMap);
                    }
                }
            }
        }
    }

    protected FlashClientWindowTokenCollection getFlashClientWindowTokenCollection(ExternalContext externalContext, boolean create) {
        HttpServletResponse response;
        Object session = externalContext.getSession(false);
        if (session == null && !create) {
            return null;
        }
        if (session == null && externalContext.getResponse() instanceof HttpServletResponse && (response = (HttpServletResponse)externalContext.getResponse()).isCommitted()) {
            return null;
        }
        Map sessionMap = externalContext.getSessionMap();
        FlashClientWindowTokenCollection lruMap = (FlashClientWindowTokenCollection)sessionMap.get(FLASH_CW_LRU_MAP);
        if (lruMap == null) {
            Integer numberOfFlashTokensInSession = MyfacesConfig.getCurrentInstance(externalContext).getNumberOfFlashTokensInSession();
            lruMap = new FlashClientWindowTokenCollection(numberOfFlashTokensInSession);
        }
        if (create) {
            sessionMap.put(FLASH_CW_LRU_MAP, lruMap);
        }
        return lruMap;
    }

    @Override
    public void clearFlashMap(FacesContext facesContext, String clientWindowId, String token) {
        ExternalContext externalContext;
        ClientWindow clientWindow;
        if (!(this._flashScopeDisabled || facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext) || (clientWindow = (externalContext = facesContext.getExternalContext()).getClientWindow()) == null || this._clientWindowUrlModeEnabled || token == null)) {
            String fullToken = "oam.Flash.SCOPE." + token + ".";
            Map<String, Object> map = this._createSubKeyMap(facesContext, fullToken);
            map.clear();
        }
    }

    private Cookie _createFlashCookie(String name, String value, ExternalContext externalContext) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(-1);
        cookie.setPath(this._getCookiePath(externalContext));
        cookie.setSecure(externalContext.isSecure());
        cookie.setHttpOnly(true);
        Object context = externalContext.getContext();
        if (context instanceof ServletContext && ExternalSpecifications.isServlet6Available()) {
            ServletContext servletContext = (ServletContext)context;
            String sameSite = servletContext.getSessionCookieConfig().getAttribute("SameSite");
            cookie.setAttribute("SameSite", Objects.toString(sameSite, "Strict"));
        }
        return cookie;
    }

    private String _getCookiePath(ExternalContext externalContext) {
        String contextPath = externalContext.getRequestContextPath();
        if (StringUtils.isEmpty(contextPath)) {
            contextPath = "/";
        }
        return contextPath;
    }

    private Boolean _convertToBoolean(Object value) {
        Boolean booleanValue = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
        return booleanValue;
    }

    private void _checkFlashScopeDisabled() {
        if (this._flashScopeDisabled) {
            throw new FlashScopeDisabledException("Flash scope was disabled by context param org.apache.myfaces.FLASH_SCOPE_DISABLED but erroneously accessed");
        }
    }

    private static class MessageEntry
    implements Serializable {
        private static final long serialVersionUID = -690264660230199234L;
        private final String clientId;
        private final FacesMessage message;

        public MessageEntry(String clientId, FacesMessage message) {
            this.clientId = clientId;
            this.message = message;
        }
    }
}

