/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.renderkit.renderer.MessageLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.sanitizer.SanitizeMode;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class OutRenderer
extends MessageLayoutRendererBase {
    @Override
    public void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIOut out = (AbstractUIOut)component;
        String text = RenderUtils.currentValue((UIComponent)out);
        if (text == null) {
            text = "";
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        boolean escape = out.isEscape();
        boolean keepLineBreaks = out.isKeepLineBreaks();
        boolean plain = out.isPlain() || out.isCompact() || !out.isCreateSpan();
        Markup markup = out.getMarkup();
        if (!plain) {
            writer.startElement(HtmlElements.SPAN);
            if (out.isLabelLayoutSkip()) {
                writer.writeIdAttribute(out.getClientId());
                writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
            }
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)out);
            writer.writeClassAttribute((CssItem)TobagoClass.OUT, TobagoClass.OUT.createMarkup(markup), this.getCssItems(facesContext, out), new CssItem[]{BootstrapClass.textColor(markup), BootstrapClass.fontStyle(markup), out.getCustomClass()});
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)out);
            if (title != null) {
                writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            }
        }
        if (escape) {
            if (keepLineBreaks) {
                StringTokenizer tokenizer = new StringTokenizer(text, "\r\n");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    writer.writeText(token);
                    if (!tokenizer.hasMoreTokens()) continue;
                    writer.startElement(HtmlElements.BR);
                    writer.endElement(HtmlElements.BR);
                }
            } else {
                writer.writeText(text);
            }
        } else {
            writer.writeText("", null);
            if (SanitizeMode.auto == out.getSanitize()) {
                Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
                text = sanitizer.sanitize(text);
            }
            writer.write(text);
        }
    }

    @Override
    public void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        boolean plain;
        AbstractUIOut out = (AbstractUIOut)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        boolean bl = plain = out.isPlain() || out.isCompact() || !out.isCreateSpan();
        if (!plain) {
            writer.endElement(HtmlElements.SPAN);
        }
    }

    @Override
    protected String getFieldId(FacesContext facesContext, UIComponent component) {
        return component.getClientId(facesContext);
    }

    protected CssItem[] getCssItems(FacesContext facesContext, AbstractUIOut out) {
        return new CssItem[]{BootstrapClass.FORM_CONTROL_PLAINTEXT};
    }
}

