/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.component.UIXTreeTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public final class TreeTableRenderingContext
extends TableRenderingContext {
    private final UIXTreeTable _hGridBase;
    private final Object _crumbs;
    private final UIComponent _nodeStamp;
    private final UIComponent _pathStamp;
    private final int _spacerWidth;
    private final boolean _rootNodeRendered;
    private static final int _DEFAULT_SPACER_WIDTH = 18;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TreeTableRenderingContext.class);

    public static TreeTableRenderingContext getInstance() {
        TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
        return tContext instanceof TreeTableRenderingContext ? (TreeTableRenderingContext)tContext : null;
    }

    public TreeTableRenderingContext(FacesContext context, RenderingContext arc, UIComponent hGrid) {
        super(context, arc, hGrid);
        this._hGridBase = (UIXTreeTable)hGrid;
        this._pathStamp = this._hGridBase.getFacet("pathStamp");
        UIComponent nodeStamp = this._hGridBase.getNodeStamp();
        if (nodeStamp instanceof UIXColumn) {
            this._nodeStamp = nodeStamp;
        } else {
            _LOG.warning("NODESTAMP_FACET_ON_TREETABLE_MISSING_OR_NOT_UIXCOLUMN_TYPE", (Object)this.getTableId());
            this._nodeStamp = null;
        }
        this._crumbs = TreeUtils.getFocusRowKey(this._hGridBase);
        Number spacerWidth = (Number)arc.getSkin().getProperty((Object)"af|treeTable-tr-spacer-width");
        this._spacerWidth = spacerWidth != null ? spacerWidth.intValue() : 18;
        this._rootNodeRendered = this._hGridBase.isRootNodeRendered();
    }

    @Override
    public RowKeySet getSelectedRowKeys() {
        return ((UIXTree)this.getCollectionComponent()).getSelectedRowKeys();
    }

    public Object getFocusRowKey() {
        return this._crumbs;
    }

    public UIComponent getTreeNodeStamp() {
        return this._nodeStamp;
    }

    public boolean isFocusColumnVisible() {
        return this._pathStamp != null;
    }

    @Override
    public int getSpecialColumnCount() {
        return super.getSpecialColumnCount() + (this.isFocusColumnVisible() ? 2 : 1);
    }

    @Override
    public UIComponent getDetail() {
        return null;
    }

    public UIXTreeTable getUIXTreeTable() {
        return this._hGridBase;
    }

    public int getSpacerWidth() {
        return this._spacerWidth;
    }

    public boolean isRootNodeRendered() {
        return this._rootNodeRendered;
    }
}

