/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style;

import java.util.Collections;
import java.util.Map;
import org.apache.myfaces.trinidad.style.Style;

public class UnmodifiableStyle
extends Style {
    private volatile transient String _inline;
    private final Map<String, String> _propertiesMap;
    private static final int _DEFAULT_BUFFER_SIZE = 100;

    public UnmodifiableStyle(Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties must be non-null");
        }
        this._propertiesMap = Collections.unmodifiableMap(properties);
    }

    public Map<String, String> getProperties() {
        return this._propertiesMap;
    }

    public String toInlineString() {
        String inline = this._inline;
        if (inline != null) {
            return inline;
        }
        Map<String, String> properties = this.getProperties();
        StringBuffer buffer = new StringBuffer(100);
        boolean first = true;
        for (Map.Entry<String, String> entrySet : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(";");
            }
            String name = entrySet.getKey();
            String value = entrySet.getValue();
            buffer.append(name);
            buffer.append(":");
            buffer.append(value);
        }
        this._inline = inline = buffer.toString();
        return inline;
    }

    public String toString() {
        return "UnmodifiableStyle[css=" + this.toInlineString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnmodifiableStyle)) {
            return false;
        }
        UnmodifiableStyle test = (UnmodifiableStyle)((Object)obj);
        return ((Object)this._propertiesMap).equals(test._propertiesMap);
    }

    public int hashCode() {
        return ((Object)this._propertiesMap).hashCode();
    }
}

